/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SaleGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.SaleBL.Tender;

public class TenderCash
extends Activity {
    private int[] coinage = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000};
    private int amountDue = 0;
    private int amountTendered = 0;
    private int changeDue = 0;
    private TextView[] txtValues = new TextView[9];
    private LinearLayout[] cmdValues = new LinearLayout[9];

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_tendercash);
        TenderCash context = this;
        final AppContext bb = (AppContext)this.getApplicationContext();
        bb.basket.refreshBasket(bb);
        this.amountDue = bb.basket.balanceDue;
        this.amountTendered = 0;
        this.changeDue = 0;
        this.txtValues[0] = (TextView)this.findViewById(R.id.txtValue0);
        this.txtValues[1] = (TextView)this.findViewById(R.id.txtValue1);
        this.txtValues[2] = (TextView)this.findViewById(R.id.txtValue2);
        this.txtValues[3] = (TextView)this.findViewById(R.id.txtValue3);
        this.txtValues[4] = (TextView)this.findViewById(R.id.txtValue4);
        this.txtValues[5] = (TextView)this.findViewById(R.id.txtValue5);
        this.txtValues[6] = (TextView)this.findViewById(R.id.txtValue6);
        this.txtValues[7] = (TextView)this.findViewById(R.id.txtValue7);
        this.txtValues[8] = (TextView)this.findViewById(R.id.txtValue8);
        this.cmdValues[0] = (LinearLayout)this.findViewById(R.id.cmdValue0);
        this.cmdValues[1] = (LinearLayout)this.findViewById(R.id.cmdValue1);
        this.cmdValues[2] = (LinearLayout)this.findViewById(R.id.cmdValue2);
        this.cmdValues[3] = (LinearLayout)this.findViewById(R.id.cmdValue3);
        this.cmdValues[4] = (LinearLayout)this.findViewById(R.id.cmdValue4);
        this.cmdValues[5] = (LinearLayout)this.findViewById(R.id.cmdValue5);
        this.cmdValues[6] = (LinearLayout)this.findViewById(R.id.cmdValue6);
        this.cmdValues[7] = (LinearLayout)this.findViewById(R.id.cmdValue7);
        this.cmdValues[8] = (LinearLayout)this.findViewById(R.id.cmdValue8);
        this.setTitle(" Tender Cash");
        this.cmdValues[0].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[0].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
                TenderCash.this.doTender(bb);
                Intent returnIntent = new Intent();
                returnIntent.putExtra("result", "Done");
                TenderCash.this.setResult(-1, returnIntent);
                TenderCash.this.finish();
            }
        });
        this.cmdValues[1].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[1].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[2].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[2].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[3].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[3].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[4].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[4].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[5].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[5].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[6].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[6].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[7].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[7].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        this.cmdValues[8].setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String txtAmount = String.valueOf(TenderCash.this.txtValues[8].getText());
                TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                TenderCash.this.refreshData();
            }
        });
        LinearLayout layAmountDue = (LinearLayout)this.findViewById(R.id.layAmountDue);
        layAmountDue.setOnClickListener(new View.OnClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onClick(View view) {
                LayoutInflater layoutInflater = LayoutInflater.from((Context)this.val$context);
                View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);
                AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.val$context);
                alertDialogBuilder.setView(promptView);
                final EditText input = (EditText)promptView.findViewById(R.id.userInput);
                alertDialogBuilder.setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        String txtAmount = String.valueOf(input.getText());
                        TenderCash.this.amountDue = TenderCash.this.currencyStringInt(txtAmount);
                        TenderCash.this.refreshData();
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog alertD = alertDialogBuilder.create();
                alertD.show();
                alertD.getWindow().clearFlags(131080);
                alertD.getWindow().setSoftInputMode(5);
            }
        });
        LinearLayout layTendered = (LinearLayout)this.findViewById(R.id.layTendered);
        layTendered.setOnClickListener(new View.OnClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onClick(View view) {
                LayoutInflater layoutInflater = LayoutInflater.from((Context)this.val$context);
                View promptView = layoutInflater.inflate(R.layout.currency_prompt, null);
                AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.val$context);
                alertDialogBuilder.setView(promptView);
                final EditText input = (EditText)promptView.findViewById(R.id.userInput);
                alertDialogBuilder.setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        String txtAmount = String.valueOf(input.getText());
                        TenderCash.this.amountTendered = TenderCash.this.currencyStringInt(txtAmount);
                        TenderCash.this.refreshData();
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        dialog.cancel();
                    }
                });
                AlertDialog alertD = alertDialogBuilder.create();
                alertD.show();
                alertD.getWindow().clearFlags(131080);
                alertD.getWindow().setSoftInputMode(5);
            }
        });
        this.refreshData();
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        cmdDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TenderCash.this.doTender(bb);
                Intent returnIntent = new Intent();
                returnIntent.putExtra("result", "Done");
                TenderCash.this.setResult(-1, returnIntent);
                TenderCash.this.finish();
            }
        });
    }

    private void doTender(AppContext bb) {
        Tender cash = new Tender();
        cash.tenderValue = this.amountTendered;
        cash.tenderType = Tender.TenderType.CASH;
        bb.basket.addTender(cash, this.amountTendered);
        if (this.changeDue != 0) {
            Tender change = new Tender();
            change.tenderValue = this.changeDue;
            change.tenderType = Tender.TenderType.CHANGE;
            bb.basket.addTender(change, this.changeDue);
        }
        bb.basket.refreshBasket(bb);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    private void refreshData() {
        int i;
        TextView txtAmountDue = (TextView)this.findViewById(R.id.txtAmountDue);
        TextView txtAmountTendered = (TextView)this.findViewById(R.id.txtAmountTendered);
        TextView txtChangeDue = (TextView)this.findViewById(R.id.txtChangeDue);
        double intCost = (double)this.amountDue / 100.0;
        txtAmountDue.setText((CharSequence)String.format("\u00a3%.2f", intCost));
        int[] suggestions = new int[this.coinage.length];
        int value = 0;
        suggestions[value] = this.amountDue;
        for (i = 0; i < this.coinage.length; ++i) {
            int suggestion;
            int denomination = this.coinage[i];
            if (this.amountDue % denomination == 0 || (suggestion = (this.amountDue / denomination + 1) * denomination) == suggestions[value]) continue;
            suggestions[++value] = suggestion;
        }
        for (i = 0; i < 9; ++i) {
            if (i > value) {
                this.cmdValues[i].setVisibility(4);
                continue;
            }
            this.cmdValues[i].setVisibility(0);
            intCost = (double)suggestions[i] / 100.0;
            this.txtValues[i].setText((CharSequence)String.format("\ufffd%.2f", intCost));
        }
        if (this.amountTendered != 0) {
            intCost = (double)this.amountTendered / 100.0;
            txtAmountTendered.setText((CharSequence)String.format("\ufffd%.2f", intCost));
            if (this.amountTendered >= this.amountDue) {
                this.changeDue = this.amountDue - this.amountTendered;
                intCost = (double)this.changeDue / 100.0;
                txtChangeDue.setText((CharSequence)String.format("\ufffd%.2f", intCost));
            } else {
                txtChangeDue.setText((CharSequence)"");
            }
        } else {
            txtAmountTendered.setText((CharSequence)"");
            txtChangeDue.setText((CharSequence)"");
        }
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        if (this.amountTendered > 0) {
            cmdDone.setEnabled(true);
            cmdDone.setBackgroundColor(this.JMgetColor(R.color.button_background, this.getTheme()));
        } else {
            cmdDone.setEnabled(false);
            cmdDone.setBackgroundColor(this.JMgetColor(R.color.button_background_disabled, this.getTheme()));
        }
    }

    private int currencyStringInt(String txtIn) {
        String txtStriped = txtIn.replace("\ufffd", "").trim();
        if (txtStriped.length() == 0) {
            return 0;
        }
        Float floatAmount = Float.valueOf(Float.parseFloat(txtStriped));
        int adjustedAmount = (int)(floatAmount.floatValue() * 100.0f);
        return adjustedAmount;
    }
}

