/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SupportBL;

import android.util.Log;
import com.example.twolibs.DataTransferBL.DataTransferManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class TraceHandler {
    private static String CLASS_NAME = "TraceHandler";
    private static OutputStreamWriter file = null;

    public static void startTrace() {
        String FUNC_NAME = "startTrace";
        Log.e((String)CLASS_NAME, (String)"startTrace ENTRY");
        String traceFile = DataTransferManager.getFileName(DataTransferManager.FileType.TRACELOG);
        try {
            file = new OutputStreamWriter(new FileOutputStream(traceFile));
            file.write("TRACE STARTED");
            file.flush();
        }
        catch (Exception e) {
            Log.e((String)CLASS_NAME, (String)e.getMessage());
        }
    }

    public static void Trace(TraceLevel pTraceLevel, String pClassName, String pFuncName, Category pCategory, String pDetails, int pTruncateToChars) {
        StringBuilder msg = new StringBuilder(1024);
        msg.append(pFuncName);
        msg.append(":");
        if (pCategory == Category.GUI) {
            msg.append(">>>");
        }
        msg.append((Object)pCategory);
        if (pTruncateToChars > 0) {
            msg.append(pDetails.substring(1, Math.min(pTruncateToChars, pDetails.length())));
        } else {
            msg.append(pDetails);
        }
        switch (pTraceLevel) {
            case ERROR: {
                Log.e((String)pClassName, (String)msg.toString());
                if (file != null) {
                    try {
                        file.write(msg.toString());
                        file.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            case WARNING: {
                Log.w((String)pClassName, (String)msg.toString());
                if (file != null) {
                    try {
                        file.write(msg.toString());
                        file.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            case DEBUG: {
                Log.d((String)pClassName, (String)msg.toString());
                if (file != null) {
                    try {
                        file.write(msg.toString());
                        file.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    public static enum TraceLevel {
        ERROR,
        WARNING,
        DEBUG;

    }

    public static enum Category {
        ERROREXIT,
        ENTRY,
        EXIT,
        GUI;

    }
}

