/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SupportGUI;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.TimeTableGUI.TimeTableCriteria;
import java.util.Date;

public class ClockPicker
extends Activity {
    Activity activity;
    int dayhours = 0;
    int lastHours = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_time);
        this.setTitle(" Time");
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.activity = this.getParent();
        if (bb.getSearchDirection() == 0) {
            RadioButton cmdDepart = (RadioButton)this.findViewById(R.id.cmdDepart);
            cmdDepart.setChecked(true);
        } else {
            RadioButton cmdArrive = (RadioButton)this.findViewById(R.id.cmdArrive);
            cmdArrive.setChecked(true);
        }
        TextView txtTime = (TextView)this.findViewById(R.id.txtTime);
        Date searchDate = bb.getSearchDate();
        int hours = DataConvert.getHourOfDay(searchDate);
        int minutes = DataConvert.getMinute(searchDate);
        this.dayhours = hours > 12 ? 12 : 0;
        ImageView imh = (ImageView)this.findViewById(R.id.clockhour);
        this.lastHours = hours;
        imh.setImageLevel(hours);
        ImageView imm = (ImageView)this.findViewById(R.id.clockminute);
        imm.setImageLevel(minutes / 5);
        txtTime.setText((CharSequence)DataConvert.displayTextTime(searchDate));
        Button cmdSet = (Button)this.findViewById(R.id.cmdSet);
        cmdSet.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ClockPicker.this.dispatchKeyEvent(new KeyEvent(0, 4));
                ClockPicker.this.dispatchKeyEvent(new KeyEvent(1, 4));
            }
        });
        FrameLayout mFrameHour = (FrameLayout)this.findViewById(R.id.clockframehour);
        mFrameHour.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ImageView img = (ImageView)ClockPicker.this.findViewById(R.id.clockhour);
                int[] viewCoordsV = new int[2];
                v.getLocationOnScreen(viewCoordsV);
                double ex = event.getX() - 120.0f;
                double ey = event.getY() - 0.0f;
                if (ex > (double)img.getWidth()) {
                    ex = img.getWidth();
                } else if (ex < 0.0) {
                    ex = 0.0;
                }
                if (ey > (double)img.getHeight()) {
                    ey = img.getHeight();
                } else if (ex < 0.0) {
                    ey = 0.0;
                }
                double x = 0.5 - ex / (double)img.getWidth();
                double y = 0.5 - ey / (double)img.getWidth();
                double theta = Math.atan2(y, x);
                double radius = Math.hypot(x, y);
                int iHour = 0;
                if ((iHour += (int)((theta + 5.026548245743669) / (Math.PI * 2) * 12.0)) > 12) {
                    iHour -= 12;
                }
                boolean bSetTime = false;
                if (radius > 0.55) {
                    if (iHour == 7 || iHour == 8) {
                        ClockPicker.this.dayhours = 0;
                    }
                    if (iHour == 4 || iHour == 5) {
                        ClockPicker.this.dayhours = 12;
                    }
                } else {
                    bSetTime = true;
                }
                if (!bSetTime && (iHour = ClockPicker.this.lastHours) > 12) {
                    iHour -= 12;
                }
                img.setImageLevel(iHour += ClockPicker.this.dayhours);
                ClockPicker.this.lastHours = iHour;
                Date searchDate = bb.getSearchDate();
                int minute = DataConvert.getMinute(searchDate);
                bb.setSearchDate(DataConvert.setTime(searchDate, iHour, minute, 0));
                TextView txtTime = (TextView)ClockPicker.this.findViewById(R.id.txtTime);
                txtTime.setText((CharSequence)DataConvert.displayTextTime(bb.getSearchDate()));
                return true;
            }
        });
        FrameLayout mFrameMin = (FrameLayout)this.findViewById(R.id.clockframeminute);
        mFrameMin.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ImageView imm = (ImageView)ClockPicker.this.findViewById(R.id.clockminute);
                int[] viewCoordsV = new int[2];
                v.getLocationOnScreen(viewCoordsV);
                double ex = event.getX() - 120.0f;
                double ey = event.getY() - 0.0f;
                if (ex > (double)imm.getWidth()) {
                    ex = imm.getWidth();
                } else if (ex < 0.0) {
                    ex = 0.0;
                }
                if (ey > (double)imm.getHeight()) {
                    ey = imm.getHeight();
                } else if (ex < 0.0) {
                    ey = 0.0;
                }
                double x = 0.5 - ex / (double)imm.getWidth();
                double y = 0.5 - ey / (double)imm.getHeight();
                double theta = Math.atan2(y, x);
                double radius = Math.hypot(x, y);
                int iMinute = 0;
                if ((iMinute += (int)((theta + 5.026548245743669) / (Math.PI * 2) * 12.0)) > 12) {
                    iMinute -= 12;
                }
                if (iMinute == 12) {
                    iMinute = 0;
                }
                imm.setImageLevel(iMinute);
                Date searchDate = bb.getSearchDate();
                int hour = DataConvert.getHourOfDay(searchDate);
                bb.setSearchDate(DataConvert.setTime(searchDate, hour, iMinute * 5, 0));
                TextView txtTime = (TextView)ClockPicker.this.findViewById(R.id.txtTime);
                txtTime.setText((CharSequence)DataConvert.displayTextTime(bb.getSearchDate()));
                return true;
            }
        });
    }

    public Intent getParentActivityIntent() {
        Intent newIntent = null;
        String strDirection = this.getIntent().getStringExtra("search");
        newIntent = strDirection.equals("fares") ? new Intent(this.getApplicationContext(), FaresCriteria.class) : new Intent(this.getApplicationContext(), TimeTableCriteria.class);
        return newIntent;
    }

    public void onArriveDepartClicked(View view) {
        AppContext bb = (AppContext)this.getApplicationContext();
        boolean checked = ((RadioButton)view).isChecked();
        if (view.getId() == R.id.cmdDepart) {
            if (checked) {
                bb.setSearchDirection(0);
            }
        } else if (view.getId() == R.id.cmdArrive && checked) {
            bb.setSearchDirection(1);
        }
    }
}

