/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableBL;

import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.TimeTableBL.STDResponse;
import com.example.twolibs.TimeTableBL.SearchResponse;
import com.example.twolibs.TimeTableBL.TTSearchCriteria;
import com.example.twolibs.TimeTableBL.TTSearchResults;
import java.util.ArrayList;
import java.util.Date;

public class TTSearch {
    private static String TAG = "TTSearch";

    public STDResponse initialise(String locfile) {
        STDResponse resp = new STDResponse();
        resp.result = -1;
        resp.trace = "Begin";
        int iSWVersionSize = 3000;
        byte[] bSWVersion = this.StringToCBuff(iSWVersionSize, "");
        int iDataVersionSize = 3000;
        byte[] bDataVersion = this.StringToCBuff(iDataVersionSize, "");
        String traceFile = "/storage/emulated/0/com.example.TwoLibs/DefaultTimetableTrace.txt";
        resp.result = this.ttInit2(locfile, traceFile, bSWVersion, bDataVersion);
        resp.trace = locfile + " " + resp.result + " ";
        String sSWVersion = this.CBuffToString(iSWVersionSize, bSWVersion);
        String sDataVersion = this.CBuffToString(iDataVersionSize, bDataVersion);
        resp.extra = sSWVersion + "!" + sDataVersion;
        return resp;
    }

    public TTSearchCriteria setupDefaults(Location objOrigin, Location objDestination, Date searchDate, int searchDirection, int changes) {
        TTSearchCriteria TTCrit = new TTSearchCriteria();
        TTCrit.getOriginCRS().add(objOrigin.getCRS());
        TTCrit.getDestinationCRS().add(objDestination.getCRS());
        TTCrit.setSc_searchtype(searchDirection);
        TTCrit.setSc_targetdatetime(searchDate);
        TTCrit.setSc_earlierdatetimelimit(this.addMinutesToDate(-240, TTCrit.getSc_targetdatetime()));
        TTCrit.setSc_laterdatetimelimit(this.addMinutesToDate(240, TTCrit.getSc_targetdatetime()));
        if (TTCrit.getSc_searchtype() == 0) {
            TTCrit.setSc_cutdatetimelimit(this.addMinutesToDate(960, TTCrit.getSc_laterdatetimelimit()));
        } else {
            TTCrit.setSc_cutdatetimelimit(this.addMinutesToDate(-960, TTCrit.getSc_earlierdatetimelimit()));
        }
        TTCrit.setSc_restartinfodata(new byte[4]);
        TTCrit.setSc_originsignature(new byte[4]);
        TTCrit.setSc_destinationsignature(new byte[4]);
        TTCrit.setSc_minchangetime(-1);
        TTCrit.setSc_maxchanges(changes);
        TTCrit.setSc_numovertaken(4);
        TTCrit.setSc_changetradeoffmins(20);
        TTCrit.setSc_nonoptjourneyratio(2.7f);
        TTCrit.setSc_earlierjourneys(1);
        TTCrit.setSc_laterjourneys(2);
        return TTCrit;
    }

    public SearchResponse doSearch(TTSearchCriteria TTCrit) {
        SearchResponse resp = new SearchResponse();
        byte[] TTcritParam = TTCrit.StringToCBuff();
        int iReplySize = 3000;
        byte[] bReply = this.StringToCBuff(iReplySize, "");
        resp.trace = "Call ttsearch";
        resp.objTTsearchResults = this.ttSearchOld(TTcritParam, bReply);
        resp.trace = "Search done";
        resp.trace = "Result " + resp.objTTsearchResults.getSr_Result() + " ";
        for (String sMsg : resp.objTTsearchResults.getSr_errorquals()) {
            resp.trace = resp.trace + sMsg;
        }
        resp.trace = resp.trace + resp.objTTsearchResults.getSr_numjourneys();
        resp.extra = "Found " + resp.objTTsearchResults.getSr_numjourneys();
        return resp;
    }

    private Date addMinutesToDate(int minutes, Date beforeTime) {
        long ONE_MINUTE_IN_MILLIS = 60000L;
        long curTimeInMs = beforeTime.getTime();
        Date afterAddingMins = new Date(curTimeInMs + (long)minutes * 60000L);
        return afterAddingMins;
    }

    private byte[] StringToCBuff(int iSize, String sInput) {
        byte[] bNewBuffer = new byte[iSize];
        int l = sInput.length();
        if (l > iSize) {
            l = iSize;
        }
        if (l > 0) {
            int i;
            for (i = 0; i < l; ++i) {
                bNewBuffer[i] = (byte)sInput.charAt(i);
            }
            if (i >= l) {
                bNewBuffer[l - 1] = 0;
            } else {
                bNewBuffer[i] = 0;
            }
        }
        return bNewBuffer;
    }

    private String CBuffToString(int iSize, byte[] bInput) {
        StringBuilder sNew = new StringBuilder(iSize);
        for (int i = 0; i < iSize && bInput[i] != 0; ++i) {
            char ch = (char)bInput[i];
            sNew.append(ch);
        }
        return sNew.toString();
    }

    private ArrayList<Location> CBuffToLocations(int iSize, byte[] bInput) {
        StringBuilder sNew = new StringBuilder(200);
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList<Location> locList = new ArrayList<Location>();
        StringBuilder sField = new StringBuilder(200);
        Location loc = new Location();
        int iFieldNo = 0;
        block11: for (int i = 0; i < iSize && bInput[i] != 0; ++i) {
            char ch = (char)bInput[i];
            switch (ch) {
                case '|': {
                    switch (iFieldNo) {
                        case 0: {
                            loc.setNLC(sField.toString());
                            break;
                        }
                        case 1: {
                            loc.setCRS(sField.toString());
                            break;
                        }
                        case 2: {
                            loc.setSize(sField.toString());
                            break;
                        }
                        case 3: {
                            loc.setDescription(sField.toString());
                        }
                    }
                    sField = new StringBuilder(200);
                    ++iFieldNo;
                    sNew.append(ch);
                    continue block11;
                }
                case '\r': {
                    myList.add(sNew.toString());
                    sNew = new StringBuilder(200);
                    iFieldNo = 0;
                    locList.add(loc);
                    loc = new Location();
                    continue block11;
                }
                case '\n': {
                    continue block11;
                }
                default: {
                    sNew.append(ch);
                    sField.append(ch);
                }
            }
        }
        return locList;
    }

    public native int ttInit(String var1, byte[] var2, byte[] var3);

    public native int ttInit2(String var1, String var2, byte[] var3, byte[] var4);

    public native TTSearchResults ttSearchOld(byte[] var1, byte[] var2);
}

