/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableBL;

import com.example.twolibs.LocationBL.clsLocation;
import com.example.twolibs.TimeTableBL.clsCateringCodes;
import com.example.twolibs.TimeTableBL.clsIJQLeg;
import com.example.twolibs.TimeTableBL.clsIJQSplitJoin;
import com.example.twolibs.TimeTableBL.clsIJQTimetableLeg;
import com.example.twolibs.TimeTableBL.clsLeg;
import com.example.twolibs.TimeTableBL.clsPassStopEvent;
import com.example.twolibs.TimeTableBL.clsUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class clsTimetableLeg
extends clsLeg
implements Serializable {
    private static final long serialVersionUID = -4250070520127064526L;
    public Vector<clsPassStopEvent> passStop = new Vector();
    public boolean BHX;
    public boolean changeTakesTooLong = false;
    public boolean firstClassAvailable;
    public boolean stdClassAvailable;
    public boolean intercity;
    public byte[] legSignature;
    public boolean SO;
    public boolean SX;
    public boolean trainSplits;
    public Date arrival;
    public Date departure;
    public Date CATETrainEnd;
    public Date CATETrainStart;
    public int reservable;
    public int seats;
    public int sleeper;
    public clsCateringCodes cateringCodes = new clsCateringCodes();
    public clsLocation trainOrigin;
    public clsLocation trainDestination;
    public String trainOriginCode;
    public String trainDestinationCode;
    public String daysRunning;
    public String primaryTOC;
    public String reserveCode;
    public String retailTrainID;
    public String seatingCode;
    public String secondaryTOC;
    public String sectorCode;
    public String serviceBrand;
    public String sleeperCode;
    public String splitAt;
    public String stockType;
    public String trainArrival;
    public String trainDeparture;
    public String trainUID;

    public clsTimetableLeg() {
        this.arrival = new Date();
        this.departure = new Date();
    }

    public void setAttributes(clsIJQTimetableLeg TTleg) {
        this.legRef = TTleg.legRef;
        this.originCode = TTleg.originLocationCode;
        this.destinationCode = TTleg.destinationLocationCode;
        this.serviceType = TTleg.serviceType;
        this.BHX = TTleg.BHX;
        this.departure = TTleg.departure;
        this.arrival = TTleg.arrival;
        this.reservable = TTleg.reservable;
        this.seats = TTleg.seats;
        this.sleeper = TTleg.sleeper;
        this.cateringCodes = TTleg.cateringCodes;
        this.daysRunning = TTleg.daysRunning;
        this.trainOriginCode = TTleg.trainOriginLocationCode;
        this.trainDestinationCode = TTleg.trainDestLocationCode;
        this.primaryTOC = TTleg.primaryTOC;
        this.secondaryTOC = TTleg.secondaryTOC;
        this.sectorCode = TTleg.sectorCode;
        this.stockType = TTleg.stockType;
        this.trainDeparture = TTleg.trainDeparture;
        this.trainArrival = TTleg.trainArrival;
        this.trainUID = TTleg.trainUID;
        this.legSignature = TTleg.legSignature;
        this.trainSplits = TTleg.trainSplits;
        this.retailTrainID = TTleg.retailTrainID;
        this.intercity = "I".equals(TTleg.sectorCode);
        this.SO = "0000010".equals(TTleg.daysRunning);
        this.SX = "1111101".equals(TTleg.daysRunning);
        this.reserveCode = TTleg.reservable == 3 ? "S" : (TTleg.reservable == 1 ? "A" : (TTleg.reservable == 2 ? "R" : "N"));
        this.seatingCode = TTleg.seats == 2 ? "B" : (TTleg.seats == 4 ? "F" : (TTleg.seats == 1 ? "S" : " "));
        this.sleeperCode = TTleg.sleeper == 2 ? "B" : (TTleg.sleeper == 1 ? "F" : (TTleg.sleeper == 3 ? "S" : " "));
        if (this.seats == 2) {
            this.firstClassAvailable = true;
            this.stdClassAvailable = true;
        } else if (this.seats == 4) {
            this.firstClassAvailable = true;
            this.stdClassAvailable = this.sleeper == 3 || this.sleeper == 2;
        } else if (this.seats == 1) {
            this.stdClassAvailable = true;
            this.firstClassAvailable = this.sleeper == 1 || this.sleeper == 2;
        } else if (this.seats == 3) {
            this.firstClassAvailable = this.sleeper == 1 || this.sleeper == 2;
            this.stdClassAvailable = this.sleeper == 3 || this.sleeper == 2;
        }
    }

    @Override
    public clsIJQLeg giveIJQLeg() {
        clsIJQTimetableLeg leg = new clsIJQTimetableLeg();
        leg.legRef = this.legRef;
        leg.originLocationCode = this.originCode;
        leg.destinationLocationCode = this.destinationCode;
        leg.serviceType = this.serviceType;
        leg.departure = this.departure;
        leg.arrival = this.arrival;
        leg.trainOriginLocationCode = this.trainOriginCode;
        leg.trainDestLocationCode = this.trainDestinationCode;
        leg.trainDeparture = this.trainDeparture;
        leg.trainArrival = this.trainArrival;
        leg.BHX = this.BHX;
        leg.SO = this.SO;
        leg.SX = this.SX;
        leg.daysRunning = this.daysRunning;
        leg.primaryTOC = this.primaryTOC;
        leg.reservable = this.reservable;
        leg.cateringCodes = this.cateringCodes;
        leg.firstClassAvailable = this.firstClassAvailable;
        leg.stdClassAvailable = this.stdClassAvailable;
        leg.seats = this.seats;
        leg.sleeper = this.sleeper;
        leg.CATETrainStart = this.CATETrainStart;
        leg.CATETrainEnd = this.CATETrainEnd;
        leg.stockType = this.stockType;
        leg.interCity = this.intercity;
        leg.sectorCode = this.sectorCode;
        leg.secondaryTOC = this.secondaryTOC;
        leg.trainUID = this.trainUID;
        leg.legSignature = this.legSignature;
        leg.serviceBrand = this.serviceBrand;
        leg.trainSplits = this.trainSplits;
        leg.retailTrainID = this.retailTrainID;
        if (this.passStop != null && !this.passStop.isEmpty()) {
            ArrayList<clsIJQSplitJoin> splitJoinList = new ArrayList<clsIJQSplitJoin>();
            for (clsPassStopEvent passStopEvent : this.passStop) {
                if (passStopEvent.splitJoinIndicator == 0) continue;
                clsIJQSplitJoin splitJoin = new clsIJQSplitJoin();
                splitJoin.CRSCode = passStopEvent.CRSCode;
                splitJoin.splitJoinIndicator = passStopEvent.splitJoinIndicator;
                splitJoinList.add(splitJoin);
            }
            if (!splitJoinList.isEmpty()) {
                leg.splitJoinLocations = splitJoinList;
            }
        }
        return leg;
    }

    public Vector<clsTimetableLeg> splitLeg(clsPassStopEvent splitPoint) {
        Vector<clsTimetableLeg> legs = null;
        Vector<clsPassStopEvent> passStopPrior = new Vector<clsPassStopEvent>();
        Vector<clsPassStopEvent> passStopAfter = new Vector<clsPassStopEvent>();
        clsPassStopEvent passStopEventMatched = null;
        boolean passStopEventFound = false;
        for (clsPassStopEvent passStopEvent : this.passStop) {
            if (passStopEvent.CRSCode.equals(splitPoint.CRSCode)) {
                passStopEventMatched = passStopEvent;
                passStopEventFound = true;
            }
            if (passStopEventFound) {
                if (passStopEventMatched.CRSCode.equals(passStopEvent.CRSCode)) continue;
                passStopAfter.add(passStopEvent);
                continue;
            }
            passStopPrior.add(passStopEvent);
        }
        if (!passStopEventFound) {
            return null;
        }
        legs = new Vector<clsTimetableLeg>();
        Date arrivalTime = clsUtilities.setTimeZero(this.departure);
        Calendar arrivalTimeCal = Calendar.getInstance();
        arrivalTimeCal.setTime(this.departure);
        arrivalTimeCal.set(11, Integer.parseInt(passStopEventMatched.eventTime.substring(0, 2)));
        arrivalTimeCal.set(12, Integer.parseInt(passStopEventMatched.eventTime.substring(2, 4)));
        if (this.departure.after(arrivalTimeCal.getTime())) {
            arrivalTimeCal.add(5, 1);
        }
        arrivalTime = arrivalTimeCal.getTime();
        clsTimetableLeg timetableLeg1 = (clsTimetableLeg)clsUtilities.deepClone(this);
        timetableLeg1.arrival = arrivalTime;
        timetableLeg1.destination = passStopEventMatched.eventLocation;
        timetableLeg1.destinationCode = passStopEventMatched.CRSCode;
        timetableLeg1.passStop = passStopPrior;
        clsTimetableLeg timetableLeg2 = (clsTimetableLeg)clsUtilities.deepClone(this);
        Date depatureTime = clsUtilities.setTimeZero(this.departure);
        Calendar departureTimeCal = Calendar.getInstance();
        departureTimeCal.setTime(this.departure);
        departureTimeCal.set(11, Integer.parseInt(passStopEventMatched.departureTime.substring(0, 2)));
        departureTimeCal.set(12, Integer.parseInt(passStopEventMatched.departureTime.substring(2, 4)));
        if (this.departure.after(departureTimeCal.getTime())) {
            departureTimeCal.add(5, 1);
        }
        timetableLeg2.departure = depatureTime = departureTimeCal.getTime();
        timetableLeg2.origin = passStopEventMatched.eventLocation;
        timetableLeg2.originCode = passStopEventMatched.CRSCode;
        timetableLeg2.passStop = passStopAfter;
        legs.add(timetableLeg1);
        legs.add(timetableLeg2);
        return legs;
    }

    public List<String> getStationList() {
        ArrayList<String> stationList = new ArrayList<String>();
        stationList.add(this.origin.CRSCode);
        if (this.passStop != null && !this.passStop.isEmpty()) {
            for (clsPassStopEvent pse : this.passStop) {
                stationList.add(pse.CRSCode);
            }
        }
        stationList.add(this.destination.CRSCode);
        return stationList;
    }

    @Override
    public String toString() {
        StringBuffer sData = new StringBuffer();
        String PREFIX = "\n        ............";
        sData.append(super.toString());
        sData.append("\n        ............arrival=" + this.arrival + "\tdeparture=" + this.departure + "\n        ............" + "BHX=" + this.BHX + "\tSO=" + this.SO + "\tSX=" + this.SX + "\n        ............" + "reservable=" + this.reservable + "\treserveCode=" + this.reserveCode + "\tfirstClassAvailable=" + this.firstClassAvailable + "\tstdClassAvailable=" + this.stdClassAvailable + "\n        ............" + "seats=" + this.seats + "\tseatingCode=" + this.seatingCode + "\tsleeper=" + this.sleeper + "\tsleeperCode=" + this.sleeperCode + "\n        ............" + "cateringCodes=" + this.cateringCodes + "\tdaysRunning=" + this.daysRunning + "\tprimaryTOC=" + this.primaryTOC + "\tsecondaryTOC=" + this.secondaryTOC + "\n        ............" + "retailTrainID=" + this.retailTrainID + "\tintercity=" + this.intercity + "\tsectorCode=" + this.sectorCode + "\tserviceBrand=" + this.serviceBrand + "\tstockType=" + this.stockType + "\n        ............" + "changeTakesTooLong=" + this.changeTakesTooLong + "\ttrainSplits=" + this.trainSplits + "\tsplitAt=" + this.splitAt + "\tlegSignature=" + (this.legSignature == null ? "null" : new String(this.legSignature)) + "\n        ............" + "CATETrainStart=" + this.CATETrainStart + "\tCATETrainEnd=" + this.CATETrainEnd + "\n        ............" + "trainOriginCode=" + this.trainOriginCode + "\ttrainDestinationCode=" + this.trainDestinationCode + "\n        ............" + "trainOrigin=" + this.trainOrigin + "\n        ............" + "trainDestination=" + this.trainDestination + "\n        ............" + "trainDeparture=" + this.trainDeparture + "\ttrainArrival=" + this.trainArrival + "\ttrainUID=" + this.trainUID + "\n        ............" + "passStop=" + this.passStop);
        return sData.toString();
    }
}

