/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportGUI.ClockPicker;
import com.example.twolibs.TimeTableBL.STDResponse;
import com.example.twolibs.TimeTableGUI.TwoLibs;
import java.io.Serializable;
import java.util.Date;

public class TimeTableCriteria
extends Activity {
    Activity activity;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_timetablecriteria);
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.activity = this.getParent();
        this.setTitle(" Timetable");
        String locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/TT.ini";
        STDResponse ttresp = bb.ttSearch.initialise(locfile);
        TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
        txtOrigin.setText((CharSequence)bb.getOrigin().getDescription());
        LinearLayout cmdOrigin = (LinearLayout)this.findViewById(R.id.frmOrigin);
        cmdOrigin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(TimeTableCriteria.this.getApplicationContext(), LocationLookup.class);
                nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.FROM_SEARCH));
                nextScreen.putExtra("search", "timetable");
                TimeTableCriteria.this.startActivityForResult(nextScreen, 1);
            }
        });
        TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
        txtDestination.setText((CharSequence)bb.getDestination().getDescription());
        LinearLayout cmdDestination = (LinearLayout)this.findViewById(R.id.frmDestination);
        cmdDestination.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(TimeTableCriteria.this.getApplicationContext(), LocationLookup.class);
                nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.TO_SEARCH));
                nextScreen.putExtra("search", "timetable");
                TimeTableCriteria.this.startActivityForResult(nextScreen, 2);
            }
        });
        TextView txtTime = (TextView)this.findViewById(R.id.txtTimeTT);
        txtTime.setText((CharSequence)DataConvert.displayTextTime(bb.getSearchDate()));
        LinearLayout cmdTime = (LinearLayout)this.findViewById(R.id.frmTime);
        cmdTime.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(TimeTableCriteria.this.getApplicationContext(), ClockPicker.class);
                nextScreen.putExtra("direction", "to");
                nextScreen.putExtra("search", "timetable");
                TimeTableCriteria.this.startActivityForResult(nextScreen, 2);
            }
        });
        TextView txtDate = (TextView)this.findViewById(R.id.txtDate);
        txtDate.setText((CharSequence)DataConvert.displayTextDate(bb.getSearchDate()));
        LinearLayout cmdDate = (LinearLayout)this.findViewById(R.id.frmDate);
        cmdDate.setOnClickListener(new View.OnClickListener(){
            private DatePickerDialog.OnDateSetListener datePickerListener = new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker view, int selectedYear, int selectedMonth, int selectedDay) {
                    Date searchDate = bb.getSearchDate();
                    bb.setSearchDate(DataConvert.setDate(searchDate, selectedYear, selectedMonth, selectedDay));
                    TextView txtDate = (TextView)TimeTableCriteria.this.findViewById(R.id.txtDate);
                    txtDate.setText((CharSequence)DataConvert.displayTextDate(bb.getSearchDate()));
                }
            };

            public void onClick(View view) {
                Date searchDate = bb.getSearchDate();
                int year = DataConvert.getYear(searchDate);
                int month = DataConvert.getMonth(searchDate);
                int day = DataConvert.getDayOfMonth(searchDate);
                DatePickerDialog dialog = new DatePickerDialog((Context)TimeTableCriteria.this, this.datePickerListener, year, month, day);
                dialog.show();
            }
        });
        TextView txtChanges = (TextView)this.findViewById(R.id.txtChanges);
        int changes = bb.getChanges();
        if (changes == 0) {
            txtChanges.setText((CharSequence)"Direct");
        } else if (changes == 0) {
            txtChanges.setText((CharSequence)"One change");
        } else {
            txtChanges.setText((CharSequence)(changes + " changes"));
        }
        LinearLayout cmdChanges = (LinearLayout)this.findViewById(R.id.frmChanges);
        cmdChanges.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CharSequence[] items = new CharSequence[]{"Direct", "1", "2", "3", "4", "5", "6"};
                AlertDialog.Builder listBuilder = new AlertDialog.Builder((Context)TimeTableCriteria.this);
                listBuilder.setTitle((CharSequence)"Changes");
                listBuilder.setItems(items, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int item) {
                        TextView txtChanges = (TextView)TimeTableCriteria.this.findViewById(R.id.txtChanges);
                        int changes = item;
                        if (changes == 0) {
                            txtChanges.setText((CharSequence)"Direct");
                        } else if (changes == 0) {
                            txtChanges.setText((CharSequence)"One change");
                        } else {
                            txtChanges.setText((CharSequence)(changes + " changes"));
                        }
                        bb.setChanges(changes);
                    }
                });
                AlertDialog alertList = listBuilder.create();
                alertList.show();
            }
        });
        Button cmdSearch = (Button)this.findViewById(R.id.cmdSearch);
        cmdSearch.setText((CharSequence)"Search");
        cmdSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(TimeTableCriteria.this.getApplicationContext(), TwoLibs.class);
                nextScreen.putExtra("direction", "to");
                TimeTableCriteria.this.startActivityForResult(nextScreen, 3);
            }
        });
        this.doCheckComplete();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        AppContext bb;
        if (requestCode == 1) {
            if (resultCode == -1) {
                Location origin = (Location)data.getSerializableExtra("ResultData");
                bb = (AppContext)this.getApplicationContext();
                bb.setOrigin(origin);
                TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
                txtOrigin.setText((CharSequence)origin.getDescription());
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 2) {
            if (resultCode == -1) {
                Location destination = (Location)data.getSerializableExtra("ResultData");
                bb = (AppContext)this.getApplicationContext();
                bb.setDestination(destination);
                TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
                txtDestination.setText((CharSequence)destination.getDescription());
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 3) {
            if (resultCode == -1) {
                Intent returnIntent = new Intent();
                returnIntent.putExtra("result", -1);
                this.setResult(-1, returnIntent);
                this.finish();
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        this.doCheckComplete();
    }

    int JMgetColor(int Color2, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color2, TH);
        }
        return this.getResources().getColor(Color2);
    }

    void doCheckComplete() {
        Button cmdSearch = (Button)this.findViewById(R.id.cmdSearch);
        TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
        String strOrigin = txtOrigin.getText().toString();
        TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
        String strDestination = txtDestination.getText().toString();
        if (strOrigin.length() > 0 && strDestination.length() > 0) {
            cmdSearch.setEnabled(true);
            cmdSearch.setBackgroundColor(this.JMgetColor(R.color.button_background, this.getTheme()));
        } else {
            cmdSearch.setEnabled(false);
            cmdSearch.setBackgroundColor(this.JMgetColor(R.color.button_background_disabled, this.getTheme()));
        }
        AppContext bb = (AppContext)this.getApplicationContext();
        TextView txtDepartArrive = (TextView)this.findViewById(R.id.capTime);
        if (bb.getSearchDirection() == 0) {
            txtDepartArrive.setText((CharSequence)"Depart");
        } else {
            txtDepartArrive.setText((CharSequence)"Arrive");
        }
        TextView txtTime = (TextView)this.findViewById(R.id.txtTimeTT);
        txtTime.setText((CharSequence)DataConvert.displayTextTime(bb.getSearchDate()));
    }
}

