/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyBL;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Duty {
    private static String CLASS_NAME = "Duty";
    public String dutyName = "";
    public String dutyId = "";
    public static ArrayList<Duty> allDutys = new ArrayList();
    public ArrayList<DutyTask> dutyActivities = new ArrayList();
    public static int firstIndex = -1;

    public DutyTask updateTaskStates(Date pTime) {
        String FUNC_NAME = "updateTaskStates";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "updateTaskStates", TraceHandler.Category.ENTRY, DataConvert.displayyyyyMMddHHmm(pTime), 0);
        DutyTask task = null;
        long calNow = DataConvert.getTimeInMillis(DataConvert.DATENULL);
        DutyTask dueTask = null;
        DutyManager.activeTask = null;
        firstIndex = -1;
        for (int i = 0; i < this.dutyActivities.size(); ++i) {
            long calTaskEnd;
            DutyTaskType taskType;
            task = this.dutyActivities.get(i);
            try {
                taskType = DutyTaskType.getTaskType(task.taskType);
            }
            catch (Exception e) {
                taskType = new DutyTaskType();
                taskType.taskTypeCode = task.taskType;
                taskType.taskTypeTitle = "Not found " + task.taskType;
            }
            long calTaskStart = DataConvert.getTimeInMillis(task.taskStart);
            long timeDiff = calNow - calTaskStart;
            if (timeDiff > (long)(-(taskType.taskTypeNofify * 60 * 1000)) && task.taskState.ordinal() < DutyTask.TaskState.ACTIVE.ordinal()) {
                task.taskState = DutyTask.TaskState.DUE;
            }
            if ((timeDiff = calNow - (calTaskEnd = DataConvert.getTimeInMillis(task.taskEnd))) > (long)(taskType.taskTypeNofify * 60 * 1000) && task.taskState.ordinal() < DutyTask.TaskState.COMPLETE.ordinal()) {
                task.taskState = DutyTask.TaskState.EXPIRED;
            }
            if (task.taskState == DutyTask.TaskState.ACTIVE && taskType.taskSpecialAction != DutyTaskType.TaskSpecialAction.NONE) {
                if (DutyManager.activeTask == null) {
                    DutyManager.activeTask = task;
                }
                if (firstIndex < 0) {
                    firstIndex = i;
                }
            }
            if (task.taskState != DutyTask.TaskState.DUE) continue;
            if (dueTask == null) {
                dueTask = task;
            }
            if (firstIndex >= 0) continue;
            firstIndex = i;
        }
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "updateTaskStates", TraceHandler.Category.EXIT, "", 0);
        return dueTask;
    }

    public void updateTasktimes() {
        String FUNC_NAME = "updateTasktimes";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "updateTasktimes", TraceHandler.Category.ENTRY, "", 0);
        DutyTask task = null;
        DutyTask lastTask = null;
        DutyTaskType dutyTaskType = null;
        DutyTaskType lastDutyTaskType = null;
        for (int i = 0; i < this.dutyActivities.size(); ++i) {
            task = this.dutyActivities.get(i);
            dutyTaskType = DutyTaskType.getTaskType(task.taskType);
            if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.NONE) continue;
            if (lastTask != null) {
                lastTask.taskEnd = task.taskStart;
            }
            lastTask = task;
            lastDutyTaskType = dutyTaskType;
        }
        if (lastTask != null && lastDutyTaskType.taskSpecialAction != DutyTaskType.TaskSpecialAction.BOARD_TRAIN) {
            lastTask.taskEnd = DataConvert.setTime(lastTask.taskStart, 24, 0, 0);
        }
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "updateTasktimes", TraceHandler.Category.EXIT, "", 0);
    }

    public static ArrayList<Duty> doLoadXML() {
        String FUNC_NAME = "doLoadXML";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadXML", TraceHandler.Category.ENTRY, "", 0);
        allDutys = new ArrayList();
        DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(DataTransferManager.FileType.DUTIES);
        if (resp.result == GenericManager.Response.OK) {
            try {
                NodeList nodeList = resp.doc.getElementsByTagName("duty");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Duty duty = Duty.fromXML(node);
                    if (duty == null) continue;
                    duty.updateTasktimes();
                    allDutys.add(duty);
                }
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "Loaded " + allDutys.size(), 0);
            }
            catch (Exception e) {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "XML Pasing Exception = " + e, 0);
            }
        } else {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "Document not loaded", 0);
        }
        return allDutys;
    }

    public static Duty fromXML(Node pNode) {
        String FUNC_NAME = "fromXML";
        Duty duty = new Duty();
        try {
            duty.dutyId = pNode.getAttributes().getNamedItem("dutyId").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.EXIT, "XML dutyId Exception = " + e, 0);
            return null;
        }
        try {
            duty.dutyName = pNode.getAttributes().getNamedItem("dutyName").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.EXIT, "XML dutyName Exception = " + e, 0);
            return null;
        }
        int i = 0;
        try {
            Element element = (Element)pNode;
            NodeList nodeList = element.getElementsByTagName("task");
            for (i = 0; i < nodeList.getLength(); ++i) {
                Node subNode = nodeList.item(i);
                DutyTask task = DutyTask.fromXML(subNode);
                if (task == null) continue;
                duty.dutyActivities.add(task);
            }
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.EXIT, "XML task " + i + " Parsing Exception = " + e, 0);
            return null;
        }
        return duty;
    }
}

