/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyGUI;

import android.app.ActionBar;
import android.app.Activity;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.DutyGUI.DutyMain;
import com.example.twolibs.DutyGUI.DutyTaskTypeListAdaptor;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.TimeTableGUI.TimeTableCriteria;
import java.io.Serializable;
import java.util.ArrayList;

public class DutyAdHoc
extends ListActivity {
    private static String CLASS_NAME = "DutyAdHoc";
    ArrayList<DutyTaskType> list = new ArrayList();
    int iCurrentSelection = -1;
    DutyTaskType selTaskType = null;
    DutyTaskTypeListAdaptor adapter;
    ListView listview;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_duty_adhod);
        ActionBar actionBar = this.getActionBar();
        actionBar.hide();
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.listview = (ListView)this.findViewById(16908298);
        this.adapter = new DutyTaskTypeListAdaptor((Activity)this, this.list);
        this.setListAdapter((ListAdapter)this.adapter);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String FUNC_NAME = "onItemClick";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onItemClick", TraceHandler.Category.GUI, "listview " + position, 0);
                DutyAdHoc.this.selTaskType = DutyAdHoc.this.list.get(position);
                if (DutyAdHoc.this.selTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.BOARD_TRAIN) {
                    Intent nextScreen = new Intent(DutyAdHoc.this.getApplicationContext(), TimeTableCriteria.class);
                    nextScreen.putExtra("nextAction", "");
                    DutyAdHoc.this.startActivityForResult(nextScreen, CallContext.SELECT_TRAIN.ordinal());
                } else if (DutyAdHoc.this.selTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.QUEUE_BUST) {
                    Intent nextScreen = new Intent(DutyAdHoc.this.getApplicationContext(), LocationLookup.class);
                    nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.FROM_SEARCH));
                    nextScreen.putExtra("Caller", CLASS_NAME);
                    DutyAdHoc.this.startActivityForResult(nextScreen, CallContext.SELECT_ORIGIN.ordinal());
                } else if (DutyAdHoc.this.selTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.EXCESS_FARE) {
                    Intent nextScreen = new Intent(DutyAdHoc.this.getApplicationContext(), LocationLookup.class);
                    nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.TO_SEARCH));
                    nextScreen.putExtra("Caller", CLASS_NAME);
                    DutyAdHoc.this.startActivityForResult(nextScreen, CallContext.SELECT_DESTINATION.ordinal());
                } else {
                    DutyManager.setupAdHocDuty(bb, DutyAdHoc.this.selTaskType.taskTypeCode, bb.getSearchDate(), bb.getOrigin(), bb.getDestination(), bb.selJourney);
                    Intent returnIntent = new Intent();
                    DutyAdHoc.this.setResult(-1, returnIntent);
                    DutyAdHoc.this.finish();
                }
            }
        });
        this.doSearch();
        LinearLayout frmTitle = (LinearLayout)this.findViewById(R.id.frmTitle);
        frmTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String FUNC_NAME = "onClick";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onClick", TraceHandler.Category.GUI, "frmTitle", 0);
                DutyAdHoc.this.dispatchKeyEvent(new KeyEvent(0, 4));
                DutyAdHoc.this.dispatchKeyEvent(new KeyEvent(1, 4));
            }
        });
        EditText txtSearch = (EditText)this.findViewById(R.id.txtSearch);
        txtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                String FUNC_NAME = "afterTextChanged";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "afterTextChanged", TraceHandler.Category.GUI, "txtSearch " + s, 0);
                DutyAdHoc.this.doSearch();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        txtSearch.requestFocus();
    }

    public void doSearch() {
        String FUNC_NAME = "doSearch";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearch", TraceHandler.Category.ENTRY, "", 0);
        EditText et = (EditText)this.findViewById(R.id.txtSearch);
        String search = DataConvert.toUpperCase(et.getText().toString());
        ArrayList<DutyTaskType> myList = DutyManager.doSearchTask(search);
        this.adapter.clear();
        this.adapter.addAll(myList);
        this.adapter.notifyDataSetChanged();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        AppContext bb = (AppContext)this.getApplicationContext();
        String FUNC_NAME = "onActivityResult";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onActivityResult", TraceHandler.Category.ENTRY, "Request " + requestCode + " Result " + resultCode, 0);
        if (requestCode == CallContext.SELECT_ORIGIN.ordinal()) {
            if (resultCode == -1) {
                Location origin = (Location)data.getSerializableExtra("ResultData");
                DutyManager.setupAdHocDuty(bb, this.selTaskType.taskTypeCode, bb.getSearchDate(), origin, new Location(), bb.selJourney);
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == CallContext.SELECT_DESTINATION.ordinal()) {
            if (resultCode == -1) {
                Location destination = (Location)data.getSerializableExtra("ResultData");
                DutyManager.setupAdHocDuty(bb, this.selTaskType.taskTypeCode, bb.getSearchDate(), destination, new Location(), bb.selJourney);
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == CallContext.SELECT_TRAIN.ordinal()) {
            if (resultCode == -1) {
                DutyManager.setupAdHocDuty(bb, this.selTaskType.taskTypeCode, bb.getSearchDate(), bb.getOrigin(), bb.getDestination(), bb.selJourney);
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        Intent returnIntent = new Intent();
        this.setResult(-1, returnIntent);
        this.finish();
    }

    public Intent getParentActivityIntent() {
        String FUNC_NAME = "getParentActivityIntent";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "getParentActivityIntent", TraceHandler.Category.ENTRY, "getParentActivityIntent", 0);
        Intent newIntent = null;
        newIntent = new Intent(this.getApplicationContext(), DutyMain.class);
        return newIntent;
    }

    public static enum CallContext {
        SELECT_TRAIN,
        SELECT_ORIGIN,
        SELECT_DESTINATION;

    }
}

