/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresBL;

import android.util.Log;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNFareValidityResult;
import com.example.twolibs.FaresBL.TNJFLRestrictionResult;
import com.example.twolibs.FaresBL.TNJourneyFareLink;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.FaresBL.TNSearchResults;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.HashMapX;
import java.util.ArrayList;
import java.util.Date;

public class FareManager {
    public static HashMapX<String, TicketDetails> ticketCodes = new HashMapX();
    private static TicketDetails ticketDetails = new TicketDetails();
    public ArrayList<TNFare> historicFares = new ArrayList();

    public static void init() {
    }

    public STDResponse doLoad(String fibFile) {
        STDResponse resp = new STDResponse();
        resp.result = -1;
        resp.trace = "Begin";
        int iTraceSize = 10000;
        byte[] bTrace = FareManager.StringToCBuff(iTraceSize, "");
        resp.result = FareManager.loadFib(fibFile, bTrace);
        resp.extra = fibFile + " " + resp.result + " ";
        resp.trace = FareManager.CBuffToString(iTraceSize, bTrace);
        return resp;
    }

    public STDResponse doLoad2(String fibFile, String traceFile) {
        STDResponse resp = new STDResponse();
        resp.result = -1;
        resp.trace = "Begin";
        int iTraceSize = 10000;
        byte[] bTrace = FareManager.StringToCBuff(iTraceSize, "");
        resp.result = FareManager.loadFib2(fibFile, bTrace, traceFile);
        resp.extra = fibFile + " " + resp.result + " ";
        resp.trace = FareManager.CBuffToString(iTraceSize, bTrace);
        return resp;
    }

    public void addHistoricFare(TNFare fare) {
        int i = this.historicFares.size();
        ArrayList<TNFare> revisedFares = new ArrayList<TNFare>();
        revisedFares.add(fare);
        for (i = 0; i < this.historicFares.size(); ++i) {
            TNFare histFare = this.historicFares.get(i);
            if (histFare.getFa_FareDestinationLocation().equals(fare.getFa_FareDestinationLocation()) && histFare.getFa_FareOriginLocation().equals(fare.getFa_FareOriginLocation()) && histFare.getFa_TicketTypeCode().equals(fare.getFa_TicketTypeCode()) && histFare.getFa_RouteCode().equals(fare.getFa_RouteCode()) && histFare.getFa_NumAdults() == fare.getFa_NumAdults() && histFare.getFa_NumChildren() == fare.getFa_NumChildren() && histFare.getFa_NumAAA() == fare.getFa_NumAAA() && histFare.getFa_FareDate().equals(fare.getFa_FareDate())) continue;
            revisedFares.add(histFare);
        }
        this.historicFares = revisedFares;
    }

    private static String CBuffToString(int iSize, byte[] bInput) {
        StringBuilder sNew = new StringBuilder(iSize);
        for (int i = 0; i < iSize && bInput[i] != 0; ++i) {
            char ch = (char)bInput[i];
            sNew.append(ch);
        }
        return sNew.toString();
    }

    private static byte[] StringToCBuff(int iSize, String sInput) {
        byte[] bNewBuffer = new byte[iSize];
        int l = sInput.length();
        if (l > iSize) {
            l = iSize;
        }
        if (l > 0) {
            int i;
            for (i = 0; i < l; ++i) {
                bNewBuffer[i] = (byte)sInput.charAt(i);
            }
            if (i >= l) {
                bNewBuffer[l - 1] = 0;
            } else {
                bNewBuffer[i] = 0;
            }
        }
        return bNewBuffer;
    }

    public SearchResponse doSearch(TNSearchCriteria TNCrit, int faresClass, boolean showAll) {
        SearchResponse resp = new SearchResponse();
        resp.result = -1;
        resp.trace = "Begin";
        ArrayList<TNFare> resList = new ArrayList<TNFare>();
        TNSearchResults objTNSearchResults = new TNSearchResults();
        String outDate = DataConvert.displayyyyyMMddHHmm(TNCrit.OutDateTime);
        String retDate = TNCrit.ReturnDateTime == null ? "000000000000" : DataConvert.displayyyyyMMddHHmm(TNCrit.ReturnDateTime);
        objTNSearchResults = FareManager.faresSearch(TNCrit.OriginUIC, TNCrit.DestinationUIC, outDate, retDate, DataConvert.displayyyyyMMddHHmm(TNCrit.CurrentDateTime), TNCrit.NumAdults, TNCrit.NumChildren, TNCrit.NumAAA, TNCrit.RailcardCode, TNCrit.VariableDiscount, TNCrit.UseFutureFares, TNCrit.TicketCode, TNCrit.RouteCode);
        resp.result = objTNSearchResults.getTn_ErrorCode();
        if (objTNSearchResults.getTn_ErrorCode() != 0 && objTNSearchResults.getTn_ErrorCode() != 1) {
            resp.trace = "Error " + objTNSearchResults.getTn_ErrorCode() + " ";
            return resp;
        }
        resp.trace = "Returned " + objTNSearchResults.getTn_NumIJQFares();
        boolean result = false;
        for (int i = 0; i < objTNSearchResults.getTn_NumIJQFares(); ++i) {
            TNFareValidityResult fvr;
            TNJFLRestrictionResult retRR;
            TNJFLRestrictionResult outRR;
            TNFare tnf = objTNSearchResults.getTn_IJQFares().get(i);
            if (i < objTNSearchResults.getTn_NumJFL()) {
                TNJourneyFareLink jfl = objTNSearchResults.getTn_JourneyFareLinks().get(i);
                outRR = jfl.getJfl_OutRestrictionResult();
                retRR = jfl.getJfl_RetRestrictionResult();
                fvr = jfl.getJfl_FareValidityResult();
            } else {
                outRR = null;
                retRR = null;
                fvr = null;
            }
            Log.e((String)"fares", (String)("Ticket!" + tnf.getFa_TicketTypeCode() + "!" + tnf.getFa_FareDate()));
            String txtTicketCode = tnf.getFa_TicketTypeCode();
            TicketDetails tkt = FareManager.loadTicket(txtTicketCode, tnf.getFa_FareDateDt());
            tnf.setFa_NoSaleReason(tkt.NoSaleReason("00009"));
            if (tnf.getFa_NoSaleReason().length() == 0 && outRR != null && outRR.getRr_RejectionNumber() > 0) {
                tnf.setFa_NoSaleReason(outRR.getRr_RejectionRestrictionDesc());
            }
            if (tnf.getFa_NoSaleReason().length() == 0 && !tkt.getTd_ReservationRequired().equals("N")) {
                tnf.setFa_NoSaleReason("Ticket requires reservation");
            }
            tnf.setFa_FulfillmentMethod("CCST");
            boolean blnInclude = true;
            if (faresClass == 0 && tnf.getFa_FareClass() != 1) {
                blnInclude = false;
            }
            if (faresClass == 1 && tnf.getFa_FareClass() != 2) {
                blnInclude = false;
            }
            if (!blnInclude || !showAll && tnf.getFa_NoSaleReason().length() != 0) continue;
            resList.add(tnf);
        }
        resp.fares = resList;
        resp.trace = resp.trace + "Found " + resList.size();
        return resp;
    }

    public static TicketDetails loadTicket(String pTicketCode, Date pDate) {
        TicketDetails tkt = null;
        if (ticketCodes.containsKey(pTicketCode)) {
            tkt = ticketCodes.getValue(pTicketCode);
        } else {
            tkt = ticketDetails.LoadTicketDetails(pTicketCode, pDate, "00001", "00005");
            ticketCodes.put(pTicketCode, tkt);
        }
        return tkt;
    }

    public static native int loadFib(String var0, byte[] var1);

    public static native int loadFib2(String var0, byte[] var1, String var2);

    public static native TNSearchResults faresSearch(String var0, String var1, String var2, String var3, String var4, int var5, int var6, int var7, String var8, int var9, boolean var10, String var11, String var12);

    public static native TNSearchResults seasonFaresSearch(String var0, String var1, String var2, String var3, int var4, int var5, String var6, int var7, int var8, int var9, String var10, String var11);

    public class SearchResponse
    extends STDResponse {
        public ArrayList<TNFare> fares;

        public SearchResponse() {
            this.fares = new ArrayList();
        }
    }

    public class STDResponse {
        public int result = 0;
        public String extra = "";
        public String trace = "";
    }
}

