/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresGUI;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareSet;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.FaresGUI.FareSetChoice;
import com.example.twolibs.FaresGUI.FaresCriteria;
import com.example.twolibs.FaresGUI.TicketListAdaptor;
import com.example.twolibs.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FareSetEdit
extends ListActivity {
    int iCurrentMenu = -1;
    int iCurrentSelection = -1;
    ArrayList<TNFare> list = new ArrayList();
    TicketListAdaptor adapter;
    ListView listview;
    FareSet thisFareSet = new FareSet();

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_fares_editset);
        AppContext bb = (AppContext)this.getApplicationContext();
        String faresetType = this.getIntent().getStringExtra("fareset");
        if (faresetType.equals("instant")) {
            this.setTitle("Edit Instant");
            this.thisFareSet = bb.fareSetManager.instantFareSet;
        } else {
            this.setTitle("Edit Favourite");
            this.thisFareSet = bb.fareSetManager.favouriteFareSet;
        }
        bb.fareSetManager.setupPresetFares(bb, this.thisFareSet);
        this.list = bb.fareSetManager.getPresetFares(bb, this.thisFareSet);
        EditText txtFareSetId = (EditText)this.findViewById(R.id.txtFareSetId);
        txtFareSetId.setText((CharSequence)this.thisFareSet.faresetId);
        txtFareSetId.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                FareSetEdit.this.thisFareSet.faresetId = s.toString();
                FareSetEdit.this.doCheckComplete();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        EditText txtFareSetName = (EditText)this.findViewById(R.id.txtFareSetName);
        txtFareSetName.setText((CharSequence)this.thisFareSet.faresetName);
        txtFareSetName.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                FareSetEdit.this.thisFareSet.faresetName = s.toString();
                FareSetEdit.this.doCheckComplete();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        this.listview = (ListView)this.findViewById(16908298);
        this.adapter = new TicketListAdaptor((Activity)this, this.list, bb);
        this.setListAdapter((ListAdapter)this.adapter);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    View rowView = parent.getChildAt(j);
                    rowView.setBackgroundColor(0);
                }
                if (position == FareSetEdit.this.iCurrentSelection) {
                    FareSetEdit.this.setMenu(0);
                    FareSetEdit.this.iCurrentSelection = -1;
                    FareSetEdit.this.list.get((int)position).itemSelected = 0;
                } else {
                    FareSetEdit.this.setMenu(1);
                    FareSetEdit.this.iCurrentSelection = position;
                    FareSetEdit.this.list.get((int)position).itemSelected = 1;
                    view.setBackgroundColor(FareSetEdit.this.JMgetColor(R.color.selection_background, FareSetEdit.this.getTheme()));
                }
            }
        });
        Button cmdSave = (Button)this.findViewById(R.id.cmdSave);
        cmdSave.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent returnIntent = new Intent();
                FareSetEdit.this.setResult(-1, returnIntent);
                FareSetEdit.this.finish();
            }
        });
        Button cmdAdd = (Button)this.findViewById(R.id.cmdAdd);
        cmdAdd.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(FareSetEdit.this.getApplicationContext(), FaresCriteria.class);
                nextScreen.putExtra("nextAction", "addToFareSet");
                FareSetEdit.this.startActivityForResult(nextScreen, 2);
            }
        });
        this.doCheckComplete();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        AppContext bb = (AppContext)this.getApplicationContext();
        if (requestCode == 1) {
            // empty if block
        }
        if (requestCode == 2) {
            if (resultCode == -1 && bb.selFare != null) {
                bb.fareSetManager.addFareToSet(this.thisFareSet, bb.selFare);
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        this.doCheckComplete();
    }

    void doCheckComplete() {
        AppContext bb = (AppContext)this.getApplicationContext();
        Collections.sort(this.thisFareSet.fareSearches, new Comparator(){

            public int compare(Object o1, Object o2) {
                TNSearchCriteria p1 = (TNSearchCriteria)o1;
                TNSearchCriteria p2 = (TNSearchCriteria)o2;
                return p1.Sequence - p2.Sequence;
            }
        });
        ArrayList<TNFare> newList = bb.fareSetManager.getPresetFares(bb, this.thisFareSet);
        this.adapter.clear();
        this.adapter.addAll(newList);
        this.adapter.notifyDataSetChanged();
    }

    private void setMenu(int iMenu) {
        if (iMenu != this.iCurrentMenu) {
            LinearLayout layFormMenu = (LinearLayout)this.findViewById(R.id.layFormMenu);
            layFormMenu.removeAllViews();
            LayoutInflater inflater = this.getLayoutInflater();
            if (iMenu == 0) {
                layFormMenu.addView(inflater.inflate(R.layout.fareset_menu0, null));
                Button cmdSave = (Button)this.findViewById(R.id.cmdSave);
                cmdSave.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        FareSetEdit.this.setResult(-1, returnIntent);
                        FareSetEdit.this.finish();
                    }
                });
                Button cmdAdd = (Button)this.findViewById(R.id.cmdAdd);
                cmdAdd.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent nextScreen = new Intent(FareSetEdit.this.getApplicationContext(), FaresCriteria.class);
                        nextScreen.putExtra("nextAction", "addToFareSet");
                        FareSetEdit.this.startActivityForResult(nextScreen, 2);
                    }
                });
                Button cmdDelete = (Button)this.findViewById(R.id.cmdDelete);
                cmdDelete.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)FareSetEdit.this, (CharSequence)"Delete not implemented", (int)0).show();
                    }
                });
            } else {
                layFormMenu.addView(inflater.inflate(R.layout.fareset_menu1, null));
                Button cmdUp = (Button)this.findViewById(R.id.cmdUp);
                cmdUp.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int iSel;
                        if ((iSel = FareSetEdit.this.iCurrentSelection--) > 0 && iSel < FareSetEdit.this.thisFareSet.fareSearches.size()) {
                            int sequence2;
                            int sequence1 = FareSetEdit.this.thisFareSet.fareSearches.get((int)iSel).Sequence;
                            FareSetEdit.this.thisFareSet.fareSearches.get((int)iSel).Sequence = sequence2 = FareSetEdit.this.thisFareSet.fareSearches.get((int)(iSel - 1)).Sequence;
                            FareSetEdit.this.thisFareSet.fareSearches.get((int)(iSel - 1)).Sequence = sequence1;
                            FareSetEdit.this.list.get((int)iSel).itemSelected = 1;
                            FareSetEdit.this.list.get((int)(iSel - 1)).itemSelected = 0;
                        }
                        FareSetEdit.this.doCheckComplete();
                    }
                });
                Button cmdDown = (Button)this.findViewById(R.id.cmdDown);
                cmdDown.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int iSel;
                        if ((iSel = FareSetEdit.this.iCurrentSelection++) >= 0 && iSel < FareSetEdit.this.thisFareSet.fareSearches.size() - 1) {
                            int sequence2;
                            int sequence1 = FareSetEdit.this.thisFareSet.fareSearches.get((int)iSel).Sequence;
                            FareSetEdit.this.thisFareSet.fareSearches.get((int)iSel).Sequence = sequence2 = FareSetEdit.this.thisFareSet.fareSearches.get((int)(iSel + 1)).Sequence;
                            FareSetEdit.this.thisFareSet.fareSearches.get((int)(iSel + 1)).Sequence = sequence1;
                            FareSetEdit.this.list.get((int)iSel).itemSelected = 1;
                            FareSetEdit.this.list.get((int)(iSel + 1)).itemSelected = 0;
                        }
                        FareSetEdit.this.doCheckComplete();
                    }
                });
                Button cmdDelete = (Button)this.findViewById(R.id.cmdDelete);
                cmdDelete.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        int iSel = FareSetEdit.this.iCurrentSelection;
                        if (iSel >= 0 && iSel < FareSetEdit.this.thisFareSet.fareSearches.size()) {
                            FareSetEdit.this.thisFareSet.fareSearches.remove(FareSetEdit.this.iCurrentSelection);
                            FareSetEdit.this.iCurrentSelection = -1;
                        }
                        FareSetEdit.this.doCheckComplete();
                    }
                });
            }
            this.iCurrentMenu = iMenu;
        }
    }

    public Intent getParentActivityIntent() {
        Intent newIntent = null;
        newIntent = new Intent(this.getApplicationContext(), FareSetChoice.class);
        return newIntent;
    }
}

