/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresGUI;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.FaresGUI.FaresLookup;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportGUI.PassengerPicker;
import java.io.Serializable;
import java.util.Date;

public class FaresCriteria
extends Activity {
    Activity activity;
    String nextAction = "";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_farescriteria);
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.activity = this.getParent();
        Intent intent = this.getIntent();
        if (intent != null) {
            this.nextAction = intent.getStringExtra("nextAction");
            if (this.nextAction != null) {
                if (this.nextAction.equals("addToFareSet")) {
                    this.setTitle(" Add fare");
                } else {
                    this.setTitle(" Fares");
                }
            } else {
                this.nextAction = "";
            }
        }
        this.setContext(bb);
        TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
        txtOrigin.setText((CharSequence)bb.getOrigin().getDescription());
        LinearLayout cmdOrigin = (LinearLayout)this.findViewById(R.id.frmOrigin);
        cmdOrigin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(FaresCriteria.this.getApplicationContext(), LocationLookup.class);
                nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.FROM_SEARCH));
                nextScreen.putExtra("search", "fares");
                FaresCriteria.this.startActivityForResult(nextScreen, 1);
            }
        });
        TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
        txtDestination.setText((CharSequence)bb.getDestination().getDescription());
        LinearLayout cmdDestination = (LinearLayout)this.findViewById(R.id.frmDestination);
        cmdDestination.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(FaresCriteria.this.getApplicationContext(), LocationLookup.class);
                nextScreen.putExtra("CallContext", (Serializable)((Object)LocationLookup.CallingContext.TO_SEARCH));
                nextScreen.putExtra("search", "fares");
                FaresCriteria.this.startActivityForResult(nextScreen, 2);
            }
        });
        LinearLayout frmPassengers = (LinearLayout)this.findViewById(R.id.frmPassengers);
        frmPassengers.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(FaresCriteria.this.getApplicationContext(), PassengerPicker.class);
                nextScreen.putExtra("direction", "to");
                nextScreen.putExtra("search", "fares");
                FaresCriteria.this.startActivityForResult(nextScreen, 4);
            }
        });
        TextView txtDate = (TextView)this.findViewById(R.id.txtDate);
        txtDate.setText((CharSequence)DataConvert.displayTextDate(bb.getSearchDate()));
        LinearLayout cmdDate = (LinearLayout)this.findViewById(R.id.frmDate);
        cmdDate.setOnClickListener(new View.OnClickListener(){
            private DatePickerDialog.OnDateSetListener datePickerListener = new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker view, int selectedYear, int selectedMonth, int selectedDay) {
                    Date searchDate = bb.getSearchDate();
                    bb.setSearchDate(DataConvert.setDate(searchDate, selectedYear, selectedMonth, selectedDay));
                    TextView txtDate = (TextView)FaresCriteria.this.findViewById(R.id.txtDate);
                    txtDate.setText((CharSequence)DataConvert.displayTextDate(bb.getSearchDate()));
                }
            };

            public void onClick(View view) {
                Date searchDate = bb.getSearchDate();
                int year = DataConvert.getYear(searchDate);
                int month = DataConvert.getMonth(searchDate);
                int day = DataConvert.getDayOfMonth(searchDate);
                DatePickerDialog dialog = new DatePickerDialog((Context)FaresCriteria.this, this.datePickerListener, year, month, day);
                dialog.show();
            }
        });
        TextView txtAdults = (TextView)this.findViewById(R.id.txtAdults);
        txtAdults.setText((CharSequence)String.valueOf(bb.getNumAdults()));
        TextView txtChildren = (TextView)this.findViewById(R.id.txtChildren);
        txtChildren.setText((CharSequence)String.valueOf(bb.getNumChildren()));
        TextView txtRailcard = (TextView)this.findViewById(R.id.txtRailcard);
        txtRailcard.setText((CharSequence)"None");
        CheckBox checkShowAllFares = (CheckBox)this.findViewById(R.id.checkShowAllFares);
        checkShowAllFares.setChecked(bb.getShowAllFares());
        checkShowAllFares.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckBox checkShowAllFares = (CheckBox)FaresCriteria.this.findViewById(R.id.checkShowAllFares);
                bb.setShowAllFares(checkShowAllFares.isChecked());
                Toast.makeText((Context)FaresCriteria.this, (CharSequence)("checkShowAllFares " + bb.getShowAllFares()), (int)0).show();
            }
        });
        Button cmdSearch = (Button)this.findViewById(R.id.cmdSearch);
        cmdSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                RadioGroup radioClass = (RadioGroup)FaresCriteria.this.findViewById(R.id.radioClass);
                int sortID = radioClass.getCheckedRadioButtonId();
                bb.faresClass = sortID == R.id.radioFirst ? 0 : (sortID == R.id.radioStandard ? 1 : 2);
                RadioGroup radioSortTypeGroup = (RadioGroup)FaresCriteria.this.findViewById(R.id.radioSortType);
                sortID = radioSortTypeGroup.getCheckedRadioButtonId();
                bb.faresSortType = sortID == R.id.radioPrice ? 0 : 1;
                RadioGroup radioSortOrderGroup = (RadioGroup)FaresCriteria.this.findViewById(R.id.radioSortOrder);
                sortID = radioSortOrderGroup.getCheckedRadioButtonId();
                bb.faresSortOrder = sortID == R.id.radioAscending ? 0 : 1;
                Intent nextScreen = new Intent(FaresCriteria.this.getApplicationContext(), FaresLookup.class);
                if (FaresCriteria.this.nextAction.equals("")) {
                    nextScreen.putExtra("nextAction", "search");
                    FaresCriteria.this.startActivityForResult(nextScreen, 3);
                } else {
                    nextScreen.putExtra("nextAction", FaresCriteria.this.nextAction);
                    FaresCriteria.this.startActivityForResult(nextScreen, 5);
                }
            }
        });
        this.doCheckComplete();
    }

    public void setContext(AppContext bb) {
        if (DutyManager.activeTask != null) {
            DutyTaskType dutyTaskType = DutyTaskType.getTaskType(DutyManager.activeTask.taskType);
            if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.QUEUE_BUST) {
                bb.setOrigin(DutyManager.activeTask.taskLocationFrom);
            } else if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.EXCESS_FARE) {
                bb.setDestination(DutyManager.activeTask.taskLocationFrom);
            } else if (dutyTaskType.taskSpecialAction == DutyTaskType.TaskSpecialAction.BOARD_TRAIN) {
                bb.setOrigin(DutyManager.activeTask.taskLocationFrom);
                bb.setDestination(DutyManager.activeTask.taskLocationTo);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        TextView txtChildren;
        TextView txtAdults;
        AppContext bb;
        AppContext bb2;
        if (requestCode == 1) {
            if (resultCode == -1) {
                Location origin = (Location)data.getSerializableExtra("ResultData");
                bb2 = (AppContext)this.getApplicationContext();
                bb2.setOrigin(origin);
                TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
                txtOrigin.setText((CharSequence)origin.getDescription());
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 2) {
            if (resultCode == -1) {
                Location destination = (Location)data.getSerializableExtra("ResultData");
                bb2 = (AppContext)this.getApplicationContext();
                bb2.setDestination(destination);
                TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
                txtDestination.setText((CharSequence)destination.getDescription());
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 3) {
            String nextAction;
            if (resultCode == -1 && (nextAction = data.getStringExtra("nextAction")).length() != 0) {
                Intent returnIntent = new Intent();
                returnIntent.putExtra("nextAction", nextAction);
                this.setResult(-1, returnIntent);
                this.finish();
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 4) {
            if (resultCode == -1) {
                bb = (AppContext)this.getApplicationContext();
                txtAdults = (TextView)this.findViewById(R.id.txtAdults);
                txtAdults.setText((CharSequence)String.valueOf(bb.getNumAdults()));
                txtChildren = (TextView)this.findViewById(R.id.txtChildren);
                txtChildren.setText((CharSequence)String.valueOf(bb.getNumChildren()));
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 4) {
            if (resultCode == -1) {
                bb = (AppContext)this.getApplicationContext();
                txtAdults = (TextView)this.findViewById(R.id.txtAdults);
                txtAdults.setText((CharSequence)String.valueOf(bb.getNumAdults()));
                txtChildren = (TextView)this.findViewById(R.id.txtChildren);
                txtChildren.setText((CharSequence)String.valueOf(bb.getNumChildren()));
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        if (requestCode == 5) {
            if (resultCode == -1) {
                Intent returnIntent = new Intent();
                this.setResult(-1, returnIntent);
                this.finish();
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
        this.doCheckComplete();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    void doCheckComplete() {
        Button cmdSearch = (Button)this.findViewById(R.id.cmdSearch);
        TextView txtOrigin = (TextView)this.findViewById(R.id.txtOrigin);
        String strOrigin = txtOrigin.getText().toString();
        TextView txtDestination = (TextView)this.findViewById(R.id.txtDestination);
        String strDestination = txtDestination.getText().toString();
        if (strOrigin.length() > 0 && strDestination.length() > 0) {
            cmdSearch.setEnabled(true);
            cmdSearch.setBackgroundColor(this.JMgetColor(R.color.button_background, this.getTheme()));
        } else {
            cmdSearch.setEnabled(false);
            cmdSearch.setBackgroundColor(this.JMgetColor(R.color.button_background_disabled, this.getTheme()));
        }
    }
}

