/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FulfilmentBL;

import android.util.Log;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SessionBL.SDCIData;
import com.example.twolibs.SupportBL.DataConvert;
import java.util.Date;

public class CCSTCoupon {
    private String TAG = "CCSTCoupon";
    public BasketSupport bsItem;
    public SDCIData sdci;
    public String couponFormat;
    public TNFare ticket;
    public TicketDetails tkt;
    public boolean blnAdvanced = false;
    public boolean blnPlusBus = false;
    public String strCustomerName = "";
    public String strCouponMethodOfPayment = "";
    public int intNumAdults = 0;
    public int intNumChildren = 0;
    public int intNumCoupons = 0;
    public double dlbCouponValue = 0.0;
    public boolean blnReverseFlow = false;
    public String strTravelDirection = "SGL";
    public String strWarrantDetails = "";
    public String strNRSBookingReference = "";
    public String strCTRReference = "";
    public String strOriginalCTRReference = "";
    public String strPrintMessage = "";

    public void SetupFare(AppContext bb) {
        this.ticket = this.bsItem.ticket;
        if (FareManager.ticketCodes.containsKey(this.ticket.getFa_TicketTypeCode())) {
            this.tkt = FareManager.ticketCodes.getValue(this.ticket.getFa_TicketTypeCode());
        }
    }

    public String LookupField(String sFieldID) {
        if (this.bsItem.itemType == BasketSupport.ItemType.FARE) {
            return this.LookupTicketField(sFieldID);
        }
        return "";
    }

    private String LookupTicketField(String sFieldID) {
        String sValue = "";
        sValue = sFieldID;
        if (sFieldID.equals("00101")) {
            sValue = "";
        } else if (sFieldID.equals("00102")) {
            sValue = this.blnAdvanced ? "A" : " ";
        } else if (sFieldID.equals("00107")) {
            sValue = this.blnPlusBus ? "+BUS" : " ";
        } else if (sFieldID.equals("00115")) {
            sValue = this.tkt.getTd_FareClassDesc();
        } else if (sFieldID.equals("00118")) {
            sValue = this.ticket.isFa_CrossLondon() ? "+" : "";
        } else if (sFieldID.equals("00120")) {
            sValue = this.strCustomerName;
        } else if (sFieldID.equals("00122")) {
            sValue = "Printed " + this.dateToTime(this.sdci.saleTimestamp);
            sValue = sValue + " on " + this.DateToString(this.sdci.saleTimestamp);
        } else if (sFieldID.equals("00126")) {
            sValue = this.blnReverseFlow ? this.ticket.getFa_FareOriginLocation() : this.ticket.getFa_FareDestinationLocation();
        } else if (sFieldID.equals("00127")) {
            sValue = "";
        } else if (sFieldID.equals("00128")) {
            sValue = this.DateToString(this.ticket.getFa_FareDateDt());
        } else if (sFieldID.equals("00136")) {
            sValue = "";
        } else if (sFieldID.equals("00139")) {
            sValue = this.strCouponMethodOfPayment;
        } else if (sFieldID.equals("00142")) {
            sValue = this.strNRSBookingReference;
        } else if (sFieldID.equals("00143")) {
            sValue = this.NumberToWords(this.intNumAdults);
        } else if (sFieldID.equals("00144")) {
            sValue = this.NumberToWords(this.intNumChildren);
        } else if (sFieldID.equals("00145")) {
            sValue = this.intNumCoupons > 0 ? String.format("%01", this.intNumCoupons) : "";
        } else if (sFieldID.equals("00150")) {
            sValue = this.blnReverseFlow ? this.ticket.getFa_FareDestinationLocation() : this.ticket.getFa_FareOriginLocation();
        } else if (sFieldID.equals("00155")) {
            String sPound = "#";
            sValue = sPound + DataConvert.doubleToDisplayFormat(this.dlbCouponValue);
        } else if (sFieldID.equals("00159")) {
            sValue = this.ticket.getFa_RestrictionCode();
        } else if (sFieldID.equals("00160")) {
            sValue = this.ticket.getFa_RouteDescription();
        } else if (sFieldID.equals("00171")) {
            sValue = this.DateToString(this.ticket.getFa_FareDateDt());
        } else if (sFieldID.equals("00172")) {
            sValue = "ADULT";
        } else if (sFieldID.equals("00177")) {
            sValue = this.tkt.getTd_TicketTypeDesc();
        } else if (sFieldID.equals("00178")) {
            sValue = DataConvert.intToDisplayFormat(this.sdci.intTicketNumber, DataConvert.DecimalFormats.FIVEDIGITS);
        } else if (sFieldID.equals("00181")) {
            sValue = this.strCTRReference;
        } else if (sFieldID.equals("00186")) {
            sValue = this.strTravelDirection;
        } else if (sFieldID.equals("00189")) {
            sValue = this.tkt.getTd_TicketValidityDesc();
        } else if (sFieldID.equals("00191")) {
            sValue = this.strWarrantDetails;
        } else if (sFieldID.equals("00198")) {
            sValue = this.sdci.SellingNLC;
        } else if (sFieldID.equals("00201")) {
            sValue = this.strOriginalCTRReference;
        } else if (sFieldID.equals("00230")) {
            sValue = DataConvert.intToDisplayFormat(this.sdci.MachineNumber, DataConvert.DecimalFormats.FOURDIGITS);
            sValue = sValue + this.sdci.SellingNLC;
            sValue = sValue + DataConvert.intToDisplayFormat(this.sdci.WindowNumber, DataConvert.DecimalFormats.TWODIGITS);
        } else if (sFieldID.equals("A1_A")) {
            sValue = "";
        } else if (sFieldID.equals("A1_B")) {
            sValue = "";
        } else if (sFieldID.equals("A1_C")) {
            sValue = "";
        } else if (sFieldID.equals("A1_D")) {
            String sPound = "#";
            sValue = sPound + DataConvert.doubleToDisplayFormat(this.dlbCouponValue);
        } else if (sFieldID.equals("A1_E")) {
            sValue = this.blnPlusBus ? "+BUS" : " ";
        } else if (sFieldID.equals("A1_F")) {
            if (this.ticket.getFa_SingleOrReturn().equals("S")) {
                sValue = "SINGLE";
            } else if (this.ticket.getFa_SingleOrReturn().equals("R")) {
                sValue = "2-PART RETURN";
            }
        } else if (sFieldID.equals("A1_G")) {
            sValue = "";
        } else {
            Log.e((String)this.TAG, (String)("Coupon " + this.couponFormat + " field " + sFieldID + " not defined"));
            sValue = "??";
        }
        return sValue;
    }

    String dateToTime(Date dteDate) {
        return DataConvert.displayTextTime(dteDate);
    }

    String DateToString(Date dteDate) {
        int year = 0;
        int month = 0;
        int dayOfMonth = 0;
        String[] rspMonth = new String[]{"JNR", "FEB", "MAR", "APR", "MAY", "JUN", "JLY", "AUG", "SEP", "OCT", "NOV", "DEC"};
        year = DataConvert.getYear(dteDate);
        month = DataConvert.getMonth(dteDate);
        dayOfMonth = DataConvert.getDayOfMonth(dteDate);
        String strYear = String.format("%02d", year - 2000);
        String strMonth = rspMonth[month];
        String strDay = String.format("%02d", dayOfMonth);
        return strDay + "-" + strMonth + "-" + strYear;
    }

    Date stringToDate(String strDate) {
        int year = 0;
        int month = 0;
        int dayOfMonth = 0;
        int hour = 0;
        int minute = 0;
        if (strDate.length() >= 4) {
            year = Integer.parseInt(strDate.substring(0, 4));
        }
        if (strDate.length() >= 6) {
            month = Integer.parseInt(strDate.substring(4, 6));
        }
        if (strDate.length() >= 8) {
            dayOfMonth = Integer.parseInt(strDate.substring(6, 8));
        }
        if (strDate.length() >= 10) {
            hour = Integer.parseInt(strDate.substring(8, 10));
        }
        if (strDate.length() >= 12) {
            minute = Integer.parseInt(strDate.substring(10, 12));
        }
        Date dateRepresentation = DataConvert.setDate(null, year, month, dayOfMonth);
        dateRepresentation = DataConvert.setTime(dateRepresentation, hour, minute, 0);
        return dateRepresentation;
    }

    private String NumberToWords(int intNumber) {
        String[] strNumbers = new String[]{"NIL", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVERN", "EIGHT", "NINE"};
        if (intNumber > 9) {
            return String.format("00", intNumber);
        }
        if (intNumber < 0) {
            return "ERROR";
        }
        return strNumbers[intNumber];
    }
}

