/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.LocationGUI;

import android.app.ActionBar;
import android.app.Activity;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationBL.LocationManager;
import com.example.twolibs.LocationGUI.LocationListAdaptor;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.TraceHandler;
import java.io.Serializable;
import java.util.ArrayList;

public class LocationLookup
extends ListActivity {
    private static String CLASS_NAME = "DutyMain";
    ArrayList<Location> list = new ArrayList();
    LocationListAdaptor adapter;
    ListView listview;
    boolean toSearch;
    int iNumRequested = 40;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_locationlookup);
        ActionBar actionBar = this.getActionBar();
        actionBar.hide();
        int callContext = this.getIntent().getIntExtra("CallContext", 0);
        this.toSearch = callContext == CallingContext.FROM_SEARCH.ordinal();
        TextView capTitle = (TextView)this.findViewById(R.id.capTitle);
        if (this.toSearch) {
            this.setTitle("To");
            capTitle.setText((CharSequence)"To");
        } else {
            this.setTitle("From");
            capTitle.setText((CharSequence)"From");
        }
        String locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/LocTable.txt";
        LocationManager.refreshdata(locfile);
        this.listview = (ListView)this.findViewById(16908298);
        this.adapter = new LocationListAdaptor((Activity)this, this.list);
        this.setListAdapter((ListAdapter)this.adapter);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String FUNC_NAME = "onItemClick";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onItemClick", TraceHandler.Category.GUI, "listview " + position, 0);
                Intent returnIntent = new Intent();
                returnIntent.putExtra("ResultData", (Serializable)LocationLookup.this.list.get(position));
                LocationLookup.this.setResult(-1, returnIntent);
                LocationLookup.this.finish();
            }
        });
        LinearLayout frmTitle = (LinearLayout)this.findViewById(R.id.frmTitle);
        frmTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String FUNC_NAME = "frmTitle";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "frmTitle", TraceHandler.Category.GUI, "frmTitle", 0);
                LocationLookup.this.dispatchKeyEvent(new KeyEvent(0, 4));
                LocationLookup.this.dispatchKeyEvent(new KeyEvent(1, 4));
            }
        });
        EditText txtSearch = (EditText)this.findViewById(R.id.txtSearch);
        txtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                String FUNC_NAME = "afterTextChanged";
                EditText txtSearch = (EditText)LocationLookup.this.findViewById(R.id.txtSearch);
                String sSearch = txtSearch.getText().toString();
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "afterTextChanged", TraceHandler.Category.GUI, "afterTextChanged>" + sSearch + "<", 0);
                LocationLookup.this.doSearch(LocationLookup.this.toSearch, sSearch);
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        String sSearch = txtSearch.getText().toString();
        this.doSearch(this.toSearch, sSearch);
        txtSearch.requestFocus();
    }

    public void doSearch(boolean pToSearch, String pSearch) {
        String FUNC_NAME = "doSearch";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearch", TraceHandler.Category.ENTRY, "doSearch", 0);
        AppContext bb = (AppContext)this.getApplicationContext();
        String strSeed = pToSearch ? bb.getOrigin().getNLC() : bb.getHomeNLC();
        LocationManager.SearchResponse resp = LocationManager.GetMatchingLocations(strSeed, pToSearch, pSearch, this.iNumRequested);
        ArrayList<Location> myList = resp.locations;
        String sProgress = "To=" + pToSearch + " " + strSeed + ":" + pSearch + "Res " + myList.size() + " ";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearch", TraceHandler.Category.EXIT, "doSearch " + sProgress, 0);
        this.adapter.clear();
        this.adapter.addAll(myList);
        this.adapter.notifyDataSetChanged();
    }

    public static enum CallingContext {
        FROM_SEARCH,
        TO_SEARCH;

    }
}

