/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.RetailGUI;

import android.app.ActionBar;
import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.R;
import com.example.twolibs.RetailBL.RetailHelper;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.RetailBL.RetailItemSupport;
import com.example.twolibs.RetailBL.RetailManager;
import com.example.twolibs.RetailGUI.RetailListAdaptor;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;

public class RetailMain
extends ListActivity {
    private static String CLASS_NAME = "RetailMain";
    ArrayList<RetailItemSupport> list = new ArrayList();
    int iCurrentSelection = -1;
    int iCurrentMenu = -1;
    RetailListAdaptor adapter;
    ListView listview;

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    public void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(R.layout.activity_retail_main);
        ActionBar actionBar = this.getActionBar();
        actionBar.hide();
        final AppContext bb = (AppContext)this.getApplicationContext();
        RetailManager.refreshdata();
        this.listview = (ListView)this.findViewById(16908298);
        this.list = RetailHelper.doGetHierarchy();
        this.adapter = new RetailListAdaptor((Activity)this, this.list);
        this.setListAdapter((ListAdapter)this.adapter);
        this.setMenu(0);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                String FUNC_NAME = "onItemClick";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onItemClick", TraceHandler.Category.GUI, "listview " + position, 0);
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    View rowView = parent.getChildAt(j);
                    rowView.setBackgroundColor(0);
                }
                if (position == RetailMain.this.iCurrentSelection) {
                    RetailMain.this.setMenu(0);
                    bb.selRetail = null;
                    RetailMain.this.iCurrentSelection = -1;
                    RetailMain.this.list.get((int)position).itemSelected = 0;
                } else {
                    RetailMain.this.setMenu(1);
                    bb.selRetail = RetailMain.this.list.get((int)position).leaf;
                    RetailMain.this.iCurrentSelection = position;
                    RetailMain.this.list.get((int)position).itemSelected = 1;
                    view.setBackgroundColor(RetailMain.this.JMgetColor(R.color.selection_background, RetailMain.this.getTheme()));
                }
            }
        });
        Button cmdBasket = (Button)this.findViewById(R.id.cmdBasket);
        cmdBasket.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String FUNC_NAME = "onClick";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onClick", TraceHandler.Category.GUI, "cmdDone", 0);
                Intent returnIntent = new Intent();
                returnIntent.putExtra("nextAction", "basket");
                RetailMain.this.setResult(-1, returnIntent);
                RetailMain.this.finish();
            }
        });
        this.doCheckComplete();
        EditText txtSearch = (EditText)this.findViewById(R.id.txtSearch);
        txtSearch.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                String FUNC_NAME = "afterTextChanged";
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "afterTextChanged", TraceHandler.Category.GUI, "txtSearch " + s, 0);
                RetailMain.this.doSearch();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        txtSearch.requestFocus();
    }

    public void doSearch() {
        String FUNC_NAME = "doSearch";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doSearch", TraceHandler.Category.ENTRY, "", 0);
        EditText et = (EditText)this.findViewById(R.id.txtSearch);
        String search = DataConvert.toUpperCase(et.getText().toString());
        ArrayList<RetailItemSupport> listCopy = RetailManager.doSearchItems(search);
        this.adapter.clear();
        this.adapter.addAll(listCopy);
        this.adapter.notifyDataSetChanged();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.doCheckComplete();
    }

    void doCheckComplete() {
        String FUNC_NAME = "doCheckComplete";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doCheckComplete", TraceHandler.Category.GUI, "", 0);
        this.adapter.notifyDataSetChanged();
    }

    private void setMenu(int iMenu) {
        if (iMenu != this.iCurrentMenu) {
            LinearLayout layFormMenu = (LinearLayout)this.findViewById(R.id.layFormMenu);
            layFormMenu.removeAllViews();
            LayoutInflater inflater = this.getLayoutInflater();
            if (iMenu == 0) {
                layFormMenu.addView(inflater.inflate(R.layout.retailitem_main_menu0, null));
                Button cmdEarlier = (Button)this.findViewById(R.id.cmdBasket);
                cmdEarlier.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        String FUNC_NAME = "onClick";
                        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "onClick", TraceHandler.Category.GUI, "cmdDone", 0);
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "basket");
                        RetailMain.this.setResult(-1, returnIntent);
                        RetailMain.this.finish();
                    }
                });
                Button cmdScan = (Button)this.findViewById(R.id.cmdScan);
                cmdScan.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)RetailMain.this, (CharSequence)"Scan  Clicked", (int)0).show();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        RetailMain.this.setResult(-1, returnIntent);
                        RetailMain.this.finish();
                    }
                });
            } else {
                layFormMenu.addView(inflater.inflate(R.layout.retailitem_main_menu1, null));
                Button cmdEarlier = (Button)this.findViewById(R.id.cmdBasket);
                cmdEarlier.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)RetailMain.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selRetail != null) {
                            RetailItem tt = bb.selRetail;
                            bs.addRetailItem(tt, tt.Price);
                        }
                        Toast.makeText((Context)RetailMain.this, (CharSequence)("Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "");
                        RetailMain.this.setResult(-1, returnIntent);
                        RetailMain.this.finish();
                    }
                });
                Button cmdLater = (Button)this.findViewById(R.id.cmdCard);
                cmdLater.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)RetailMain.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selRetail != null) {
                            RetailItem tt = bb.selRetail;
                            bs.addRetailItem(tt, tt.Price);
                        }
                        Toast.makeText((Context)RetailMain.this, (CharSequence)("Card  Clicked - Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "card");
                        RetailMain.this.setResult(-1, returnIntent);
                        RetailMain.this.finish();
                    }
                });
                Button cmdCash = (Button)this.findViewById(R.id.cmdCash);
                cmdCash.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AppContext bb = (AppContext)RetailMain.this.getApplicationContext();
                        Basket bs = bb.basket;
                        if (bb.selRetail != null) {
                            RetailItem tt = bb.selRetail;
                            bs.addRetailItem(tt, tt.Price);
                        }
                        Toast.makeText((Context)RetailMain.this, (CharSequence)("Cash  Clicked - Basket  items: " + bs.basketProducts.size()), (int)0).show();
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("nextAction", "cash");
                        RetailMain.this.setResult(-1, returnIntent);
                        RetailMain.this.finish();
                    }
                });
            }
            this.iCurrentMenu = iMenu;
        }
    }

    public Intent getParentActivityIntent() {
        Intent newIntent = null;
        newIntent = new Intent(this.getApplicationContext(), MenuTop.class);
        return newIntent;
    }

    public static enum CallContext {
        DISPLAY;

    }
}

