/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import com.example.twolibs.DevicesBL.RollPrinterService;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.FareSetManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTSearch;
import java.util.Date;

public class AppContext
extends Application {
    private static String CLASS_NAME = "AppContext";
    public static final String CALL_CONTEXT = "CallContext";
    public static final String CALL_CALLER = "Caller";
    public static final String CALL_RESULT_DATA = "ResultData";
    public static final String MESSAGE_REQUEST = "message_request";
    public static final String MESSAGE_ID = "message_id";
    public static final String MESSAGE_RESPONSE = "message_response";
    public static final String MESSAGE_ORIGIN = "message_origin";
    public static final String RESULT = "result";
    public static final String NOTIFICATION = "com.example.twolibs";
    public static double refreshNo = 0.0;
    public int menuStatus = 0;
    public String menuTitle = "Home";
    public int menuAdminStatus = 0;
    public String menuAdminTitle = "Admin";
    public int menuFaresStatus = 0;
    public String menuFaresTitle = "Fares";
    public String strHomeNLC;
    public Location Origin = new Location();
    public Location Destination = new Location();
    public FareManager fareManager = new FareManager();
    public FareSetManager fareSetManager = new FareSetManager();
    public Basket basket = new Basket();
    public TTSearch ttSearch = new TTSearch();
    public TTJourney selJourney = new TTJourney();
    public TNFare selFare = null;
    public RetailItem selRetail = null;
    public int faresSortOrder = 0;
    public int faresSortType = 0;
    public int faresClass = 0;
    private int SearchDirection = 0;
    private int Changes = 6;
    private Date SearchDate = new Date();
    private int NumAdults = 1;
    private int NumChildren = 0;
    private int NumAAA = 0;
    private String RailcardCode = "   ";
    private int VariableDiscount = 0;
    private boolean ShowAllFares = false;
    private String RollRequest = "";
    private boolean deviceScreenActive = false;
    private String DefaultFulfillmentMethod = "CCST";
    private final BroadcastReceiver receiverRoll = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                String origin;
                int resultCode = bundle.getInt(AppContext.RESULT);
                String string = bundle.getString(AppContext.MESSAGE_RESPONSE);
                if (string == null) {
                    string = "";
                }
                if ((origin = bundle.getString(AppContext.MESSAGE_ORIGIN)) == null) {
                    string = "";
                }
                Log.e((String)"AC", (String)("Message from  " + origin));
                AppContext.this.RollRequest = string;
                if (origin.equals(RollPrinterService.CLASS_NAME)) {
                    AppContext.this.refreshDisplay(99, string, 0);
                }
            }
        }
    };

    public void initialise() {
        TraceHandler.startTrace();
        this.registerReceiver(this.receiverRoll, new IntentFilter(NOTIFICATION));
        System.loadLibrary("LOCATIONS");
        System.loadLibrary("TT");
        System.loadLibrary("FARES");
        int currentapiVersion = Build.VERSION.SDK_INT;
        if (currentapiVersion > 21) {
            // empty if block
        }
        String fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FARES.FIB";
        FareManager.STDResponse respFM = this.fareManager.doLoad(fibFile);
        FareSetManager.STDResponse respFSM = this.fareSetManager.doLoad(this);
        FulfilmentManager.refreshdata();
    }

    public void checkStatus() {
        this.menuStatus = 1;
        this.menuTitle = "Home";
        this.menuFaresStatus = 0;
        this.menuFaresTitle = "Fares";
        int thisStatus = 1;
        String thisTitle = "";
        thisStatus = this.basket.checkStatus();
        thisTitle = this.basket.buttonTitle;
        if (thisStatus > this.menuStatus) {
            this.menuStatus = thisStatus;
            this.menuTitle = thisTitle;
        }
        this.menuAdminStatus = 1;
        this.menuAdminTitle = "Admin";
        GenericManager.DomainStatusResponse resp = new GenericManager.DomainStatusResponse();
        resp = DutyManager.checkStatus();
        thisStatus = resp.status.ordinal();
        if (thisStatus > this.menuAdminStatus) {
            this.menuAdminStatus = resp.status.ordinal();
            this.menuAdminTitle = resp.shortDescrition;
        }
        if (this.menuAdminStatus > this.menuStatus) {
            this.menuStatus = this.menuAdminStatus;
            this.menuTitle = this.menuAdminTitle;
        }
    }

    public String getHomeNLC() {
        return this.strHomeNLC;
    }

    public void setHomeNLC(String p) {
        this.strHomeNLC = p;
    }

    public Location getOrigin() {
        return this.Origin;
    }

    public void setOrigin(Location p) {
        this.Origin = p;
    }

    public Location getDestination() {
        return this.Destination;
    }

    public void setDestination(Location p) {
        this.Destination = p;
    }

    public Date getSearchDate() {
        return this.SearchDate;
    }

    public void setSearchDate(Date searchDate) {
        this.SearchDate = searchDate;
    }

    public int getSearchDirection() {
        return this.SearchDirection;
    }

    public void setSearchDirection(int searchDirection) {
        this.SearchDirection = searchDirection;
    }

    public int getChanges() {
        return this.Changes;
    }

    public void setChanges(int changes) {
        this.Changes = changes;
    }

    public int getNumAdults() {
        return this.NumAdults;
    }

    public void setNumAdults(int numAdults) {
        this.NumAdults = numAdults;
    }

    public int getNumChildren() {
        return this.NumChildren;
    }

    public void setNumChildren(int numChildren) {
        this.NumChildren = numChildren;
    }

    public int getNumAAA() {
        return this.NumAAA;
    }

    public void setNumAAA(int numAAA) {
        this.NumAAA = numAAA;
    }

    public String getRailcardCode() {
        return this.RailcardCode;
    }

    public void setRailcardCode(String railcardCode) {
        this.RailcardCode = railcardCode;
    }

    public int getVariableDiscount() {
        return this.VariableDiscount;
    }

    public void setVariableDiscount(int variableDiscount) {
        this.VariableDiscount = variableDiscount;
    }

    public boolean getShowAllFares() {
        return this.ShowAllFares;
    }

    public void setShowAllFares(boolean showAllFares) {
        this.ShowAllFares = showAllFares;
    }

    public String getDefaultFulfillmentMethod() {
        return this.DefaultFulfillmentMethod;
    }

    public void setDefaultFulfillmentMethod(String defaultFulfillmentMethod) {
        this.DefaultFulfillmentMethod = defaultFulfillmentMethod;
    }

    private void refreshDisplay(int request, String message, int result) {
        String FUNC_NAME = "refreshDisplay";
        Intent intent = new Intent(NOTIFICATION);
        intent.putExtra(MESSAGE_REQUEST, request);
        intent.putExtra(MESSAGE_ID, 1);
        intent.putExtra(MESSAGE_RESPONSE, message);
        intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);
        intent.putExtra(RESULT, result);
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "refreshDisplay", TraceHandler.Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);
        this.sendBroadcast(intent);
    }

    public static class DomainStatusResponse
    extends STDResponse {
        public MenuState status = MenuState.NORMAL;
        public String shortDescrition = "";
    }

    public static enum MenuState {
        UNKOWN,
        NORMAL,
        NOTIFY,
        WARNING,
        ERROR;

    }

    public static class STDResponse {
        public int result = 0;
        public String extra = "";
        public String trace = "";
    }
}

