/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyBL;

import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DutyTask {
    private static String CLASS_NAME = "DutyTask";
    public String taskId = "";
    public String taskType = "";
    public Date taskStart = DataConvert.DATENULL;
    public Date taskEnd = DataConvert.DATENULL;
    public TaskState taskState = TaskState.NOTE;
    public boolean taskSelected = false;
    public Location taskLocationFrom = null;
    public Location taskLocationTo = null;
    public String taskComment = "";
    public Date trainDepart = DataConvert.DATENULL;
    public String trainRetailId = "";
    public String trainHeadCode = "";
    public ArrayList<String> trainStopsNLC = new ArrayList();
    public boolean reservations = false;
    public boolean assistedPassengers = true;
    public Date assistPassChecked = null;

    public String taskStateDesc() {
        return this.taskState.name();
    }

    public static DutyTask fromXML(Node pNode) {
        String location;
        String FUNC_NAME = "fromXML";
        DutyTask task = new DutyTask();
        try {
            task.taskId = pNode.getAttributes().getNamedItem("taskId").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskId Parsing Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            task.taskType = pNode.getAttributes().getNamedItem("taskType").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskType Parsing Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            String taskTime = pNode.getAttributes().getNamedItem("taskStart").getTextContent();
            task.taskStart = DataConvert.parseHHmmss(taskTime);
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskStart Parsing Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            location = pNode.getAttributes().getNamedItem("locationFrom").getTextContent();
            task.taskLocationFrom = Location.getLocationByNLC(location);
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML locationFrom Parsing Exception = " + e.getMessage(), 0);
        }
        try {
            location = pNode.getAttributes().getNamedItem("locationTo").getTextContent();
            task.taskLocationTo = Location.getLocationByNLC(location);
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML locationTo Parsing Exception = " + e.getMessage(), 0);
        }
        try {
            Element element = (Element)pNode;
            NodeList nodeList = element.getElementsByTagName("comment");
            task.taskComment = nodeList.item(0).getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML comment Parsing Exception = " + e.getMessage(), 0);
        }
        task.taskState = TaskState.TODO;
        return task;
    }

    public static enum TaskState {
        TODO,
        DUE,
        ACTIVE,
        COMPLETE,
        EXPIRED,
        NOTE;

        public static final String[] names;

        static {
            names = new String[TaskState.values().length];
            TaskState[] values = TaskState.values();
            for (int i = 0; i < values.length; ++i) {
                TaskState.names[i] = values[i].name();
            }
        }
    }
}

