/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.DutyBL;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DutyTaskType {
    private static String CLASS_NAME = "DutyTaskType";
    public static HashMapX<String, DutyTaskType> dutyTaskTypes = new HashMapX();
    public String taskTypeCode = "";
    public String taskTypeTitle = "";
    public TaskSpecialAction taskSpecialAction = TaskSpecialAction.NONE;
    public int taskTypeNofify = 0;

    public static DutyTaskType getTaskType(String pTaskTypeCode) {
        DutyTaskType dutyTaskType = dutyTaskTypes.getValue(pTaskTypeCode);
        return dutyTaskType;
    }

    public static ArrayList<DutyTaskType> getTaskTypes() {
        String FUNC_NAME = "getTaskTypes";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "getTaskTypes", TraceHandler.Category.ENTRY, "", 0);
        ArrayList<DutyTaskType> taskTypeList = new ArrayList<DutyTaskType>();
        for (DutyTaskType taskType : dutyTaskTypes.values()) {
            taskTypeList.add(taskType);
        }
        return taskTypeList;
    }

    public static HashMapX<String, DutyTaskType> doLoadXML() {
        String FUNC_NAME = "doLoadXML";
        TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadXML", TraceHandler.Category.ENTRY, "", 0);
        dutyTaskTypes = new HashMapX();
        DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(DataTransferManager.FileType.DUTYTASKTYPES);
        if (resp.result == GenericManager.Response.OK) {
            try {
                NodeList nodeList = resp.doc.getElementsByTagName("dutytasktype");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    DutyTaskType taskType = DutyTaskType.fromXML(node);
                    if (taskType == null) continue;
                    dutyTaskTypes.put(taskType.taskTypeCode, taskType);
                }
                TraceHandler.Trace(TraceHandler.TraceLevel.DEBUG, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "Loaded " + dutyTaskTypes.size(), 0);
            }
            catch (Exception e) {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "XML Pasing Exception = " + e, 0);
            }
        } else {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "doLoadXML", TraceHandler.Category.EXIT, "Document not loaded", 0);
        }
        return dutyTaskTypes;
    }

    public static DutyTaskType fromXML(Node pNode) {
        String notify;
        String FUNC_NAME = "fromXML";
        DutyTaskType taskType = new DutyTaskType();
        try {
            taskType.taskTypeCode = pNode.getAttributes().getNamedItem("taskTypeCode").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskTypeCode Parsing Exception = " + e.getMessage(), 0);
            return null;
        }
        try {
            taskType.taskTypeTitle = pNode.getAttributes().getNamedItem("taskTypeTitle").getTextContent();
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskTypeTitle Parsing Excpetion = " + e.getMessage(), 0);
            taskType.taskTypeTitle = taskType.taskTypeCode;
        }
        try {
            notify = DataConvert.toUpperCase(pNode.getAttributes().getNamedItem("taskTypeAction").getTextContent());
            if (notify.equals(TaskSpecialAction.BOARD_TRAIN.name())) {
                taskType.taskSpecialAction = TaskSpecialAction.BOARD_TRAIN;
            } else if (notify.equals(TaskSpecialAction.EXCESS_FARE.name())) {
                taskType.taskSpecialAction = TaskSpecialAction.EXCESS_FARE;
            } else if (notify.equals(TaskSpecialAction.QUEUE_BUST.name())) {
                taskType.taskSpecialAction = TaskSpecialAction.QUEUE_BUST;
            } else if (notify.equals(TaskSpecialAction.NONE.name())) {
                taskType.taskSpecialAction = TaskSpecialAction.NONE;
            } else {
                TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskTypeAction unknown = " + notify, 0);
            }
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskTypeAction Parsing Excpetion = " + e.getMessage(), 0);
            taskType.taskTypeNofify = 0;
        }
        try {
            notify = pNode.getAttributes().getNamedItem("taskTypeNofify").getTextContent();
            taskType.taskTypeNofify = DataConvert.stringToInt(notify);
        }
        catch (Exception e) {
            TraceHandler.Trace(TraceHandler.TraceLevel.ERROR, CLASS_NAME, "fromXML", TraceHandler.Category.ENTRY, "XML taskTypeNofify Parsing Excpetion = " + e.getMessage(), 0);
            taskType.taskTypeNofify = 0;
        }
        return taskType;
    }

    public static enum TaskSpecialAction {
        BOARD_TRAIN,
        QUEUE_BUST,
        EXCESS_FARE,
        NONE;

    }
}

