/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FaresGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import java.util.ArrayList;

public class TicketListAdaptor
extends ArrayAdapter<TNFare> {
    private final Activity context;
    private final ArrayList<TNFare> faresList;
    private final AppContext bb;
    private View.OnClickListener mOnFulfillmentClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            LinearLayout container_1 = (LinearLayout)v.getParent();
            LinearLayout container_2 = (LinearLayout)container_1.getParent();
            LinearLayout container_3 = (LinearLayout)container_2.getParent();
            RelativeLayout row_container = (RelativeLayout)container_3.getParent();
            ListView parent = (ListView)row_container.getParent();
            int position = parent.getPositionForView(v);
            final TNFare fare = (TNFare)TicketListAdaptor.this.faresList.get(position);
            if (position != -1) {
                CharSequence[] items = new String[]{"CCST", "SMART", "ROLL", "BAR CODED"};
                AlertDialog.Builder listBuilder = new AlertDialog.Builder((Context)TicketListAdaptor.this.context);
                listBuilder.setTitle((CharSequence)"Fulfilment");
                listBuilder.setItems(items, new DialogInterface.OnClickListener((String[])items){
                    final /* synthetic */ String[] val$items;
                    {
                        this.val$items = stringArray;
                    }

                    public void onClick(DialogInterface dialog, int item) {
                        fare.setFa_FulfillmentMethod(this.val$items[item]);
                    }
                });
                AlertDialog alertList = listBuilder.create();
                alertList.show();
            }
        }
    };

    public TicketListAdaptor(Activity context, ArrayList<TNFare> list, AppContext bb) {
        super((Context)context, R.layout.ticket_summary, list);
        this.context = context;
        this.faresList = list;
        this.bb = bb;
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.context.getResources().getColor(Color, TH);
        }
        return this.context.getResources().getColor(Color);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View rowView = convertView;
        LayoutInflater inflater = this.context.getLayoutInflater();
        if (rowView == null) {
            rowView = inflater.inflate(R.layout.ticket_summary, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.txtClass = (TextView)rowView.findViewById(R.id.txtClass);
            viewHolder.txtTicketCode = (TextView)rowView.findViewById(R.id.txtTicketCode);
            viewHolder.txtTicketDesc = (TextView)rowView.findViewById(R.id.txtTicketDesc);
            viewHolder.txtCost = (TextView)rowView.findViewById(R.id.txtCost);
            viewHolder.txtOrigin = (TextView)rowView.findViewById(R.id.txtOrigin);
            viewHolder.txtDestination = (TextView)rowView.findViewById(R.id.txtDestination);
            viewHolder.txtFlowOwner = (TextView)rowView.findViewById(R.id.txtFlowOwner);
            viewHolder.txtRoute = (TextView)rowView.findViewById(R.id.txtRoute);
            viewHolder.txtRestrictionCode = (TextView)rowView.findViewById(R.id.txtRestrictionCode);
            viewHolder.txtFulfillmentMethod = (TextView)rowView.findViewById(R.id.txtFulfillmentType);
            viewHolder.layReasons = (LinearLayout)rowView.findViewById(R.id.layReasons);
            viewHolder.layFulfillmentType = (LinearLayout)rowView.findViewById(R.id.layFulfillmentType);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        TNFare s = this.faresList.get(position);
        if (s.itemSelected == 0) {
            rowView.setBackgroundColor(0);
        } else {
            rowView.setBackgroundColor(this.JMgetColor(R.color.selection_background, this.context.getTheme()));
        }
        if (s.getFa_FareClass() == 1) {
            holder.txtClass.setText((CharSequence)"1st");
            holder.txtClass.setTextColor(this.JMgetColor(R.color.fj_blue_3, this.context.getTheme()));
        } else {
            holder.txtClass.setText((CharSequence)"STD");
            holder.txtClass.setTextColor(this.JMgetColor(R.color.fj_black_0, this.context.getTheme()));
        }
        holder.txtTicketCode.setText((CharSequence)s.getFa_TicketTypeCode());
        String txtTicketCode = s.getFa_TicketTypeCode();
        if (FareManager.ticketCodes.containsKey(txtTicketCode)) {
            TicketDetails tkt = FareManager.ticketCodes.getValue(txtTicketCode);
            holder.txtTicketDesc.setText((CharSequence)tkt.getTd_TicketTypeDesc());
        } else {
            holder.txtTicketDesc.setText((CharSequence)(txtTicketCode + "????"));
        }
        double intCost = (double)s.getFa_TotalFareS() / 100.0;
        holder.txtCost.setText((CharSequence)String.format("\u00a3%.2f", intCost));
        String txtNLCCode = s.getFa_FareOriginLocation();
        Location loc = Location.getLocationByNLC(txtNLCCode);
        String txtLoc = loc != null ? loc.getDescription().trim() : "";
        if (txtLoc.length() > 0) {
            holder.txtOrigin.setText((CharSequence)txtLoc);
        } else {
            holder.txtOrigin.setText((CharSequence)txtNLCCode);
        }
        txtNLCCode = s.getFa_FareDestinationLocation();
        loc = Location.getLocationByNLC(txtNLCCode);
        txtLoc = loc != null ? loc.getDescription().trim() : "";
        if (txtLoc.length() > 0) {
            holder.txtDestination.setText((CharSequence)txtLoc);
        } else {
            holder.txtDestination.setText((CharSequence)txtNLCCode);
        }
        holder.txtFlowOwner.setText((CharSequence)s.getFa_FlowOwner());
        holder.txtRoute.setText((CharSequence)s.getFa_RouteDescription());
        holder.txtRestrictionCode.setText((CharSequence)s.getFa_RestrictionCode());
        holder.txtFulfillmentMethod.setText((CharSequence)s.getFa_FulfillmentMethod());
        holder.layFulfillmentType.setOnClickListener(this.mOnFulfillmentClickListener);
        if (s.itemSelected == 0) {
            holder.txtFulfillmentMethod.setEnabled(false);
            holder.txtFulfillmentMethod.setTextColor(this.JMgetColor(R.color.edit_text, this.context.getTheme()));
            holder.txtFulfillmentMethod.setBackgroundColor(0);
        } else {
            holder.txtFulfillmentMethod.setEnabled(true);
            holder.txtFulfillmentMethod.setTextColor(this.JMgetColor(R.color.button_text, this.context.getTheme()));
            holder.txtFulfillmentMethod.setBackgroundColor(this.JMgetColor(R.color.button_background, this.context.getTheme()));
        }
        String txtNoSaleReason = s.getFa_NoSaleReason();
        if (txtNoSaleReason.length() == 0) {
            holder.layReasons.removeAllViews();
        } else {
            holder.layReasons.removeAllViews();
            holder.layReasons.addView(inflater.inflate(R.layout.ticket_summary_reason, null));
            TextView txtNotes = (TextView)rowView.findViewById(R.id.txtNotes);
            txtNotes.setText((CharSequence)s.getFa_NoSaleReason());
        }
        return rowView;
    }

    static class ViewHolder {
        public TextView txtClass;
        public TextView txtTicketCode;
        public TextView txtTicketDesc;
        public TextView txtCost;
        public TextView txtOrigin;
        public TextView txtDestination;
        public TextView txtFlowOwner;
        public TextView txtRoute;
        public TextView txtRestrictionCode;
        public TextView txtFulfillmentMethod;
        public LinearLayout layReasons;
        public LinearLayout layFulfillmentType;

        ViewHolder() {
        }
    }
}

