/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.FulfilmentGUI;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.example.twolibs.AppContext;
import com.example.twolibs.DevicesBL.CCSTPrinterService;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.R;

public class CCSTPrinting
extends Activity {
    private String TAG = "CCSTPrinting";
    private int currentCoupon = 0;
    private AppContext bb = null;
    private final BroadcastReceiver receiverCCST = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getExtras();
            if (bundle != null) {
                int request;
                String origin;
                int resultCode = bundle.getInt("result");
                String string2 = bundle.getString("message_response");
                if (string2 == null) {
                    string2 = "";
                }
                if ((origin = bundle.getString("message_origin")) == null) {
                    origin = "no origin";
                }
                Log.e((String)"DS", (String)("BC1 received " + origin));
                TextView tv = (TextView)CCSTPrinting.this.findViewById(R.id.txtCCSTStatus);
                if (origin.equals(CCSTPrinterService.CLASS_NAME)) {
                    if (resultCode == -1) {
                        tv.setText((CharSequence)("CCST ok" + string2));
                        tv.setBackgroundColor(-16711936);
                        tv.setTextColor(-16777216);
                    } else {
                        tv.setText((CharSequence)("CCST failed " + resultCode + "\n" + string2));
                        tv.setBackgroundColor(-65536);
                        tv.setTextColor(-16777216);
                    }
                }
                if (origin.equals(CCSTPrinterService.CLASS_NAME) && (request = bundle.getInt("message_request")) == 22) {
                    CCSTPrinting.this.doPrintCouponNext();
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        String nextAction;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ccst_printing);
        this.setTitle(" CCST Printing");
        this.bb = (AppContext)this.getApplicationContext();
        this.bb.basket.refreshBasket(this.bb);
        Button cmdTestPrint = (Button)this.findViewById(R.id.cmdTestPrint);
        cmdTestPrint.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Log.e((String)CCSTPrinting.this.TAG, (String)"cmdTestPrint requested");
                CCSTPrinting.this.doPrintTestCoupon();
            }
        });
        Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
        cmdDone.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Log.e((String)CCSTPrinting.this.TAG, (String)"cmdDone requested");
                Intent returnIntent = new Intent();
                CCSTPrinting.this.setResult(-1, returnIntent);
                CCSTPrinting.this.finish();
            }
        });
        Button cmdCCSTStatus = (Button)this.findViewById(R.id.cmdCCSTStatus);
        cmdCCSTStatus.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TextView txtCCSTStatus = (TextView)CCSTPrinting.this.findViewById(R.id.txtCCSTStatus);
                txtCCSTStatus.setText((CharSequence)"Checking printer");
                Intent intent = new Intent((Context)CCSTPrinting.this, CCSTPrinterService.class);
                intent.putExtra("message_request", 21);
                intent.putExtra("mac_address", "");
                CCSTPrinting.this.startService(intent);
            }
        });
        Intent intent = this.getIntent();
        if (intent != null && (nextAction = intent.getStringExtra("nextAction")) != null && nextAction.equals("print")) {
            this.doPrintCouponNext();
        }
    }

    protected void onResume() {
        super.onResume();
        this.registerReceiver(this.receiverCCST, new IntentFilter("com.example.twolibs"));
    }

    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(this.receiverCCST);
    }

    public void doPrintTestCoupon() {
        TextView txtCCSTStatus = (TextView)this.findViewById(R.id.txtCCSTStatus);
        FulfilmentManager.STDCreateCouponsResponse resp = FulfilmentManager.createTestCoupon();
        if (resp.ccstCoupons.size() < 1) {
            txtCCSTStatus.setText((CharSequence)"Error formating test coupon ");
            return;
        }
        CCSTCoupon coupon = resp.ccstCoupons.get(0);
        this.currentCoupon = this.bb.basket.ccstCoupons.size() + 1;
        txtCCSTStatus.setText((CharSequence)"Printing test coupon ");
        Intent intent = new Intent((Context)this, CCSTPrinterService.class);
        intent.putExtra("message_request", 22);
        intent.putExtra("message_content", coupon.strPrintMessage);
        this.startService(intent);
    }

    public void doPrintCouponNext() {
        TextView txtCCSTStatus = (TextView)this.findViewById(R.id.txtCCSTStatus);
        ++this.currentCoupon;
        if (this.currentCoupon > this.bb.basket.ccstCoupons.size()) {
            txtCCSTStatus.setText((CharSequence)("Finished printing " + this.bb.basket.ccstCoupons.size()));
            this.currentCoupon = 0;
            return;
        }
        txtCCSTStatus.setText((CharSequence)("Printing coupon " + this.currentCoupon + " of " + this.bb.basket.ccstCoupons.size()));
        CCSTCoupon coupon = this.bb.basket.ccstCoupons.get(this.currentCoupon - 1);
        Intent intent = new Intent((Context)this, CCSTPrinterService.class);
        intent.putExtra("message_request", 22);
        intent.putExtra("message_content", coupon.strPrintMessage);
        this.startService(intent);
    }
}

