/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.LocationBL;

import com.example.twolibs.LocationBL.Location;
import java.io.File;
import java.util.ArrayList;

public class LocationManager {
    private static String CLASS_NAME = "LocationManager";
    private static boolean refreshRequired = true;
    private static String DataDomain = "LocationData";
    private static LocationManager myInstance = new LocationManager();

    public static void dataChanged(String pDataDomain) {
        if (pDataDomain.equals(DataDomain)) {
            refreshRequired = true;
        }
    }

    public static void refreshdata(String locfile) {
        String FUNC_NAME = "refreshdata";
        if (refreshRequired) {
            STDResponse resp = new STDResponse();
            resp.result = -1;
            resp.trace = "Begin";
            File file = new File(locfile);
            int iTraceSize = 10000;
            byte[] bTrace = LocationManager.StringToCBuff(iTraceSize, "");
            int iLocs = LocationManager.loadData(locfile, bTrace);
            if (iLocs > 0) {
                resp.result = 0;
            }
            resp.extra = locfile + " " + iLocs + " ";
            resp.trace = LocationManager.CBuffToString(iTraceSize, bTrace);
        }
    }

    public LookupResponse GetLocationByNLC(String sSearchNLC) {
        Location objLocation;
        LookupResponse resp = new LookupResponse();
        int iResultsSize = 5000;
        int iTraceSize = 10000;
        byte[] bResults = LocationManager.StringToCBuff(iResultsSize, "");
        byte[] bTrace = LocationManager.StringToCBuff(iTraceSize, "");
        int iLocs = 0;
        int iSearchType = 2;
        iLocs = LocationManager.findLocations(iSearchType, "", false, sSearchNLC.toUpperCase(), 1, bResults, bTrace);
        if (iLocs <= 0) {
            objLocation = new Location();
        } else {
            ArrayList<Location> resultList = LocationManager.CBuffToLocations(iResultsSize, bResults);
            objLocation = resultList.get(0);
        }
        resp.extra = sSearchNLC + " " + iLocs + " ";
        resp.trace = LocationManager.CBuffToString(iTraceSize, bTrace);
        resp.location = objLocation;
        return resp;
    }

    public LookupResponse GetLocationByCRS(String sSearchCRS) {
        Location objLocation;
        LookupResponse resp = new LookupResponse();
        int iResultsSize = 5000;
        int iTraceSize = 10000;
        byte[] bResults = LocationManager.StringToCBuff(iResultsSize, "");
        byte[] bTrace = LocationManager.StringToCBuff(iTraceSize, "");
        int iLocs = 0;
        int iSearchType = 1;
        iLocs = LocationManager.findLocations(iSearchType, "", false, sSearchCRS.toUpperCase(), 1, bResults, bTrace);
        String sProgress = sSearchCRS + "Res " + iLocs + " ";
        String sFindTrace = LocationManager.CBuffToString(iTraceSize, bTrace);
        if (iLocs <= 0) {
            objLocation = new Location();
        } else {
            ArrayList<Location> resultList = LocationManager.CBuffToLocations(iResultsSize, bResults);
            objLocation = resultList.get(0);
        }
        resp.extra = sSearchCRS + " " + iLocs + " ";
        resp.trace = LocationManager.CBuffToString(iTraceSize, bTrace);
        resp.location = objLocation;
        return resp;
    }

    public static SearchResponse GetMatchingLocations(String sHome, boolean bToSearch, String sSearch, int iRequested) {
        SearchResponse resp = myInstance.new SearchResponse();
        resp.result = -1;
        resp.trace = "Begin";
        int iResultsSize = 10000;
        int iTraceSize = 10000;
        byte[] bResults = LocationManager.StringToCBuff(iResultsSize, "");
        byte[] bTrace = LocationManager.StringToCBuff(iTraceSize, "");
        int iLocs = 0;
        int iSearchType = 0;
        if (sHome == null) {
            sHome = "";
        }
        if (sSearch == null) {
            sSearch = "";
        }
        iLocs = LocationManager.findLocations(iSearchType, sHome, bToSearch, sSearch.toUpperCase(), iRequested, bResults, bTrace);
        resp.extra = sSearch + "Res " + iLocs + " ";
        if (iLocs <= 0) {
            resp.result = -2;
            resp.locations = new ArrayList();
            resp.trace = LocationManager.CBuffToString(iTraceSize, bTrace);
        } else {
            resp.result = 0;
            resp.locations = LocationManager.CBuffToLocations(iResultsSize, bResults);
            resp.trace = LocationManager.CBuffToString(iResultsSize, bTrace);
        }
        return resp;
    }

    private static String convertToDelim(ArrayList<String> pList) {
        StringBuilder delimString = new StringBuilder(1000);
        boolean first = true;
        if (pList == null) {
            return "";
        }
        for (String entry : pList) {
            if (!first) {
                delimString.append("|");
            }
            delimString.append(entry);
            first = false;
        }
        return delimString.toString();
    }

    private static ArrayList<Location> CBuffToLocations(int iSize, byte[] bInput) {
        StringBuilder sNew = new StringBuilder(200);
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList<Location> locList = new ArrayList<Location>();
        StringBuilder sField = new StringBuilder(200);
        Location loc = new Location();
        int iFieldNo = 0;
        block11: for (int i = 0; i < iSize && bInput[i] != 0; ++i) {
            char ch = (char)bInput[i];
            switch (ch) {
                case '|': {
                    switch (iFieldNo) {
                        case 0: {
                            loc.strNLC = sField.toString();
                            break;
                        }
                        case 1: {
                            loc.strCRS = sField.toString();
                            break;
                        }
                        case 2: {
                            loc.strSize = sField.toString();
                            break;
                        }
                        case 3: {
                            loc.strDescription = sField.toString();
                        }
                    }
                    sField = new StringBuilder(200);
                    ++iFieldNo;
                    sNew.append(ch);
                    continue block11;
                }
                case '\r': {
                    myList.add(sNew.toString());
                    sNew = new StringBuilder(200);
                    iFieldNo = 0;
                    locList.add(loc);
                    loc = new Location();
                    continue block11;
                }
                case '\n': {
                    continue block11;
                }
                default: {
                    sNew.append(ch);
                    sField.append(ch);
                }
            }
        }
        return locList;
    }

    private static byte[] StringToCBuff(int iSize, String sInput) {
        byte[] bNewBuffer = new byte[iSize];
        int l = sInput.length();
        if (l > iSize) {
            l = iSize;
        }
        if (l > 0) {
            int i;
            for (i = 0; i < l; ++i) {
                bNewBuffer[i] = (byte)sInput.charAt(i);
            }
            if (i >= l) {
                bNewBuffer[l - 1] = 0;
            } else {
                bNewBuffer[i] = 0;
            }
        }
        return bNewBuffer;
    }

    private static String CBuffToString(int iSize, byte[] bInput) {
        StringBuilder sNew = new StringBuilder(iSize);
        for (int i = 0; i < iSize && bInput[i] != 0; ++i) {
            char ch = (char)bInput[i];
            sNew.append(ch);
        }
        return sNew.toString();
    }

    public static native int loadData(String var0, byte[] var1);

    public static native int findLocations(int var0, String var1, boolean var2, String var3, int var4, byte[] var5, byte[] var6);

    class LookupResponse
    extends STDResponse {
        public Location location = null;

        LookupResponse() {
        }
    }

    public class SearchResponse
    extends STDResponse {
        public ArrayList<Location> locations = new ArrayList();
    }

    public static class STDResponse {
        public int result = 0;
        public String extra = "";
        public String trace = "";
    }
}

