/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.RetailGUI;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.example.twolibs.R;
import com.example.twolibs.RetailBL.RetailItemSupport;
import com.example.twolibs.SupportBL.DataConvert;
import java.util.ArrayList;

public class RetailListAdaptor
extends ArrayAdapter<RetailItemSupport> {
    private final Activity context;
    private final ArrayList<RetailItemSupport> retailItemSupport;

    public RetailListAdaptor(Activity context, ArrayList<RetailItemSupport> pRetailItemSupport) {
        super((Context)context, R.layout.basket_entry, pRetailItemSupport);
        this.context = context;
        this.retailItemSupport = pRetailItemSupport;
    }

    private void displayRetailItem(ViewHolder holder, LayoutInflater inflater, View rowView, RetailItemSupport rs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.retailitem_entry, null));
        TextView txtDomain = (TextView)rowView.findViewById(R.id.txtDomain);
        TextView txtComment = (TextView)rowView.findViewById(R.id.txtComment);
        TextView txtDirection = (TextView)rowView.findViewById(R.id.txtDirection);
        TextView txtTime = (TextView)rowView.findViewById(R.id.txtTime);
        txtDomain.setPadding(0, 0, 0, 0);
        txtDomain.setText((CharSequence)rs.leaf.Description);
        txtComment.setPadding(80, 0, 0, 0);
        txtComment.setText((CharSequence)rs.leaf.PLU);
        txtDirection.setText((CharSequence)"");
        txtTime.setText((CharSequence)("\u00a3" + DataConvert.doubleToDisplayFormat(rs.leaf.Price)));
    }

    private void displayHierachy(ViewHolder holder, LayoutInflater inflater, View rowView, RetailItemSupport rs) {
        holder.lay_entry.addView(inflater.inflate(R.layout.basket_comment_entry, null));
        TextView txtComment = (TextView)rowView.findViewById(R.id.txtComment);
        TextView txtAmount = (TextView)rowView.findViewById(R.id.txtAmount);
        txtComment.setText((CharSequence)rs.node.Description);
        txtAmount.setText((CharSequence)"");
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View rowView = convertView;
        LayoutInflater inflater = this.context.getLayoutInflater();
        if (rowView == null) {
            rowView = inflater.inflate(R.layout.basket_entry, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.lay_entry = (LinearLayout)rowView.findViewById(R.id.lay_entry);
            rowView.setTag((Object)viewHolder);
        }
        ViewHolder holder = (ViewHolder)rowView.getTag();
        rowView.setBackgroundColor(0);
        RetailItemSupport rs = this.retailItemSupport.get(position);
        holder.lay_entry.removeAllViews();
        if (rs.entryType == 0) {
            this.displayHierachy(holder, inflater, rowView, rs);
        } else {
            this.displayRetailItem(holder, inflater, rowView, rs);
        }
        return rowView;
    }

    static class ViewHolder {
        public LinearLayout lay_entry;

        ViewHolder() {
        }
    }
}

