/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SaleBL;

import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.SaleBL.BasketComment;
import com.example.twolibs.SaleBL.BasketSupport;
import com.example.twolibs.SaleBL.Tender;
import com.example.twolibs.SessionBL.SDCIData;
import java.util.ArrayList;

public class Basket {
    private String TAG = "Basket";
    public ArrayList<BasketSupport> basketContents = new ArrayList();
    public ArrayList<BasketSupport> basketProducts = new ArrayList();
    public ArrayList<BasketSupport> basketTenders = new ArrayList();
    public ArrayList<SDCIData> sdciRecords = new ArrayList();
    public ArrayList<CCSTCoupon> ccstCoupons = new ArrayList();
    public int numberOfItems = 0;
    public int amountDue = 0;
    public int tendersPaid = 0;
    public int balanceDue = 0;
    public int buttonStatus = 1;
    public String buttonTitle = "Basket";

    public int checkStatus() {
        int items = this.basketProducts.size();
        if (items == 0) {
            this.buttonTitle = "Basket\n(empty)";
            this.buttonStatus = 1;
        } else if (items == 1) {
            this.buttonTitle = "Basket\n(1 item)";
            this.buttonStatus = 2;
        } else {
            this.buttonTitle = "Basket\n(" + items + " items)";
            this.buttonStatus = 2;
        }
        return this.buttonStatus;
    }

    public void addTicket(TNFare item, double itemValue) {
        BasketSupport bs = new BasketSupport();
        bs.itemType = BasketSupport.ItemType.FARE;
        bs.itemValue = itemValue;
        bs.ticket = item;
        this.basketProducts.add(bs);
    }

    public void addRetailItem(RetailItem item, double itemValue) {
        BasketSupport bs = new BasketSupport();
        bs.itemType = BasketSupport.ItemType.RETAIL_ITEM;
        bs.itemValue = itemValue;
        bs.retail = item;
        this.basketProducts.add(bs);
    }

    public void addTender(Tender item, double itemValue) {
        BasketSupport bs = new BasketSupport();
        bs.itemType = BasketSupport.ItemType.TENDER;
        bs.itemValue = itemValue;
        bs.tender = item;
        this.basketTenders.add(bs);
    }

    public void addComment(BasketComment item, double itemValue) {
        BasketSupport bs = new BasketSupport();
        bs.itemType = BasketSupport.ItemType.COMMENT;
        bs.itemValue = itemValue;
        bs.comment = item;
        this.basketContents.add(bs);
        this.checkStatus();
    }

    public void refreshBasket(AppContext bb) {
        this.basketContents = new ArrayList();
        this.amountDue = 0;
        this.tendersPaid = 0;
        for (BasketSupport basketSupport : this.basketProducts) {
            this.amountDue = (int)((double)this.amountDue + basketSupport.itemValue);
            this.basketContents.add(basketSupport);
        }
        BasketComment subTotalLine = new BasketComment();
        subTotalLine.CommentText = "Total ";
        subTotalLine.CommentValue = this.amountDue;
        this.addComment(subTotalLine, this.amountDue);
        subTotalLine.CommentText = this.basketTenders.size() > 0 ? "Total " : "Balance due ";
        for (BasketSupport bs : this.basketTenders) {
            this.tendersPaid = (int)((double)this.tendersPaid + bs.itemValue);
            this.basketContents.add(bs);
        }
        this.balanceDue = this.amountDue - this.tendersPaid;
        if (this.basketTenders.size() > 0) {
            BasketComment basketComment = new BasketComment();
            basketComment.CommentText = "Balance due ";
            basketComment.CommentValue = this.balanceDue;
            this.addComment(basketComment, this.amountDue);
        }
        FulfilmentManager.STDCreateCouponsResponse sTDCreateCouponsResponse = FulfilmentManager.createFulfilmentCoupons(bb, this);
        this.sdciRecords = sTDCreateCouponsResponse.sdciRecords;
        this.ccstCoupons = sTDCreateCouponsResponse.ccstCoupons;
        this.checkStatus();
    }
}

