/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SessionGUI;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.DevicesGUI.DeviceSupport;
import com.example.twolibs.DutyGUI.DutyMain;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.R;
import com.example.twolibs.SessionGUI.Accounts;

public class Logon
extends Activity {
    public static final int REQUEST_DEVICES = 1;
    public static final int REQUEST_DUTY = 2;
    public static final int REQUEST_ACCOUNTS = 3;
    String userName = "";
    String userPassword = "";
    final String base26characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    final int base26Nom = 851;
    final int base26Denom = 500;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_logon);
        this.setTitle(" Logon");
        AppContext bb = (AppContext)this.getApplicationContext();
        bb.initialise();
        String fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FARES.FIB";
        FareManager.STDResponse resp = bb.fareManager.doLoad(fibFile);
        this.doCheckComplete();
        EditText txtUserName = (EditText)this.findViewById(R.id.txtUserName);
        txtUserName.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                Logon.this.userName = s.toString();
                Logon.this.doCheckComplete();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        EditText txtPassword = (EditText)this.findViewById(R.id.txtPassword);
        txtPassword.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                Logon.this.userPassword = s.toString();
                Logon.this.doCheckComplete();
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        Button cmdLogon = (Button)this.findViewById(R.id.cmdLogon);
        cmdLogon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent nextScreen = new Intent(Logon.this.getApplicationContext(), DeviceSupport.class);
                Logon.this.startActivityForResult(nextScreen, 1);
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    int JMgetColor(int Color, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color, TH);
        }
        return this.getResources().getColor(Color);
    }

    void doCheckComplete() {
        Button cmdOptionF1 = (Button)this.findViewById(R.id.cmdLogon);
        if (this.userName.length() > 0 && this.userPassword.length() > 0) {
            cmdOptionF1.setEnabled(true);
            cmdOptionF1.setBackgroundColor(this.JMgetColor(R.color.button_background, this.getTheme()));
        } else {
            cmdOptionF1.setEnabled(false);
            cmdOptionF1.setBackgroundColor(this.JMgetColor(R.color.button_background_disabled, this.getTheme()));
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                Intent nextScreen = new Intent(this.getApplicationContext(), Accounts.class);
                nextScreen.putExtra("nextAction", "");
                this.startActivityForResult(nextScreen, 3);
                break;
            }
            case 3: {
                Intent nextScreen = new Intent(this.getApplicationContext(), DutyMain.class);
                nextScreen.putExtra("nextAction", "");
                this.startActivityForResult(nextScreen, 2);
                break;
            }
            case 2: {
                Intent nextScreen = new Intent(this.getApplicationContext(), MenuTop.class);
                nextScreen.putExtra("nextAction", "");
                this.startActivity(nextScreen);
            }
        }
    }

    void testCodes() {
        String base = "PYRZDXPLBSVIPHZTRURPPXLQZDSFMTSSWSQHQHCUFUKXIRNEYLTIJYPLPZSYVNXGDJSDLIKVIOXTAFKNHQLLTIEHPCKZTYERMHWEATNNYOSTWMIOBQUYKICCOMCELORCKHTSPLDUTHZGOKOUPSHPAFOTPYFHNDXKDVQBZAGXFPOJZJFJCIKPBCGZCTFNXUOWIFANWUNMWHPBWFOJVFUPKBSNWJ";
        byte[] encoded = this.decodeBase26(base);
        int i = 0;
        ++i;
    }

    String encodeBase26(byte[] in) {
        int overEstSize = (in.length * 851 + 500 - 1) / 500;
        byte[] base26byteArray = new byte[overEstSize];
        for (int x = 0; x < overEstSize; ++x) {
            int accumulator = 0;
            for (int i = in.length - 1; i >= 0; --i) {
                int v = accumulator * 256 + this.maskBottomByteFromInt(in[i]);
                in[i] = (byte)(v / 26);
                accumulator = v - this.maskBottomByteFromInt(in[i]) * 26;
            }
            base26byteArray[x] = (byte)accumulator;
        }
        char[] encChars = new char[overEstSize];
        for (int x = 0; x < overEstSize; ++x) {
            encChars[x] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(base26byteArray[x]);
        }
        return new String(encChars);
    }

    byte[] decodeBase26(String encodedString) {
        byte[] inputCharValues = new byte[encodedString.length()];
        for (int i = 0; i < inputCharValues.length; ++i) {
            inputCharValues[i] = (byte)"ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(encodedString.charAt(i));
        }
        int outSize = (inputCharValues.length * 500 + 851 - 1) / 851;
        byte[] outputByteArray = new byte[outSize];
        for (int p = 0; p < outSize; ++p) {
            int accumulator = 0;
            for (int i = inputCharValues.length - 1; i >= 0; --i) {
                int v = accumulator * 26 + this.maskBottomByteFromInt(inputCharValues[i]);
                inputCharValues[i] = (byte)(v / 256);
                accumulator = this.maskBottomByteFromInt(v);
            }
            outputByteArray[p] = (byte)accumulator;
        }
        return outputByteArray;
    }

    int maskBottomByteFromInt(int input) {
        int outputByte = (256 + input % 256) % 256;
        return outputByte;
    }
}

