/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.SupportBL;

import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;
import com.example.twolibs.SupportBL.MonochromeBitMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MonochromeConverter {
    private int mDataWidth;
    private byte[] mRawBitmapData;
    private byte[] mDataArray;
    private static final String TAG = "BitmapConvertor";
    private ProgressDialog mPd;
    private Context mContext;
    private int mWidth;
    private int mHeight;
    private String mStatus;
    private String mFileName;

    public MonochromeConverter(Context context) {
        this.mContext = context;
    }

    public void test() {
        try {
            String fileName = Environment.getExternalStorageDirectory() + "/com.example.twolibs/CCST_A-BW.png";
            Bitmap inputBitmap = BitmapFactory.decodeFile((String)fileName);
            System.out.println(inputBitmap.getHeight() + " " + inputBitmap.getWidth());
            String fileOut = Environment.getExternalStorageDirectory() + "/com.example.twolibs/CCST_A-BW.bmp";
            this.mWidth = inputBitmap.getWidth();
            this.mHeight = inputBitmap.getHeight();
            this.mFileName = fileOut;
            this.mDataWidth = (this.mWidth + 31) / 32 * 4 * 8;
            this.mDataArray = new byte[this.mDataWidth * this.mHeight];
            this.mRawBitmapData = new byte[this.mDataWidth * this.mHeight / 8];
            this.convertArgbToGrayscale(inputBitmap, this.mWidth, this.mHeight);
            this.createRawMonochromeData();
            this.mStatus = this.saveImage(this.mFileName, this.mWidth, this.mHeight);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    public String convertBitmap(Bitmap inputBitmap, String fileName) {
        this.mWidth = inputBitmap.getWidth();
        this.mHeight = inputBitmap.getHeight();
        this.mFileName = fileName;
        this.mDataWidth = (this.mWidth + 31) / 32 * 4 * 8;
        this.mDataArray = new byte[this.mDataWidth * this.mHeight];
        this.mRawBitmapData = new byte[this.mDataWidth * this.mHeight / 8];
        ConvertInBackground convert = new ConvertInBackground();
        convert.execute(new Bitmap[]{inputBitmap});
        return this.mStatus;
    }

    private void convertArgbToGrayscale(Bitmap bmpOriginal, int width, int height) {
        int k = 0;
        int B = 0;
        int G = 0;
        int R2 = 0;
        try {
            for (int x = 0; x < height; ++x) {
                int y = 0;
                while (y < width) {
                    int pixel = bmpOriginal.getPixel(y, x);
                    R2 = Color.red((int)pixel);
                    G = Color.green((int)pixel);
                    B = Color.blue((int)pixel);
                    G = B = (int)(0.299 * (double)R2 + 0.587 * (double)G + 0.114 * (double)B);
                    R2 = B;
                    this.mDataArray[k] = R2 < 128 ? (byte)0 : 1;
                    ++y;
                    ++k;
                }
                if (this.mDataWidth <= width) continue;
                int p = width;
                while (p < this.mDataWidth) {
                    this.mDataArray[k] = 1;
                    ++p;
                    ++k;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private void createRawMonochromeData() {
        int length = 0;
        for (int i = 0; i < this.mDataArray.length; i += 8) {
            byte first = this.mDataArray[i];
            for (int j = 0; j < 7; ++j) {
                byte second;
                first = second = (byte)(first << 1 | this.mDataArray[i + j]);
            }
            this.mRawBitmapData[length] = first;
            ++length;
        }
    }

    private String saveImage(String fileName, int width, int height) {
        FileOutputStream fileOutputStream;
        MonochromeBitMap bmpFile = new MonochromeBitMap();
        File file = new File(fileName);
        try {
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException e) {
            return "Memory Access Denied";
        }
        bmpFile.saveBitmap(fileOutputStream, this.mRawBitmapData, width, height);
        return "Success";
    }

    class ConvertInBackground
    extends AsyncTask<Bitmap, String, Void> {
        ConvertInBackground() {
        }

        protected Void doInBackground(Bitmap ... params) {
            MonochromeConverter.this.convertArgbToGrayscale(params[0], MonochromeConverter.this.mWidth, MonochromeConverter.this.mHeight);
            MonochromeConverter.this.createRawMonochromeData();
            MonochromeConverter.this.mStatus = MonochromeConverter.this.saveImage(MonochromeConverter.this.mFileName, MonochromeConverter.this.mWidth, MonochromeConverter.this.mHeight);
            return null;
        }

        protected void onPostExecute(Void result) {
            MonochromeConverter.this.mPd.dismiss();
            Toast.makeText((Context)MonochromeConverter.this.mContext, (CharSequence)"Monochrome bitmap created successfully. Please check in sdcard", (int)1).show();
        }

        protected void onPreExecute() {
            MonochromeConverter.this.mPd = ProgressDialog.show((Context)MonochromeConverter.this.mContext, (CharSequence)"Converting Image", (CharSequence)"Please Wait", (boolean)true, (boolean)false, null);
        }
    }
}

