/*
 * Decompiled with CFR 0.152.
 */
package com.example.twolibs.TimeTableGUI;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.example.twolibs.AppContext;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.R;
import com.example.twolibs.TimeTableBL.SearchResponse;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTSearchCriteria;
import com.example.twolibs.TimeTableGUI.JourneyListAdaptor;
import java.util.ArrayList;
import java.util.List;

public class TwoLibs
extends ListActivity {
    private static final int VISIBLE = 0;
    private static final int INVISIBLE = 4;
    int iCurrentMenu = -1;
    int iCurrentSelection = -1;
    Context context = null;
    List<TTJourney> list = new ArrayList<TTJourney>();
    JourneyListAdaptor adapter;
    ListView listview;

    int JMgetColor(int Color2, Resources.Theme TH) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getResources().getColor(Color2, TH);
        }
        return this.getResources().getColor(Color2);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_timetableresults);
        this.context = this;
        this.setTitle(" Journeys");
        this.listview = (ListView)this.findViewById(16908298);
        final AppContext bb = (AppContext)this.getApplicationContext();
        this.adapter = new JourneyListAdaptor((Activity)this, this.list, bb);
        this.setListAdapter((ListAdapter)this.adapter);
        this.getListView().setChoiceMode(1);
        this.listview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                for (int j = 0; j < parent.getChildCount(); ++j) {
                    parent.getChildAt(j).setBackgroundColor(0);
                }
                if (position == TwoLibs.this.iCurrentSelection) {
                    TwoLibs.this.setMenu(0);
                    bb.selJourney = null;
                    TwoLibs.this.iCurrentSelection = -1;
                } else {
                    TwoLibs.this.setMenu(1);
                    bb.selJourney = TwoLibs.this.list.get(position);
                    TwoLibs.this.iCurrentSelection = position;
                    view.setBackgroundColor(TwoLibs.this.JMgetColor(R.color.selection_background, TwoLibs.this.getTheme()));
                }
            }
        });
        this.doSearch();
        this.setMenu(0);
    }

    public void doSearch() {
        TextView tv = (TextView)this.findViewById(R.id.textView2);
        AppContext bb = (AppContext)this.getApplicationContext();
        Location objOrigin = bb.getOrigin();
        if (objOrigin.getCRS().equals("")) {
            tv.setText((CharSequence)"No origin specified");
            return;
        }
        Location objDestination = bb.getDestination();
        if (objDestination.getCRS().equals("")) {
            tv.setText((CharSequence)"No destination specified");
            return;
        }
        TTSearchCriteria TTCrit = bb.ttSearch.setupDefaults(objOrigin, objDestination, bb.getSearchDate(), bb.getSearchDirection(), bb.getChanges());
        SearchResponse resp = bb.ttSearch.doSearch(TTCrit);
        tv.setText((CharSequence)resp.extra);
        this.list = resp.objTTsearchResults.getSr_journeys();
        this.adapter.clear();
        this.adapter.addAll(this.list);
        this.adapter.notifyDataSetChanged();
    }

    private void setMenu(int iMenu) {
        if (iMenu != this.iCurrentMenu) {
            LinearLayout layFormMenu = (LinearLayout)this.findViewById(R.id.layFormMenu);
            layFormMenu.removeAllViews();
            LayoutInflater inflater = this.getLayoutInflater();
            if (iMenu == 0) {
                layFormMenu.addView(inflater.inflate(R.layout.timetableresults_menu0, null));
                Button cmdEarlier = (Button)this.findViewById(R.id.cmdEarlier);
                cmdEarlier.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)TwoLibs.this, (CharSequence)"Earlier  Clicked", (int)0).show();
                    }
                });
                Button cmdLater = (Button)this.findViewById(R.id.cmdLater);
                cmdLater.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)TwoLibs.this, (CharSequence)"Later  Clicked", (int)0).show();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("result", -1);
                        TwoLibs.this.setResult(-1, returnIntent);
                        TwoLibs.this.finish();
                    }
                });
            } else {
                layFormMenu.addView(inflater.inflate(R.layout.timetableresults_menu1, null));
                Button cmdLater = (Button)this.findViewById(R.id.cmdFares);
                cmdLater.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Toast.makeText((Context)TwoLibs.this, (CharSequence)"Fares  Clicked", (int)0).show();
                    }
                });
                Button cmdDone = (Button)this.findViewById(R.id.cmdDone);
                cmdDone.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        Intent returnIntent = new Intent();
                        returnIntent.putExtra("result", -1);
                        TwoLibs.this.setResult(-1, returnIntent);
                        TwoLibs.this.finish();
                    }
                });
            }
            this.iCurrentMenu = iMenu;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.menu_logon, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.cmdSync) {
            Toast.makeText((Context)this, (CharSequence)"sync data", (int)0).show();
            return true;
        }
        if (item.getItemId() == R.id.cmdHelp) {
            Toast.makeText((Context)this, (CharSequence)"help dialogue", (int)0).show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            this.setMenu(0);
            if (resultCode == -1) {
                // empty if block
            }
            if (resultCode == 0) {
                // empty if block
            }
        }
    }
}

