package com.ingenico.pclservice;

/**
 * Callback interface used by IPclService to send
 * synchronous notifications back to its clients.
 */
interface IPclServiceCallback {
    /**
     * Called when the Telium application wants to feed paper.
     * @param lines  Number of lines
     */
    void shouldFeedPaper(int lines);
    /**
     * Called when the Telium application wants to cut paper,
     * indicating the ticket is finished.
     */
    void shouldCutPaper();
    /**
     * Called when the Telium application wants to print text.
     * @param text  String containing the text to be printed
     * @param font  The font identifier
     * @param justification Indicates text alignment (0=centered, 1=right, 2=left)
     * @param xfactor   The factor by which the text should be scaled in the X direction.
     *                  Possible values are 1, 2 or 4 (normal, double or quadruple text width).
     * @param yfactor   The factor by which the text should be scaled in the Y direction.
     *                  Possible values are 1, 2 or 4 (normal, double or quadruple text width)
     * @param underline Indicates whether text must be underlined (1) or npt (0)
     * @param bold Indicates whether text must be bold (1) or npt (0)
     */
    void shouldPrintText(String text, byte font, byte justification, byte xfactor, byte yfactor, byte underline, byte bold);
    /**
     * Called when the Telium application wants to print image.
     * @param image  Bitmap containing the image to be printed
     * @param justification  Indicates image alignment (0=centered, 1=right, 2=left)
     */
    void shouldPrintImage(in Bitmap image, byte justification);
    /**
     * Called when the Telium application needs signature capture.
     * This function must call {@link com.ingenico.pclservice.IPclService#submitSignatureWithImage submitSignatureWithImage} or {@link com.ingenico.pclservice.IPclService#setSignatureCaptureResult setSignatureCaptureResult}.
     * @param pos_x  X position of the signature capture window
     * @param pos_y  Y position of the signature capture window
     * @param width  Width of the signature capture window
     * @param height Height of the signature capture window
     * @param timeout  Timeout (in ms) to do the signature capture
     */
    void shouldDoSignatureCapture(int pos_x, int pos_y, int width, int height, int timeout);
    /**
     * Called when the capture signature timeout has been reached.
     */
    void signatureTimeoutExceeded();
    /**
     * Called when the Telium application wants to add signature to the receipt.
     */
    void shouldAddSignature();
    /**
     * Called when the Telium application wants to start printing a receipt.
     * @param type  Indicates the receipt type (0=merchant, 1=customer)
     * @return      0 in case of success
     */
    int shouldStartReceipt(byte type);
    /**
     * Called when the Telium application wants to end printing a receipt.
     * @return      0 in case of success
     */
    int shouldEndReceipt();
}