package com.example.twolibs;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import com.example.twolibs.DevicesBL.CCSTPrinterService;
import com.example.twolibs.DevicesBL.RollPrinterService;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTask.TaskState;
import com.example.twolibs.FaresBL.FareManager;
import com.example.twolibs.FaresBL.FareSetManager;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TicketDetails;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationBL.LocationManager;
import com.example.twolibs.RetailBL.RetailItem;
import com.example.twolibs.SaleBL.Basket;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTSearch;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;



public class AppContext extends Application {
	
	private static String CLASS_NAME = "AppContext";
	
	// 
	// Standard response for a call
	public static class STDResponse  {
		public int result = 0;		// The basic response
		public String extra = "";	// A textual description of the result
		public String trace = "";   // Trace data for the call
	}
	
	// 
	// DomainState represents the status of a business domain
	// This will be reflected in the menu buttons
	// 
	public enum MenuState {
		UNKOWN,		// Domain status has not been checked
		NORMAL,		// Domain is in a normal state
		NOTIFY, 	// The Domain needs some action to be performed
		WARNING, 	// The Domain needs urgent action
		ERROR, 		// The Domain is broken
	}
	
	public static class DomainStatusResponse extends STDResponse {
		public MenuState status = MenuState.NORMAL;
		public String shortDescrition = "";
	}
	
	// Standard parameters to an intent call
    public  static final String CALL_CONTEXT = "CallContext";   // The context of the call
    															// This will be one of the enum the called intent supports 
    public  static final String CALL_CALLER = "Caller";			// The class of the caller
    public  static final String CALL_RESULT_DATA = "ResultData";// The result, the type is defined by the called intent
    
    
	public static final String MESSAGE_REQUEST = "message_request";
	public static final String MESSAGE_ID = "message_id";
	public static final String MESSAGE_RESPONSE = "message_response";
	public static final String MESSAGE_ORIGIN = "message_origin";
	public static final String RESULT = "result";

	public static final String NOTIFICATION = "com.example.twolibs"; // Callbacks to application
	public static double refreshNo = 0;
	
	public int menuStatus = 0;
	public String menuTitle = "Home";
	
	public int menuAdminStatus = 0;
	public String menuAdminTitle = "Admin";
	
	public int menuFaresStatus = 0;
	public String menuFaresTitle = "Fares";
	
	public String strHomeNLC;
	public Location Origin = new Location();
	public Location Destination = new Location();


	// Function areas
		
	public FareManager fareManager = new FareManager();
	public FareSetManager fareSetManager = new FareSetManager();


	// TODO migrate rest to Managers
	public Basket basket = new Basket();
	
	public TTSearch ttSearch = new TTSearch();

	public TTJourney selJourney = new TTJourney();
	public TNFare selFare = null;
	public RetailItem selRetail = null;
	
	public int faresSortOrder = 0;
	public int faresSortType = 0;
	public int faresClass = 0;

	
	private int SearchDirection = 0;
	private int Changes = 6;

	private Date SearchDate = new Date();
	private int NumAdults = 1;
	private int NumChildren = 0;
	private int NumAAA = 0;
	private String RailcardCode = "   ";
	private int VariableDiscount = 0;
	private boolean ShowAllFares = false;

	private String RollRequest = "";
	private boolean deviceScreenActive = false;
	
//	public boolean DemoOnly = false;
	
	private String DefaultFulfillmentMethod = "CCST";

	public void initialise(){
		TraceHandler.startTrace();

        // Register the BroadcastReceiver for Thermal roll messages
        this.registerReceiver(receiverRoll, new IntentFilter(RollPrinterService.NOTIFICATION));

		System.loadLibrary("LOCATIONS");
		System.loadLibrary("TT");
		System.loadLibrary("FARES");
		//TODO all the



		// PERMISSIONS
		int currentapiVersion = android.os.Build.VERSION.SDK_INT;
		if (currentapiVersion > android.os.Build.VERSION_CODES.LOLLIPOP){
			// Do something for  versions later than lollipop

		}


//        String locfile;
//        locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/TT.ini";       
//        com.example.twolibs.TimeTableBL.STDResponse ttresp = ttSearch.initialise(locfile);
//		Log.d(CLASS_NAME, "TT load" + ttresp.result + " " + ttresp.trace);

        String fibFile;
        //fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FIBb5_0s2v1g449.FIB";
        fibFile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/FARES.FIB";

        
    	FareManager.STDResponse respFM = fareManager.doLoad(fibFile);
    	FareSetManager.STDResponse respFSM = fareSetManager.doLoad(this);
		
 //   	LocationManager.refreshdata();
		FulfilmentManager.refreshdata();

    	
	}
	
	public void checkStatus(){
		
		// re-calculate top down status
		// Sets all the menu and button captions that could be status dependent
		
		menuStatus = 1; // OK
		menuTitle = "Home";
		
		menuFaresStatus = 0;
		menuFaresTitle = "Fares";
		    
		int thisStatus = 1;        
		String thisTitle = "";
		    
		// Tests are least important first
		
		// Basket button - not a menu
		thisStatus = basket.checkStatus();
		thisTitle = basket.buttonTitle;
		if(thisStatus > menuStatus){
			menuStatus = thisStatus;
			menuTitle = thisTitle;    	
		}
		// Fares menu - none
		// Timetable menu - none
		// Retail menu ? basket
		// Check ticket menu - none
		
		// Apps menu ? basket
		// Accounts menu - possibly
		// Devices - TODO
		   
	    // TODO add license check
	    // TODO add device check
	
		
		// Admin menu
		menuAdminStatus = 1;
		menuAdminTitle = "Admin";
		
		GenericManager.DomainStatusResponse resp = new GenericManager.DomainStatusResponse();
		resp = DutyManager.checkStatus();
		thisStatus = resp.status.ordinal();
		if(thisStatus > menuAdminStatus){
			menuAdminStatus = resp.status.ordinal(); //TODO change status to use enum
			menuAdminTitle = resp.shortDescrition;    	
		}       
		
		   
		if(menuAdminStatus > menuStatus){
		   	menuStatus = menuAdminStatus;
		   	menuTitle = menuAdminTitle;    	
		}      	    
					       

	}
	
	public String getHomeNLC() {
		return strHomeNLC;
	}

	public void setHomeNLC(String p) {
		strHomeNLC = p;
	}

	public Location getOrigin() {
		return Origin;
	}

	public void setOrigin(Location p) {
		Origin = p;
	}

	public Location getDestination() {
		return Destination;
	}

	public void setDestination(Location p) {
		Destination = p;
	}

	public Date getSearchDate() {
		return SearchDate;
	}

	public void setSearchDate(Date searchDate) {
		SearchDate = searchDate;
	}

	public int getSearchDirection() {
		return SearchDirection;
	}

	public void setSearchDirection(int searchDirection) {
		SearchDirection = searchDirection;
	}

	public int getChanges() {
		return Changes;
	}

	public void setChanges(int changes) {
		Changes = changes;
	}

	public int getNumAdults() {
		return NumAdults;
	}

	public void setNumAdults(int numAdults) {
		NumAdults = numAdults;
	}

	public int getNumChildren() {
		return NumChildren;
	}

	public void setNumChildren(int numChildren) {
		NumChildren = numChildren;
	}

	public int getNumAAA() {
		return NumAAA;
	}

	public void setNumAAA(int numAAA) {
		NumAAA = numAAA;
	}

	public String getRailcardCode() {
		return RailcardCode;
	}

	public void setRailcardCode(String railcardCode) {
		RailcardCode = railcardCode;
	}

	public int getVariableDiscount() {
		return VariableDiscount;
	}

	public void setVariableDiscount(int variableDiscount) {
		VariableDiscount = variableDiscount;
	}

	public boolean getShowAllFares() {
		return ShowAllFares;
	}

	public void setShowAllFares(boolean showAllFares) {
		ShowAllFares = showAllFares;
	}

	public String getDefaultFulfillmentMethod() {
		return DefaultFulfillmentMethod;
	}

	public void setDefaultFulfillmentMethod(String defaultFulfillmentMethod) {
		DefaultFulfillmentMethod = defaultFulfillmentMethod;
	}
	

    
	private final BroadcastReceiver receiverRoll = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				int resultCode = bundle.getInt(RollPrinterService.RESULT);
				String string = bundle.getString(RollPrinterService.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(RollPrinterService.MESSAGE_ORIGIN);
				if(origin == null) {
					string = "";
				}
				
				Log.e("AC","Message from  " + origin);
				

				RollRequest = string;
				if(origin.equals(RollPrinterService.CLASS_NAME) ){
					refreshDisplay(99,string, 0);
				}
			}
		}
	};
	
	private void refreshDisplay(int request, String message, int result) {
		final String FUNC_NAME = "refreshDisplay"; 	 
		
		Intent intent = new Intent(NOTIFICATION);
		intent.putExtra(MESSAGE_REQUEST, request);
		intent.putExtra(MESSAGE_ID, 1);
		intent.putExtra(MESSAGE_RESPONSE, message);
		intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);

		intent.putExtra(RESULT, result);
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);

		sendBroadcast(intent);
	}
	
}
