package com.example.twolibs.DataTransferBL;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.example.twolibs.DataTransferBL.DataTransferManager.FileType;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class DataDownLoadHelper {
	//
	//
	// The purpose of the DataTransferHelper class is to create the transfer objects associated with the DataDownLoad service.
	// 
	// 
	private static String CLASS_NAME = "DataTransferHelper";  	// Used for tracing

	public static HashMapX<String, DataTransferFile> doLoadDataFilesXML(HashMapX<String, DataTransferGroup> pAllDownLoads){
    	
       	// 
    	// Load a list of task types needed to interpret supplied roster data
    	// 
		// 
		final String FUNC_NAME = "doLoadDataFilesXML"; 

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		HashMapX<String, DataTransferFile> allTransferFiles = new HashMapX<String, DataTransferFile>();
		for(DataTransferGroup dataGroup : pAllDownLoads.values() ){
			
			// For each  we need to load the  config file
			
			String dataGroupConfigPath = DataTransferManager.getDownloadConfig(dataGroup.dataGroupName);
			String dataGroupPrefix = DataTransferManager.getDownloadPath(dataGroup.dataGroupName);
			
			DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocumentRaw(dataGroupConfigPath);

			
		    if(resp.result == DataTransferManager.Response.OK){    
	        
		    	try {
		    		// Get the top node
		    		Element element = resp.doc.getDocumentElement();
		    		NodeList nodeTopList = element.getElementsByTagName("DataFiles");
		    		Element owner = (Element)nodeTopList.item(0);
		    		
		    		// Get the list of s
		    		NodeList nodeList = owner.getElementsByTagName("DataFile");
		    		for (int i = 0; i < nodeList.getLength(); i++) {
		
		    			Element node = (Element)nodeList.item(i);
		    			DataTransferFile dataTransferFile = fromDataFileXML(node);
		    			dataTransferFile.fullPath = dataGroupPrefix + dataTransferFile.storageName;
		    			//dataGroup.comment = dataTransferFile.fullPath;
		     			if(dataTransferFile != null){
		     				
		     				allTransferFiles.put(dataTransferFile.shortName, dataTransferFile);
		     			}
		    		}
		
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "Loaded " + allTransferFiles.size(), 0);
		
				} catch (Exception e) {
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "XML Pasing Exception = " + e.getMessage(), 0);
				}
		    	
			} else {
				
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "Document not loaded", 0);			
			}			
		}

		

   	
    	return allTransferFiles;

    }

	
	private static DataTransferGroup fromDataGroupXML(Element pNode){
		final String FUNC_NAME = "fromDataGroupXML"; 
		//
		// Loads an instance from an XML stream
		//
		// If we get any errors return Null duty and it will be ignored
		//
		
		DataTransferGroup dataTransferGroup = new DataTransferGroup();
		
		try {
			NodeList nodes =  pNode.getElementsByTagName("title");
			dataTransferGroup.dataGroupName = nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML title Exception = " + e.getMessage(), 0);
			return null;
		}
	
		try {
			NodeList nodes =  pNode.getElementsByTagName("set");
			dataTransferGroup.currentSet = nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML set Exception = " + e.getMessage(), 0);
			return null;
		}

		try {
			NodeList nodes =  pNode.getElementsByTagName("folder");
			dataTransferGroup.dataGroupFolder = nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML folder Exception = " + e.getMessage(), 0);
			return null;
		}
		
		try {
			NodeList nodes =  pNode.getElementsByTagName("version");
			dataTransferGroup.comment = dataTransferGroup.currentSet + " v" + nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML version Exception = " + e.getMessage(), 0);
			return null;
		}
		
		try {
			NodeList nodes =  pNode.getElementsByTagName("timeStamp");
			String temp = nodes.item(0).getTextContent();
			dataTransferGroup.timeStamp = DataConvert.parseISOyyyymmddhhmmss(temp);
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML timeStamp Exception = " + e.getMessage(), 0);
			return null;
		}
		
		return dataTransferGroup;
		
	}
	
public static HashMapX<String, DataTransferGroup> doLoadDownloadDataGroups(){
    	
       	// 
    	// Load a list of task types needed to interpret supplied roster data
    	// 
		// 
		final String FUNC_NAME = "doLoadDownloadDataGroups"; 

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		HashMapX<String, DataTransferGroup> allTransfers = new HashMapX<String, DataTransferGroup>();

		
		
		DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(FileType.DATADOWNLOADSTATE);

	    if(resp.result == DataTransferManager.Response.OK){    
        
	    	try {
	    		// Get the top node
	    		Element element = resp.doc.getDocumentElement();
	    		
	    		// Get the list of dataGroups
	    		NodeList nodeList = element.getElementsByTagName("DataGroup");
	    		for (int i = 0; i < nodeList.getLength(); i++) {
	
	    			Element node = (Element)nodeList.item(i);
	    			DataTransferGroup dataTransferGroup = fromDataGroupXML(node);
	     			if(dataTransferGroup != null){
	     				
	     				dataTransferGroup.transferDirection = "Down";
	     				allTransfers.put(dataTransferGroup.dataGroupName, dataTransferGroup);
	     			}
	    		}
	
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "Loaded " + allTransfers.size(), 0);
	
			} catch (Exception e) {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "XML Pasing Exception = " + e.getMessage(), 0);
			}
	    	
		} else {
			
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "Document not loaded", 0);			
		}
   	
    	return allTransfers;

    }

	
	private static DataTransferFile fromDataFileXML(Element pNode){
		final String FUNC_NAME = "fromDataFileXML"; 
		//
		// Loads an instance from an XML stream
		//
		// If we get any errors return Null duty and it will be ignored
		//
		
		DataTransferFile dataTransferFile = new DataTransferFile();
		
		try {
			NodeList nodes =  pNode.getElementsByTagName("shortName");
			dataTransferFile.shortName = nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML shortname Exception = " + e.getMessage(), 0);
			return null;
		}
	
		try {
			NodeList nodes =  pNode.getElementsByTagName("storageName");
			dataTransferFile.storageName = nodes.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML storageName Exception = " + e.getMessage(), 0);
			return null;
		}

		
		return dataTransferFile;
		
	}
	
	public static HashMapX<String, DataTransferGroup> doLoadTest(){
    	// TODO retire this method
		HashMapX<String, DataTransferGroup> transfers = new HashMapX<String, DataTransferGroup>();   

    	DataTransferGroup transfer;
	
		transfer = new DataTransferGroup();		
		transfer.dataGroupName = "Fares data";
		transfer.transferDirection = "Down";
		transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 14, 0);
		transfer.comment = "OK";
		
		transfers.put(transfer.dataGroupName,transfer);
		
		transfer = new DataTransferGroup();
		transfer.dataGroupName = "Timetable base data";
		transfer.transferDirection = "Down";
       	transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 25, 0);
		transfer.comment = "OK";
		
		transfers.put(transfer.dataGroupName,transfer);

		transfer = new DataTransferGroup();
		transfer.dataGroupName = "Fares data";
		transfer.transferDirection = "Down";
		
		long lreq = DataConvert.getTimeInMillis(DataConvert.DATENULL);
		lreq = lreq - (5 * 60 * 1000);    	
		lreq = lreq - (5 * 60 * 1000);
    	transfer.timeStamp = DataConvert.setTimeInMillis(lreq);	
		transfer.comment = "Timetable snapshot";
		
		transfers.put(transfer.dataGroupName,transfer);

		transfer = new DataTransferGroup();
		transfer.dataGroupName = "User profiles";
		transfer.transferDirection = "Down";
        transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 10, 0);	
		transfer.comment = "OK";
		
		transfers.put(transfer.dataGroupName,transfer);
		
		transfer = new DataTransferGroup();
		transfer.dataGroupName = "Sales data";
		transfer.transferDirection = "Up";
		
		 lreq = DataConvert.getTimeInMillis(DataConvert.DATENULL);
		lreq = lreq - (2 * 60 * 1000);
		lreq = lreq - (2 *  1000);
    	transfer.timeStamp = DataConvert.setTimeInMillis(lreq);
		transfer.comment = "OK - £10.05 2 coupons 3 requests";

		transfers.put(transfer.dataGroupName,transfer);

		transfer = new DataTransferGroup();
		transfer.dataGroupName = "Retail items";
		transfer.transferDirection = "Down";
       	transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 5, 0);
		transfer.comment = "OK";
		
		transfers.put(transfer.dataGroupName,transfer);

		transfer = new DataTransferGroup();
		transfer.dataGroupName = "Diagnostics";
		transfer.transferDirection = "Up";
       	transfer.timeStamp = DataConvert.setTime(DataConvert.DATENULL, 3, 1, 0);		
		transfer.comment = "OK - 0 requests";
		
		transfers.put(transfer.dataGroupName,transfer);

		return transfers;
	}
}
