package com.example.twolibs.DataTransferBL;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.os.Environment;

public class DataTransferManager extends GenericManager{
	private static String CLASS_NAME = "DataTransferManager";  // Used for tracing
	
	// The DataTransferManager provides a mechanism for bind files to physical environment
	
	// Refresh flag - if set will force a refresh when required.
	private static boolean refreshRequired = true;
	

    // The list of completed transfer dataGroups that are being displayed
	public static HashMapX<String, DataTransferGroup> allDownLoadDataGroups = new HashMapX<String, DataTransferGroup>();

	// A table of all the files in the system
	public static HashMapX<String, DataTransferFile> allFiles = new HashMapX<String, DataTransferFile>();
	
	
	// Filter on download events
	public static String DATADOWNLOADSERVICE = "DATADOWNLOADSERVICE";
	public static String DATAGROUPUPDATED = "DATAGROUPUPDATED";
	
	// TODO integrate DataUpload mechanisms.

	public enum FileType {
		CCSTFORMATS,					
		DUTIES,					
		DUTYTASKTYPES,
		DATADOWNLOADSTATE,
		TRACELOG
	}
		
	
	public static DomainStatusResponse checkStatus(){
		final String FUNC_NAME = "checkStatus"; 	  
		//
		// Overrides GenericManager
    	// 
    	// Find out whether there is a due duty
    	// If so we need to flag action is required and setup a title
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		DomainStatusResponse resp = new DomainStatusResponse();

		resp.status = MenuState.NORMAL;
		resp.shortDescrition = "Sync\nData";

		// TODO error if nothing read
		for(DataTransferGroup dataGroup : allDownLoadDataGroups.values() ){
			// TODO find and set the highest status
			if(dataGroup.transferStatus > resp.status.ordinal()){
				resp.status = MenuState.NORMAL;
				resp.shortDescrition = "Duty";
			}
		}
    	
   
       return resp;
	}	
	public static void handleEvent(String pSource, String pEventType, String pData){
		final String FUNC_NAME = "handleEvent"; 	  
		//
		// Overrides GenericManager
    	// 
		//
		// Method is called whenever a application wide event occurs
		// 
		// Whatever the DataGroup we need to update the file paths
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		if(pSource.equals(DATADOWNLOADSERVICE) && pSource.equals(DATAGROUPUPDATED) ){
			// handle the updates
			refreshRequired = true;
			
			// Immediate update as all the filenames need to be checked
			
			refreshdata();
		}
	}

	
	public static void refreshdata(){
		final String FUNC_NAME = "refreshdata"; 	   	
    	// 
    	// Resets all the data associated with the DataTransfer subsystem
    	// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		if(refreshRequired){
			
			// Load all the download dataGroups
			getProgramPath();
			
			allDownLoadDataGroups = DataDownLoadHelper.doLoadTest(); //Demo
			//allDownLoadDataGroups = DataDownLoadHelper.doLoadDownloadDataGroups(); 
			allFiles = DataDownLoadHelper.doLoadDataFilesXML(allDownLoadDataGroups); 
		
			
			refreshRequired = false;
			
		} 
	
		return ;
	}
	
	public static class STDDocumentResponse  extends STDResponse {
		public Document doc = null;
	}

	public static class STDContentResponse  extends STDResponse {
		public byte content[] = new byte[0];
	}

	public static String getProgramPath(){
		
	    String root = Environment.getExternalStorageDirectory() + "/com.example.twolibs/";
	    File folder = new File(root);
	    // Check that root does actually exist
	    if (!folder.exists()) {
	        folder.mkdir();
	    }	    
	    
	    return root;		
	}
	
	public static String getRootPath(){
		
	    String root = Environment.getExternalStorageDirectory() + "/DataSync/";
	    File folder = new File(root);
	    // Check that root does actually exist
	    if (!folder.exists()) {
	        folder.mkdir();
	    }	    
	    
	    return root;		
	}

	
	public static String getFileName(FileType pFileType){
		//TODO do this for real...
		
		String root = getRootPath();

	    switch(pFileType){
	    case DATADOWNLOADSTATE:
			return(root + "DownloadConfig.xml");
	    	
		case CCSTFORMATS:
			return(Environment.getExternalStorageDirectory() + "/com.example.twolibs/" +  "CCSTDefinition.txt");
		case DUTIES:
			return(Environment.getExternalStorageDirectory() + "/com.example.twolibs/" + "duty.xml");
		case DUTYTASKTYPES:
			return(Environment.getExternalStorageDirectory() + "/com.example.twolibs/" + "dutytasktypes.xml");
		case TRACELOG:
			return(Environment.getExternalStorageDirectory() + "/com.example.twolibs/" + "trace.txt");
		}
		
		return("");
		
	}

	public static String getDownloadPath(String pDataGroupName){

		DataTransferGroup dataTransferGroup = allDownLoadDataGroups.get(pDataGroupName);
		if (dataTransferGroup == null){
			return "";
		}
		
		String root = getRootPath();
		String dataGroupPath = root + dataTransferGroup.dataGroupFolder + "/" + dataTransferGroup.currentSet + "/"; 
		 
		return(dataGroupPath);
		
	}

	public static String getDownloadConfig(String pDataGroupName){

		
		
		String root = getDownloadPath(pDataGroupName);
		String dataGroupPath = root + "DataGroupConfig.xml"; 
		 
		return(dataGroupPath);
		
	}
	
	public static STDDocumentResponse getDocument(FileType pFileType){
		final String FUNC_NAME = "getDocument"; 

		//
		// Return the XML document for the requested file
		// 
		STDDocumentResponse result = new STDDocumentResponse();
		
	    String filename = DataTransferManager.getFileName(pFileType);
	    File file = new File(filename);
    
		try {
	
	 		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
	
			result.doc = db.parse(file);
			result.doc.getDocumentElement().normalize();
	
		} catch (Exception e) {
			result.result = Response.Error;
			result.trace = "Exception = " + pFileType.name() + " " + filename + e;
			result.extra = "Document error ";
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, result.trace, 0);
			return result;
		}
		
		result.result = Response.OK;
		result.trace = "Document loaded" + result.doc.getLocalName();
		result.extra = "OK";
	    return result;
	}

	public static STDDocumentResponse getDocumentRaw(String pFilename){
		final String FUNC_NAME = "getDocumentRaw"; 

		//
		// Return the XML document for the requested file
		// 
		STDDocumentResponse result = new STDDocumentResponse();
		
	    File file = new File(pFilename);
    
		try {
	
	 		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
	
			result.doc = db.parse(file);
			result.doc.getDocumentElement().normalize();
	
		} catch (Exception e) {
			result.result = Response.Error;
			result.trace = "Exception = " + pFilename + e;
			result.extra = "Document error ";
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, result.trace, 0);
			return result;
		}
		
		result.result = Response.OK;
		result.trace = "Document loaded" + result.doc.getLocalName();
		result.extra = "OK";
	    return result;
	}

	public static STDContentResponse getContent(FileType pFileType){
		final String FUNC_NAME = "getContent"; 

		//
		// Return the byte content for the requested file
		// 

		STDContentResponse result = new STDContentResponse();
		
	    String filename = DataTransferManager.getFileName(pFileType);
	    File file = new File(filename);
	    if(!file.exists()) { 
			result.result = Response.Error;
			result.trace = "File not found = " + pFileType.name() + " " + filename;
			result.extra = "File missing ";
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, result.trace, 0);
			return result;
	    }
    
	    // Read file contents
	    byte fileContent[] = new byte[(int)file.length()];  
	    try{
			FileInputStream fin = new FileInputStream(filename);
	        fin.read(fileContent);  
	        fin.close();
	        
	    } catch (Exception e){
			result.result = Response.Error;
			result.trace = "Exception = " + pFileType.name() + " " + filename + e;
			result.extra = "File error ";
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, result.trace, 0);
			return result;
	    }			

		result.result = Response.OK;
		result.trace = "Read " + fileContent.length;
		result.extra = "OK";
		result.content = fileContent;
	    return result;
	}
	
	public static ArrayList<DataTransferGroup> getTransfers(){
		final String FUNC_NAME = "getTransfers"; 
	   	
    	// 
    	// Return an arraylist containing the dataGroup transfers 
    	// for display
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		ArrayList<DataTransferGroup> dataGroupList = new ArrayList<DataTransferGroup>();
		
		for(DataTransferGroup domain : allDownLoadDataGroups.values() ){
			dataGroupList.add(domain);
		}
		
		return dataGroupList;
		
	}
}
