package com.example.twolibs.DataTransferGUI;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;

import java.util.ArrayList;

public class DataTransferListAdaptor extends ArrayAdapter<DataTransferGroup> {
	private final Activity context;
	private final ArrayList<DataTransferGroup> dataTransferList;
	
	
	static class ViewHolder {
		public LinearLayout lay_entry;
		public TextView txtDomain;
		public TextView txtComment;
		public TextView txtDirection;
		public TextView txtTime;
	}
		
	public DataTransferListAdaptor(Activity context,ArrayList<DataTransferGroup> dataTransferList) {
		super(context, R.layout.datatransfer_entry, dataTransferList);
		this.context = context;
		this.dataTransferList = dataTransferList;
	}
		
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View rowView = convertView;
	    LayoutInflater inflater = context.getLayoutInflater();

	    // reuse views
		if (rowView == null) {
		      rowView = inflater.inflate(R.layout.datatransfer_entry, null);
		      // configure view holder
		      ViewHolder viewHolder = new ViewHolder();

		      viewHolder.lay_entry = (LinearLayout) rowView.findViewById(R.id.lay_entry);
		      viewHolder.txtDomain = (TextView) rowView.findViewById(R.id.txtDomain);
		      viewHolder.txtComment = (TextView) rowView.findViewById(R.id.txtComment);
		      viewHolder.txtDirection = (TextView) rowView.findViewById(R.id.txtDirection);
		      viewHolder.txtTime = (TextView) rowView.findViewById(R.id.txtTime);

		      rowView.setTag(viewHolder);
		}
		
		// fill data
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	    DataTransferGroup t = dataTransferList.get(position);
	    
		holder.txtDomain.setText(t.dataGroupName);
		holder.txtComment.setText(t.comment);
		holder.txtDirection.setText(t.transferDirection);
		holder.txtTime.setText(DataConvert.displayTextTime(t.timeStamp));

	    
		return rowView;
	}
	
}
