
package com.example.twolibs.DataTransferGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.DataTransferBL.DataTransferGroup;
import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.view.View;
import android.view.View.OnClickListener;


public class DataTransferMain extends ListActivity {
	//
	// DataTransferMain class is a GUI class to display of data transfers
	// both from the DataDownLoad service and the DataUpLoad service
	// It displays the transfer details at the DataGroup level
	//	
	private static String CLASS_NAME = "DataTransferMain";    // Used for tracing
	
	ArrayList<DataTransferGroup> list = new ArrayList<DataTransferGroup>(); // The list of completed transfer tasks that are being displayed
	int iCurrentSelection = -1;							  // The current selected task, -1 is none.
	
	DataTransferListAdaptor adapter;						  // Adapter to handle the list
	ListView listview;									  // The view for the list

	// The CallContext is part of the data when calling other intents 
	// It enables the context to be determined when the call returns in onActivityResult
	// It should list all the called intents
	public enum CallContext {
		DISPLAY;		
	}
	
	// TODO receive DataDownLoad events
	// TODO receive DataUpLoad events
	
    @Override
    public void onCreate(Bundle pSavedInstanceState)
    {
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(pSavedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_datatransfer_main);
        
        // Set the title of this screen
		setTitle(" Data sync");


        // Ensure that the associated manager is initialised
		DataTransferManager.refreshdata();
        	        	        
		// Setup the adapter
        listview = (ListView) findViewById(android.R.id.list);
        adapter = new DataTransferListAdaptor(this,list);
        setListAdapter(adapter);

		LinearLayout frmCommsState = (LinearLayout) findViewById(R.id.frmCommsState); 
		frmCommsState.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "frmCommsState", 0);
		
				// Checking communication state
				doCheckComms();
			}  
			
		
		});
			
			
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
				final String FUNC_NAME = "onItemClick"; 	
				
				//
				// This routine handles the emphasis of the selected item
				// and initiates any business activity
				//
				
				// Note: No specific actions for this list has been identified
				
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "listview " + position, 0);
           	
                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	View rowView = (View) parent.getChildAt(j);
                	rowView.setBackgroundColor(Color.TRANSPARENT);
                 }

                // Toggle the selection
                if (position == iCurrentSelection){
                    // De-select item
                    iCurrentSelection = -1;
                    
            	} else {
            		// Select item
                     iCurrentSelection = position;
           		
                }
           	
 
            }

          });

        // SyncData - force resync request on downloadservice and uploadservice
		Button cmdSyncData = (Button) findViewById(R.id.cmdSyncData); 
		cmdSyncData.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdSyncData", 0);
				
				// TODO communicate with services
			}  
			
		
		});
		
	    // Done - return to menu
		Button cmdDone = (Button) findViewById(R.id.cmdDone); 
		cmdDone.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdDone", 0);
				
				 // Return - no specific return data
              	 Intent returnIntent = new Intent();
               	 setResult(RESULT_OK,returnIntent);
               	 finish();           	
			}  
			
		
		});
		
        doCheckComplete();

    }
 
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {

	    doCheckComplete();

	}
	
    
    void doCheckComplete(){
		final String FUNC_NAME = "doCheckComplete"; 			
		//
		// This routine handles the return from called intents
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);
		
       	// TODO set status field
		
    	ArrayList<DataTransferGroup> transfers = DataTransferManager.getTransfers();
		
        adapter.clear();
        adapter.addAll(transfers);
        adapter.notifyDataSetChanged();
        
    }

    void doCheckComms(){
    	
    	//TODO do this for real...
 

    }

    @Override
    public Intent getParentActivityIntent() {

    	Intent newIntent = null;
    	// ToDo 
    	newIntent = new Intent(getApplicationContext(), MenuTop.class); 
          
        return newIntent;
          
     }
    


}