package com.example.twolibs.DevicesBL;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.Activity;
import android.app.IntentService;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;

public class CCSTPrinterService  extends IntentService {
	public static String CLASS_NAME = "CCSTPrinterService";  // Used for tracing and message origin
	
	//
	// This class supports the all the communication with the CCST printer
	// 
	// It handles all the bluetooth setup 
	// It handles messages to the print and their responses
	// It maintains the status of the printer
	

	public CCSTPrinterService() {
		super("CCSTPrinterService");
	}
	
//	public static final String TAG = "CCSTPrinter";

	private int result = Activity.RESULT_CANCELED;
	private Date lastMsgTime = null;
		
	public static final String MESSAGE_REQUEST = "message_request";
	public static final String MESSAGE_ID = "message_id";
	public static final String MESSAGE_RESPONSE = "message_response";
	public static final String MESSAGE_ORIGIN = "message_origin";

	public static final String MAC_ADDRESS = "mac_address";
	public static final String MESSAGE_CONTENT = "message_content";
	
	public static final String RESULT = "result";
	
	public static final String NOTIFICATION = "com.example.twolibs";
	
	private BluetoothAdapter bluetoothAdapter;

	public static final int REQUEST_NONE = -1;
	public static final int REQUEST_CONNECT = 20;
	public static final int REQUEST_STATUS = 21;
	public static final int REQUEST_PRINT = 22;
	public static final int REQUEST_CLOSE = 23;

	public static final int REQUEST_FAILED = -2;

	//TODO add periodic (alarm) status check
	//TODO recovery
	//TODO proper state model
	
	public enum PrinterState {
		NOBLUETOOTH,
		BLUETOOTH,
		NOTREADY,
		READY,
		QUERY,
		PRINTING
	}
	
	static PrinterState iCCST = PrinterState.NOBLUETOOTH;
	static BluetoothDevice blueToothDevice = null ;
	static BluetoothSocket blueToothSocket = null;
	static SendReceiveBytes sendReceiveBT = null ;
	static long lastMessage = 0;
	
	private static final int ENABLE_BT_REQUEST_CODE = 1;	
	// Message types used by the bluetooth message Handler
	public static final int MESSAGE_WRITE = 1;
	public static final int MESSAGE_READ = 2;
	static String readMessage="";
	static String printerResponse="";
	
	
	//static String macAddress="00:80:98:E6:C0:0A"; // old
	static String macAddress="00:12:6F:00:94:80"; // new
	
	static boolean printerConnected = false;
	
	int activeListener = 0;
	static int msgNo = 0;	
	
	// will be called asynchronously by Android
	@Override
	protected void onHandleIntent(Intent intent) {
		final String FUNC_NAME = "onHandleIntent"; 	   	
		
		msgNo = msgNo + 1;
		
		// Get the adaptor
		
				
		// successfully finished
		int request = intent.getIntExtra(MESSAGE_REQUEST, -1);
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Service called " + request + "(" +msgNo + ")", 0);
		
		switch (request) {
		case REQUEST_CONNECT: 
			String requestedMac = intent.getStringExtra(MAC_ADDRESS);
			
			bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
			
			// Connect request
			if (bluetoothAdapter == null) {
				publishResults(request,"Bluetooth not supported", result);
				break;
			}
			if (!bluetoothAdapter.isEnabled()) {
				publishResults(request,"Bluetooth switched off", result);
			}
			if (!Objects.equals(requestedMac, macAddress)){
				if(printerConnected){
					publishResults(request,"Closing down", result);
					sendReceiveBT.cancel();
				}
			}
			if (requestedMac.length()==0){
				// publishResults("No MAC address supplied", result);
			} else {
				macAddress = requestedMac;
			}
			ConnectDevice(request,macAddress, true);
			break;
		
		case REQUEST_STATUS: 
			// This code allows for reseting if no response received after n seconds
			long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
			if((dteMessage -lastMessage ) > 2*1000){
				// TODO what about other states
//				if(iCCST == PrinterState.QUERY){
//					iCCST = PrinterState.READY;
//					printerConnected = false;
//				}
			}
			

			if(!printerConnected){
				ConnectDevice(request,macAddress,false);
			} 

			QueryPrinter(request);
			
			break;
		
		case REQUEST_PRINT: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			String msgContent = intent.getStringExtra(MESSAGE_CONTENT);
			Log.d("TAG ", "Print request");
			
			if(!printerConnected){
				ConnectDevice(request,macAddress,false);
			} 
			
			SendPrinter(request, msgContent);
			//publishResults("Not yet supported", result);
			break;
			
		case REQUEST_CLOSE: 
			//WE hope this works....
			result = Activity.RESULT_OK;
			publishResults(request,"Closing down", result);
			if(sendReceiveBT != null){
				sendReceiveBT.cancel();
			}
			stopSelf();
			break;

		case REQUEST_FAILED: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			String msgError = intent.getStringExtra(MESSAGE_CONTENT);
			Log.d("TAG ", "Print request");
			publishResults(request, msgError, result);
			break;

			
		default: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			publishResults(request,"No request", result);
			break;
		
		}

	}
	
	private void publishResults(int request, String message, int result) {
		final String FUNC_NAME = "publishResults"; 	   	
		
		Intent intent = new Intent(NOTIFICATION);
		intent.putExtra(MESSAGE_REQUEST, request);
		intent.putExtra(MESSAGE_ID, msgNo);
		intent.putExtra(MESSAGE_RESPONSE, message);
		intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);
		
		intent.putExtra(RESULT, result);
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);

		sendBroadcast(intent);
	}





    public void ConnectDevice(int request,  String strMAC, boolean pQueryrequest) {
		final String FUNC_NAME = "ConnectDevice"; 
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request, 0);

    	if(printerConnected){
    		iCCST = PrinterState.READY;
    		QueryPrinter(request);
    		return;
    	}
    	
    	bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    	blueToothDevice = bluetoothAdapter.getRemoteDevice(strMAC);

       for (Integer port = 1; port <= 1; port++) {
			simpleComm(request, Integer.valueOf(port),pQueryrequest);
		}

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "", 0);
    }
	protected void simpleComm(int request,Integer port,boolean pQueryrequest) {
		final String FUNC_NAME = "simpleComm"; 

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request + " port " + port, 0);

		// The documents tell us to cancel the discovery process.
		bluetoothAdapter.cancelDiscovery();

		
		try {
			
				
//			if(blueToothSocket != null){
//				Log.e(TAG, "Reset connection " + activeListener );
//				sendReceiveBT.cancel();
//
//				Log.e(TAG, "FORCE close " + activeListener );
//				QueryPrinter();
//				Log.e(TAG, "FORCE done " + activeListener );
//				activeListener = activeListener + 1;
//			}
			
			Method m = blueToothDevice.getClass().getMethod(
					"createInsecureRfcommSocket", new Class[] { int.class });
			blueToothSocket = (BluetoothSocket) m.invoke(blueToothDevice, port);
			if(blueToothSocket == null){
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT, "Blue tooth socket null", 0);
			}
			
			// debug check to ensure socket was set.
			assert (blueToothSocket != null) : "Socket is Null";

			// attempt to connect to device
			

			try {
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT, "Connecting to socket: attempt " + activeListener, 0);

				// First attempt (if set before this will also generate an IO exception
				blueToothSocket.connect();	
				
			} catch (IOException e) {
				
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT, "Connection failed: attempt " + activeListener, 0);
				
			}
			
			if (blueToothSocket != null){
				iCCST = PrinterState.READY;
				
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.ENTRY, " Start send/receive thread: " + activeListener, 0);

				sendReceiveBT = new SendReceiveBytes(blueToothSocket, activeListener);
				new Thread(sendReceiveBT).start();
				try {
					// Sleep to give time for the comms to settle
					Thread.sleep(500);
				} catch (InterruptedException e) {
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.ENTRY, "Interrupted sleep: " + activeListener, 0);

				} 
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.ENTRY, "Slept - ready to listen on: " + activeListener, 0);

				if(pQueryrequest){
					
					QueryPrinter(request);
				}
			} 

			// IOExcecption is thrown if connect fails.

		} catch (NoSuchMethodException ex) {
			Log.e(this.toString(), "NoSuchMethodException " + ex.getMessage());
		} catch (IllegalAccessException ex) {
			Log.e(this.toString(), "IllegalAccessException " + ex.getMessage());
		} catch (InvocationTargetException ex) {
			Log.e(this.toString(), "InvocationTargetException " + ex.getMessage());
		}

	}

	public void QueryPrinter(int request){
		final String FUNC_NAME = "QueryPrinter"; 
		
		
		// Setup query message
		byte querym[] = new byte[5];
		querym[0] = '?';
		querym[1] = '?';
		querym[2] = '?';
		querym[3] = '?';
		querym[4] = '?';
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request + " State: " + iCCST, 0);

		long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
		
		if (iCCST == PrinterState.READY){
			iCCST = PrinterState.QUERY;
			printerResponse = "";
			lastMessage = dteMessage;
			

			sendReceiveBT.write(querym);
			
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "sent query message " + querym, 0);

		} else {
			result = Activity.RESULT_CANCELED;
			publishResults(request,"Printer not ready " + iCCST, result);
			
		}
		
	}
	public void SendPrinter(int request, String msg){
		final String FUNC_NAME = "SendPrinter"; 

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request + " state " + iCCST, 0);

		// Wrap message with control characters
		byte[] bSOH = {1};
		String sSOH =new String(bSOH);
		byte[] bEOT = {4};
		String sEOT =new String(bEOT);

		// TODO hopper selection 
		String sWrappedMsg = sSOH + "00" + msg + sEOT;

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request >" + sWrappedMsg + "<", 0);

		byte querym[] = sWrappedMsg.getBytes();
		
		//TODO frig to get £ to print properly
		for(int i=0;i<querym.length;i++){
			if((i > 0) && (querym[i] == '#')){
				querym[i] = ' '; //-93;
			}
		}

		long dteMessage =  DataConvert.getTimeInMillis(DataConvert.DATENULL);
		if (iCCST == PrinterState.READY){
			iCCST = PrinterState.PRINTING;
			printerResponse = "";
			lastMessage = dteMessage;
			
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "Sending", 0);

			sendReceiveBT.write(querym);
		} else {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT , "NOT SENT - printer not in correct state", 0);

		}
		
	}
	public void ReadPrinter(String msg){
		final String FUNC_NAME = "ReadPrinter"; 
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY , "Read:" + msg, 0);

		//TODO decode status
		printerResponse = printerResponse + msg;
		byte[] bSTX = {2};
		String sSTX =new String(bSTX);
		byte[] bETX = {3};
		String sETX =new String(bETX);
		
		if(printerResponse.contains(sETX)){
			int request;
			if(iCCST == PrinterState.PRINTING){
				request = REQUEST_PRINT;
			} else {
				request = REQUEST_STATUS;	
			}
			iCCST = PrinterState.READY;
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY , "Message:" + printerResponse, 0);
			
			//Return the result
			result = Activity.RESULT_OK;
			publishResults(request,printerResponse, result);
		}

	}
	private final Handler mHandler = new Handler() {
		@Override 
		public void handleMessage(Message msg) {
			final String FUNC_NAME = "handleMessage"; 
			
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY , "Type:" + msg.what, 0);

			switch (msg.what) { 
			case MESSAGE_WRITE: 
				//Do something when writing 
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.ENTRY , "Write:" + msg.arg1, 0);

				break; 
			case MESSAGE_READ: 
				//Get the bytes from the msg.obj 
				byte[] readBuf = (byte[]) msg.obj; 
				// construct a string from the valid bytes in the buffer 
				readMessage = new String(readBuf, 0, msg.arg1); 
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.ENTRY , "Read:" + readMessage, 0);

				ReadPrinter(readMessage);

				break; 
			} 
		}
	};

	private class SendReceiveBytes implements Runnable {
		private BluetoothSocket btSocket; 
		private InputStream btInputStream = null; 
		private OutputStream btOutputStream = null; 
		int thisListener = -1;

		public SendReceiveBytes(BluetoothSocket socket, int intListener) {
			final String FUNC_NAME = "SendReceiveBytes"; 

			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY , "Channel:" + intListener, 0);
			
			btSocket = socket; 
			thisListener = intListener;
			try { 
				btInputStream = btSocket.getInputStream(); 
				btOutputStream = btSocket.getOutputStream(); 
			}  catch (IOException streamError) {
				
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT , "Error when getting input or output Stream:" + streamError.getMessage(), 0);
			} 
		}
		public void run() { 
			final String FUNC_NAME = "run"; 
			
			byte[] buffer = new byte[1024]; 
			printerConnected = true;
			
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY , "Active:" + activeListener + " This:" + thisListener, 0);
			
			// buffer store for the stream int bytes; 
			// bytes returned from read() 
			// Keep listening to the InputStream until an exception occurs 
			while (activeListener == thisListener) {
				
				try { 
					// Read from the InputStream 
					int bytes = btInputStream.read(buffer); 
					// Send the obtained bytes to the UI activity
					byte[] readMsg = Arrays.copyOf(buffer, bytes);
					mHandler.obtainMessage(MESSAGE_READ, bytes, -1, readMsg) .sendToTarget();
				}  catch (IOException e) { 
					
					TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
							Category.ERROREXIT ,e.getMessage(), 0);

					break; 
				} 
			} 
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.EXIT , "Active:" + activeListener + " This:" + thisListener, 0);

		} 
		/* Call this from the main activity to send data to the remote device */ 
		public void write(byte[] bytes) {
			final String FUNC_NAME = "write";
			
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY ,"Length " + bytes.length, 0);

			try { 
				btOutputStream.write(bytes); 
			}  catch (IOException e) {
				
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ERROREXIT ,e.getMessage(), 0);
			} 
		} 
		/* Call this from the main activity to shutdown the connection */ 
		public void cancel() {
			final String FUNC_NAME = "cancel"; 
			
		      if (btInputStream != null) {
		    	  
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.ENTRY , "Close inputstream", 0);
		    	  
	                try {btInputStream.close();} catch (Exception e) {}
	                btInputStream = null;
	        }

	        if (btOutputStream != null) {
		    	  
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.ENTRY , "Close outputstream", 0);
		    	  
	                try {btOutputStream.close();} catch (Exception e) {}
	                btOutputStream = null;
	        }

	        if (btSocket != null) {
		    	  
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.ENTRY , "Close socket", 0);
		    	  
	                try {btSocket.close();} catch (Exception e) {}
	                btSocket = null;
	        }
	        
	        try {
	        	// Give some time for every thing to finish
	        	
	        	Thread.sleep(1000);   //TODO improve
	        } catch (InterruptedException e){
	        	
	        	// Woken up
	        }
	        iCCST = PrinterState.NOTREADY;
			printerConnected = false;
	    	  
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.EXIT , "End of closedown of:" + activeListener, 0);
	    	  

		}
	}
	

   
} 