package com.example.twolibs.DevicesBL;


import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;

import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.MonochromeConverter;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;
import com.fujitsu.fcl.libFTP2076210R0_Android.FTPAndroidLib;

import android.app.Activity;
import android.app.IntentService;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
//import android.util.Log;

public class RollPrinterService  extends IntentService {
	public static String CLASS_NAME = "CCSTPrinterService";  // Used for tracing and message origin

	public RollPrinterService() {
		super("RollPrinterService");
	}
	

	private int result = Activity.RESULT_CANCELED;
	private Date lastMsgTime = null;
		
	public static final String MESSAGE_REQUEST = "message_request";
	public static final String MESSAGE_ID = "message_id";
	public static final String MESSAGE_RESPONSE = "message_response";
	public static final String MESSAGE_ORIGIN = "message_origin";

	public static final String MAC_ADDRESS = "mac_address";
	public static final String MESSAGE_CONTENT = "message_content";
	
	public static final String RESULT = "result";
	
	public static final String NOTIFICATION = "com.example.twolibs";
	

	public static final int REQUEST_NONE = -1;
	public static final int REQUEST_CONNECT = 20;
	public static final int REQUEST_STATUS = 21;
	public static final int REQUEST_PRINT = 22;
	public static final int REQUEST_CLOSE = 23;

	public static final int REQUEST_FAILED = -2;

	private static FTPAndroidLib ftpAndroidLib;

    
	
	//TODO add periodic (alarm) status check
	//TODO recovery
	//TODO proper state model
	
	public enum PrinterState {
		NOBLUETOOTH,
		BLUETOOTH,
		NOTREADY,
		READY,
		QUERY,
		PRINTING
	}
	static PrinterState iCCST = PrinterState.NOBLUETOOTH;

	static long lastMessage = 0;
	
	static String readMessage="";
	static String printerResponse="";
	static String macAddress="00:0B:5D:37:BB:07";
	
	static boolean printerConnected = false;
	
	int activeListener = 1;
	static int msgNo = 0;	
	
	// will be called asynchronously by Android
	@Override
	protected void onHandleIntent(Intent intent) {
		final String FUNC_NAME = "onHandleIntent"; 	   	
		
		msgNo = msgNo + 1;
		
		// call getInstance method to get FTPAndroidLib class instance.
		ftpAndroidLib = FTPAndroidLib.getInstance();
				
		// successfully finished
		int request = intent.getIntExtra(MESSAGE_REQUEST, -1);
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Service called " + request + "(" +msgNo + ")", 0);
		
		switch (request) {
		case REQUEST_CONNECT: 
			String requestedMac = intent.getStringExtra(MAC_ADDRESS);
			// Connect request

			openPrinter(request,macAddress);
			break;
		
		case REQUEST_STATUS: 
			// This code allows for reseting if no response received after n seconds
			long dteMessage = DataConvert.getTimeInMillis(DataConvert.DATENULL);
			if((dteMessage -lastMessage ) > 2*1000){
				// TODO what about other states
				if(iCCST == PrinterState.QUERY){
					iCCST = PrinterState.READY;
					printerConnected = false;
				}
			}
			

			if(!printerConnected){
				openPrinter(request,macAddress);
			}
			
			getPrinterStatus(request);

			break;
		
		case REQUEST_PRINT: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			String msgContent = intent.getStringExtra(MESSAGE_CONTENT);
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "Print request printer:" + printerConnected, 0);
			
			if(!printerConnected){
				openPrinter(request,macAddress);
			}
			printCharacterString(request,xlate(msgContent));
			//startPage();
			//printBitimage();
			//testLoadImage();
			ftpAndroidLib.linefeedPaper(6);
			//publishResults("Not yet supported", result);
			break;
			
		case REQUEST_CLOSE: 
			//WE hope this works....
			result = Activity.RESULT_OK;
			publishResults(request,"Closing down", result);
			closePrinter(result);
			stopSelf();
			break;

		case REQUEST_FAILED: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			String msgError = intent.getStringExtra(MESSAGE_CONTENT);
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "Not proper request" , 0);

			publishResults(request, msgError, result);
			break;

			
		default: 
			// No proper request
			result = Activity.RESULT_CANCELED;
			publishResults(request,"No request", result);
			break;
		
		}

	}
	private String xlate(String asciiString){
	
/*		String test = "";
		String xlatePound = "";
		byte byteVal[] = {64,64};
		byteVal[0] += 64;
		int i;
		for(i=0;i<16; i++){
			
			test = test + String.valueOf(i);
			byteVal[1] += (byte)i;
			try {
				
				xlatePound = new String( byteVal,"UTF-8");
				test = test +  xlatePound;
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				test = test +  "****";
			} 
			test = test +  "\n";
		}
		
		*/

		String test = asciiString.replace("£", "");
/*		String Encoding = "Shift_JIS";
		byte temp[] = {(byte)'£'};
		
		try {
			test = new String(temp,Encoding);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "�\n";
*/
		return test;
		
	}
	private void publishResults(int request, String message, int result) {
		final String FUNC_NAME = "publishResults"; 	 
		
		Intent intent = new Intent(NOTIFICATION);
		intent.putExtra(MESSAGE_REQUEST, request);
		intent.putExtra(MESSAGE_ID, msgNo);
		intent.putExtra(MESSAGE_RESPONSE, message);
		intent.putExtra(MESSAGE_ORIGIN, CLASS_NAME);

		intent.putExtra(RESULT, result);
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "Request " + request + " Result " + result + " Message " + message, 0);

		sendBroadcast(intent);
	}
	
	private final Handler handler = new Handler() {
		@Override
		public void handleMessage(Message msg) {
			final String FUNC_NAME = "handleMessage"; 	 
			switch (msg.what) {
				// msg.what is the kind of notification
				case FTPAndroidLib.PRINTERDATA_STATUS: {
					printerResponse = "";
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "PRINTERDATA_STATUS", 0);
					// notification of Printer status
					byte[] dataBuf = (byte[])msg.obj;
					int dataLen = msg.arg1;
					if ((dataBuf[1] & 0x08) != 0) {
					// Printer offline
						printerResponse = printerResponse + "Offline\n";
						TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
								Category.EXIT, "Offline", 0);

					}
					if ((dataBuf[2] & 0x01) != 0) {
					// Low battery
						printerResponse = printerResponse + "Low battery\n";
						TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
								Category.EXIT, "Low battery", 0);

					}
					if ((dataBuf[2] & 0x04) != 0) {
					// Cover open
						printerResponse = printerResponse + "Cover open\n";
						TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
								Category.EXIT, "Cover open", 0);

					}
					if ((dataBuf[3] & 0x04) != 0) {
					// no paper
						printerResponse = printerResponse + "No paper\n";
						TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
								Category.EXIT, "No paper", 0);

					}
					if(printerResponse.equals("")){
						printerResponse = "Roll Printer OK";
					}
					//Return the result
					result = Activity.RESULT_OK;
					int request;
					if(iCCST == PrinterState.PRINTING){
						request = REQUEST_PRINT;
					} else {
						request = REQUEST_STATUS;	
					}
					iCCST = PrinterState.READY;
					publishResults(request,printerResponse, result);
					break;
				}
				case FTPAndroidLib.PRINTERDATA_FIRMWAREVERSION: {
					// notification of Printer firmware version
					byte[] dataBuf = (byte[])msg.obj;
					int dataLen = msg.arg1;
					// display the notification data to textview
					String data = String.format("%02X: ", msg.what);
					String s ="";
					for (int i=0; i<dataLen; i++) {
						s = String.format("%02X ", dataBuf[i]);
						data += s;
					}
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "Firmware " + s, 0);

					break;
				}
				case FTPAndroidLib.PRINTERDATA_SENSOR: {
				// notification of sensor information
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "PRINTERDATA_SENSOR" , 0);

					break;
				}
				case FTPAndroidLib.PRINTERDATA_REGISTRABLEAREA: {
				// notification of remaining size of image registration area
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT, "PRINTERDATA_REGISTRABLEAREA" , 0);

					break;
				}
				default: {
				// notification of remaining size of image registration area
					TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
							Category.EXIT,  "Message " , 0);

					break;
				}
			}
		}
	};

	public int openPrinter(int request, String macAddress) {
		final String FUNC_NAME = "openPrinter"; 	 

		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		int model = FTPAndroidLib.PRINTERMODEL_628WSL210; //(When FTP-628WSL210 is used.)

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request + " Mac " + macAddress, 0);
		
		// call startPrinter method to communicate with a printer.
		iRet = ftpAndroidLib.startPrinter(model, macAddress, handler);
		
		getPrinterStatus(request);
		
		// FTPAndroidLib.ERROR_ALREADYCONNECTEDPRINTER = 2;
		// FTPAndroidLib.ERROR_FAILED =0;
		
		return iRet;
	}
	
	public int closePrinter(int request) {
		final String FUNC_NAME = "closePrinter"; 	 

		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		iRet = ftpAndroidLib.closePrinter();

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request , 0);
		
		
		getPrinterStatus(request);
		
		// FTPAndroidLib.ERROR_ALREADYCONNECTEDPRINTER = 2;
		// FTPAndroidLib.ERROR_FAILED =0;
		
		return iRet;
	}
	
	public void printCharacterString(int request,String str) {
		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		// print the character string
		iRet = ftpAndroidLib.printCharacterString(str);
		return;
		}	
	
	public void getPrinterStatus(int request) {
		final String FUNC_NAME = "closePrinter"; 	 

		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + request , 0);

		// get Printer status
		iRet = ftpAndroidLib.getPrinterData(FTPAndroidLib.PRINTERDATA_STATUS);
		return;
		}
	
	public void startPage() {
		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		// start the page print mode
		Rect rect = new Rect(0, 0, 383, 200); // width:384 dots (the case of 2 inch printer)
		iRet = ftpAndroidLib.startPage(rect);
		// for print position �absolute cordinate-
		Point point = new Point(0, 50);
		// no orientation left to right
		ftpAndroidLib.setAbsolutePosition(point);
		ftpAndroidLib.printCharacterString("Orientation_None\n");
		iRet = ftpAndroidLib.printPage(FTPAndroidLib.PAGEDATA_CLEAR);
		// right 90 degrees orientation up to bottom
		ftpAndroidLib.setOrientation(FTPAndroidLib.ORIENTATION_R90);
		ftpAndroidLib.setAbsolutePosition(point);
		ftpAndroidLib.printCharacterString("Orientation_R90\n90�");
		iRet = ftpAndroidLib.printPage(FTPAndroidLib.PAGEDATA_CLEAR);
		// 180 degrees orientation right to left
		ftpAndroidLib.setOrientation(FTPAndroidLib.ORIENTATION_180);
		ftpAndroidLib.setAbsolutePosition(point);
		ftpAndroidLib.printCharacterString("Orientation_180\n180�");
		iRet = ftpAndroidLib.printPage(FTPAndroidLib.PAGEDATA_CLEAR);
		// left 90 degrees orientation bottom to up
		ftpAndroidLib.setOrientation(FTPAndroidLib.ORIENTATION_L90);
		ftpAndroidLib.setAbsolutePosition(point);
		ftpAndroidLib.printCharacterString("Orientation_L90\n90�");
		iRet = ftpAndroidLib.printPage(FTPAndroidLib.END_PAGEMODE);
		}
	private int mod(int x, int y)
	{
	    int result = x % y;
	    if (result < 0)
	        result += y;
	    return result;
	}
	
	private int testLoad(){
		
		String filename = Environment.getExternalStorageDirectory() + "/com.example.twolibs/" +  "CCST_A-BW-Mono.png";
		BitmapFactory.Options options = new BitmapFactory.Options();
		options.inPreferredConfig = Bitmap.Config.ARGB_8888;
		Bitmap bitmap = BitmapFactory.decodeFile(filename, options);
		
		int widthDots =  bitmap.getWidth(); 
		int heightDots =bitmap.getHeight(); 
		
		int rowWidth = 384; 
		int dataLen = (rowWidth / 8) * heightDots; // number of all data
		boolean dataCompression = false; // no compression
		
		
		
		byte[] data = new byte[dataLen];

		int pixel = 0;
		int iByte = 0;
		int iBit = 0;
		byte iShifted = 0;
		
		for (int y=0; y< heightDots; y++) {
			for (int x=0; x< widthDots ; x++) {
				pixel = bitmap.getPixel(x,y);
				iByte = y * rowWidth/8 + x /8;
				iBit = mod(x, 8);
				iShifted = (byte)(1 >> iBit);
			

				if (pixel == -1) {
					// white data[iByte] = (byte) (data[iByte] & iShifted);
					
				} else {
					data[iByte] = (byte) (data[iByte] & iShifted);					
				}
			}
		}
		// print the bit-image
		int iRet = ftpAndroidLib.printBitimage(data, dataLen, rowWidth, heightDots,
		dataCompression);

		
		return 0;
	}
	private int testLoadImage(){
		
		String filename = Environment.getExternalStorageDirectory() + "/com.example.twolibs/" +  "Sample 2.png";
		Bitmap bitmap = BitmapFactory.decodeFile(filename);
		
		int dithering = FTPAndroidLib.DITHER_BAYER_4X4;
		int widthDots =  384; 
		int heightDots = 0; 
	
		 int iRet =0;
		 
				// print the bit-image
		
			iRet = ftpAndroidLib.printPicture(bitmap, dithering, widthDots, heightDots);
//			iRet = ftpAndroidLib.printPicture(bitmap, dithering, widthDots, heightDots);
//			iRet = ftpAndroidLib.printPicture(bitmap, dithering, widthDots, heightDots);

//		MonochromeConverter mc = new MonochromeConverter(this);
//		String filenameBMP = Environment.getExternalStorageDirectory() + "/com.example.twolibs/" +  "CCST_A-BW.bmp";
//		mc.test();
		
//		Bitmap bitmapBMP = BitmapFactory.decodeFile(filenameBMP);
//		iRet = ftpAndroidLib.printPicture(bitmapBMP, dithering, widthDots, heightDots);
		String receipt = 
				"ARRIVA Trains Wales \n" + 
				"\n" + 
				"ANYTIME DAY TC        �53.70\n" + 
				"  BASINGSTOKE \n" +
				"  - LONDON ZONES 1-6\n" + 
				"  Valid on 24/04/2015\n" + 
				"  1 Adult    Ticket no:175  \n" + 
				"                    ========\n" + 
				"BALANCE DUE           �53.70\n" + 
				"\n" + 
				"Cash                  �73.70\n" + 
				"\n" + 
				"\n" + 
				" 9020T02W31M1023 0001 1912\n" + 
				" Operator 207 13:26 24-04-15\n" + 
				"\n" + 
				"   * 11377329862121654 *\n" ; 
		iRet = ftpAndroidLib.printCharacterString(receipt);

		return 0;
	}

	public void printBitimage() {
		int iRet = FTPAndroidLib.ERROR_SUCCESS;
		
		int widthDots = 384; // width: 384 dots (the case of 2 inch printer)
		int heightDots = 64; // height: 64 dots
		int dataLen = (widthDots / 8) * heightDots; // number of all data
		boolean dataCompression = false; // no compression
		// create the 8x8 checkered bit-image.
		byte[] data = new byte[dataLen];
		int i=0;
		for (int k=0; k<heightDots; k++) {
			for (int j=0; j<(widthDots / 8); j+=2) {
				if ((k % 16) < 8) {
					data[i] = (byte)0xFF;
					data[i+1] = (byte)0x00;
				} else {
					data[i] = (byte)0x00;
					data[i+1] = (byte)0xFF;
				}
				i+=2;
			}
		}
		// print the bit-image
		iRet = ftpAndroidLib.printBitimage(data, dataLen, widthDots, heightDots,
		dataCompression);
		
		testLoadImage();
	}

} 