package com.example.twolibs.DevicesGUI;


import android.app.Activity;
import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DevicesBL.CCSTPrinterService;
import com.example.twolibs.DevicesBL.IngenicoCommon;
import com.example.twolibs.DevicesBL.RollPrinterService;
import com.example.twolibs.FulfilmentBL.CCSTCoupon;
import com.example.twolibs.FulfilmentBL.FulfilmentManager;

//import com.fujitsu.fcl.libFTP2076210R0_Android.FTPAndroidLib;
import com.ingenico.pclservice.IPclService;
import com.ingenico.pclservice.TransactionIn;
import com.ingenico.pclservice.TransactionOut;

public class DeviceSupport extends IngenicoCommon {

	// Ingenico stuff
    private Context activityContext;

	static class PclObject {
		PclServiceConnection serviceConnection;
		IPclService service;
//		NetworkTask nwTask;
	}
    // CCST code
    private BluetoothAdapter bluetoothAdapter;
    private static final int ENABLE_BT_REQUEST_CODE = 1;

//	private static FTPAndroidLib ftpAndroidLib;



	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_devicesupport);

	    activityContext = this;
		setTitle(" Devices");

	    // INGENICO code
	    
        mReleaseService = 1;
        final PclObject data = (PclObject) getLastNonConfigurationInstance();
		if (data == null || data.service == null || data.serviceConnection == null) {
			Log.d(TAG, "onCreate: Init service" );
			initService();
		}
		else
		{
			Log.d(TAG, "onCreate: Service already initialized" );
			mServiceConnection = data.serviceConnection;
			mPclService = data.service;
			mBound = true;
		}

		// call getInstance method to get FTPAndroidLib class instance.
//		ftpAndroidLib = FTPAndroidLib.getInstance();

		
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		
		Button cmdIngenicoStatus = (Button)findViewById(R.id.cmdIngenicoStatus);
		cmdIngenicoStatus.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {
				
			    new GetTermInfoTask().execute();
			}
		}); 	

		Button cmdScanPrinter = (Button)findViewById(R.id.cmdScanPrinter);
		cmdScanPrinter.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {

			   	byte[] result = new byte[1];
			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	

				txtCCSTStatus.setText("Scanning barcode");
			    new OpenBarcodeTask(result).execute();
			    Log.e(TAG,"Scan requested");
			    

			}
		}); 
		
	
		Button cmdTestPrint = (Button)findViewById(R.id.cmdTestPrint);
		cmdTestPrint.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	
				txtCCSTStatus.setText("Test print requested");			    

			   	Log.e(TAG,"cmdTestPrint requested");
				// Create a test print coupon
				FulfilmentManager.STDCreateCouponsResponse resp = FulfilmentManager.createTestCoupon();
				if(resp.ccstCoupons.size() < 1){
					txtCCSTStatus.setText("Error formating test coupon ");		
					return;
				}
				
				CCSTCoupon coupon = resp.ccstCoupons.get(0);
				
				// TODO control the print better....
				// This sets the size bigger then the current list to ensure we don't reprint coupons.

				txtCCSTStatus.setText("Printing test coupon ");			    
						
			    Intent intent = new Intent(DeviceSupport.this, CCSTPrinterService.class);
			    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_PRINT);
			    intent.putExtra(CCSTPrinterService.MESSAGE_CONTENT, coupon.strPrintMessage);
			    startService(intent);	
			    	    
		    	
			}
		});
		
		Button cmdConnRoll = (Button)findViewById(R.id.cmdConnRoll);
		cmdConnRoll.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			    Log.e(TAG,"cmdConnRoll requested");
			    
			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	

				txtCCSTStatus.setText("Ready requested");			   
				
				//OpenPrinter();
				
				//new DoResetRollTask("").execute();
				
				Intent intent = new Intent(DeviceSupport.this, RollPrinterService.class);
				intent.putExtra(RollPrinterService.MESSAGE_REQUEST, RollPrinterService.REQUEST_CONNECT);
			    intent.putExtra(RollPrinterService.MAC_ADDRESS, "");
				startService(intent);
		    	
			}
		});
		Button cmdQueryRoll = (Button)findViewById(R.id.cmdQueryRoll);
		cmdQueryRoll.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			    Log.e(TAG,"cmdQueryRoll requested");
			    
			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	

				txtCCSTStatus.setText("Ready requested");			   
				
				//new DoResetRollTask("").execute();
				//printCharacterString("Hello world\n");
			
				Intent intent = new Intent(DeviceSupport.this, RollPrinterService.class);
				intent.putExtra(RollPrinterService.MESSAGE_REQUEST, RollPrinterService.REQUEST_PRINT);
				intent.putExtra(RollPrinterService.MESSAGE_CONTENT, "Test Print\n\n\n\n\n\n");
				startService(intent);
		    	
			}
		});
		Button cmdDone = (Button)findViewById(R.id.cmdDone);
		cmdDone.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

			    Log.e(TAG,"cmdDone requested");
			    
             	Intent returnIntent = new Intent();
               	setResult(RESULT_OK,returnIntent);
               	finish(); 
		    	
			}
		}); 		
		/*
		Button cmdIngenicoPay = (Button)findViewById(R.id.cmdIngenicoPay);
		cmdIngenicoPay.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {  

		    	TransactionIn transIn = new TransactionIn();
		    	TransactionOut transOut = new TransactionOut();
				
		    		String amount = Float.toString(56);
			    	transIn.setAmount(amount);
			    	transIn.setCurrencyCode("978");
			    	transIn.setOperation("C");
			    	transIn.setTermNum("58");
			        new DoTransactionTask(transIn, transOut).execute();
			}
		}); 
		*/
		
		// CCST Code
		bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
		
		Button cmdCCSTStatus = (Button)findViewById(R.id.cmdCCSTStatus);
		cmdCCSTStatus.setOnClickListener(new OnClickListener() {  

			public void onClick(View view) {
				
			   	TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);
			    txtCCSTStatus.setText("Checking printer");
			    
			    Intent intent = new Intent(DeviceSupport.this, CCSTPrinterService.class);
			    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_STATUS);
			    intent.putExtra(CCSTPrinterService.MAC_ADDRESS, "");
			    startService(intent);
			}
		});
		
		txtPED.setText("Checking PED");
		//txtCCSTStatus.setText("Connecting to CCST printer");
		CheckBluetooth();
	
		//ConnectDevice("");
	}
	
	// INGENICO CODE 
	
	class GetTermInfoTask extends AsyncTask<Void, Void, Boolean> {
		protected Boolean doInBackground(Void... tmp) {
			Boolean bRet = getTermInfo();
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "PED not connected";
			TextView txtPED = (TextView)findViewById(R.id.txtPED);
			txtPED.setText(Boolean.toString(result));
			if (result == true)
			{
				strResult = String.format("SN: %08x PN:%08x", SN, PN);
				txtPED.setBackgroundColor(Color.GREEN);
				txtPED.setTextColor(Color.BLACK);		
			} else {
				txtPED.setBackgroundColor(Color.RED);
				txtPED.setTextColor(Color.BLACK);		
			}
			txtPED.setText(strResult);
		}
	}

	class OpenBarcodeTask extends AsyncTask<Void, Void, Boolean> {
		private byte[] mResult;
		OpenBarcodeTask(byte[] result) {
			mResult = result;
		}
		protected Boolean doInBackground(Void... dummy) {
			Boolean bRet = false;
			bRet = openBarcode(mResult);
			Log.d(TAG, String.format("openBarcode bRet=%s mResult=%d", Boolean.toString(bRet), mResult[0]));
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "";
			TextView txtCCSTPrinter = (TextView)findViewById(R.id.txtCCSTPrinter);	
			txtCCSTPrinter.setText(Boolean.toString(result));
			if (result == true)
			{
				switch (mResult[0]) {
				case 0:
					strResult = "Barcode scanner ready";
					break;
				default:
					strResult = "Failed (" + mResult[0] + ")";
					break;
				}
			} else {
				strResult = "Barcode scanner on";
			}
			// TODO Setup the MAC code with :
			txtCCSTPrinter.setText(strResult);
		}
	}
	
	class CloseBarcodeTask extends AsyncTask<Void, Void, Boolean> {
		private byte[] mResult;
		CloseBarcodeTask(byte[] result) {
			mResult = result;
		}
		protected Boolean doInBackground(Void... dummy) {
			Boolean bRet = false;
			bRet = closeBarcode(mResult);
			Log.d(TAG, String.format("closeBarcode bRet=%s mResult=%d", Boolean.toString(bRet), mResult[0]));
			return bRet;
		}

		protected void onPostExecute(Boolean result) {
			String strResult = "N/A";
			TextView txtPED = (TextView)findViewById(R.id.txtPED);
			txtPED.setText(Boolean.toString(result));
			if (result == true)
			{
				switch (mResult[0]) {
				case 0:
					strResult = "OK";
					txtPED.setText(strResult);
					break;
				default:
					strResult = "Failed (" + mResult[0] + ")";
					txtPED.setText(strResult);
					break;
				}
			} else {
				txtPED.setText("Failed ");

			}
		}
	}
	
	class DoTransactionTask extends AsyncTask<Void, Void, Boolean> {
 		private TransactionIn transIn;
		private TransactionOut transOut;
    	public DoTransactionTask(TransactionIn transIn, TransactionOut transOut) {
    		Log.d(TAG, String.format("DoTransactionTask CONSTRUCT"));
    		this.transIn = transIn;
    		this.transOut = transOut;
    	}
    	
        protected Boolean doInBackground(Void... tmp) {
        	Boolean bRet = doTransaction(transIn, transOut);
            return bRet;
        }

        protected void onPostExecute(Boolean result) {
        	Log.d(TAG, String.format("DoTransactionTask onPostExecute"));
	        if (transOut.getC3Error().equals("0000"))
	        {	
	        	// prepare the alert box
	            AlertDialog.Builder alertbox = new AlertDialog.Builder(activityContext);
	 
	            // set the message to display
	            alertbox.setMessage(getString(R.string.str_print));
	 
	            // set a positive/yes button and create a listener
	            alertbox.setPositiveButton(getString(R.string.str_yes), new DialogInterface.OnClickListener() {
	 
	                // do something when the button is clicked
	                public void onClick(DialogInterface arg0, int arg1) {
	                	
	                	/* Print receipt
	                	// Read the contents of our asset
	                	InputStream is;
	                    AssetManager assetManager = getAssets();
	                    try {
							is = assetManager.open("logo_spice.bmp");
						} catch (IOException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
							return;
						}
	                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
	                    byte buf[] = new byte[1024];
	                    int len;
	                    try {
	                    	while ((len = is.read(buf)) != -1) {
	                    		outputStream.write(buf,0,len);
	                    	}
	                    	outputStream.close();
	                    	is.close();
	                    } catch (IOException e) {}
	                    byte[] bMapArray =outputStream.toByteArray();
	                	
	                    new PrintBitmapTask().execute(bMapArray);
						*/
	                }
	            });
	 
	            // set a negative/no button and create a listener
	            alertbox.setNegativeButton(getString(R.string.str_no), new DialogInterface.OnClickListener() {
	 
	                // do something when the button is clicked
	                public void onClick(DialogInterface arg0, int arg1) {
	                	Toast.makeText(getBaseContext(),getString(R.string.str_thanks), Toast.LENGTH_LONG).show();
	                	
	                }
	            });
	 
	            // display box
	            alertbox.show();
	        }
	        else
	        {
	        	Toast.makeText(getBaseContext(),getString(R.string.str_failed), Toast.LENGTH_LONG).show();	
	        }

        }
    }
	
	@Override
	public void onStateChanged(String state) {
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		if (state.equals("CONNECTED"))
		{
			txtPED.setText("Connected");
			txtPED.setBackgroundColor(Color.GREEN);
			txtPED.setTextColor(Color.BLACK);
			
			new GetTermInfoTask().execute();
		}
		else
		{
			txtPED.setText("Not connected");
			txtPED.setBackgroundColor(Color.RED);
			txtPED.setTextColor(Color.BLACK);
		}
	}
	
	@Override
	public void onPclServiceConnected() {
		Log.d(TAG, "onPclServiceConnected");
		TextView txtPED = (TextView)findViewById(R.id.txtPED);
		
		if (isCompanionConnected())
        {
			txtPED.setText("Connected companion");
			txtPED.setBackgroundColor(Color.GREEN);
			txtPED.setTextColor(Color.BLACK);
			
			new GetTermInfoTask().execute();
        }
        else
        {
			txtPED.setText("Ped not connected");
			txtPED.setBackgroundColor(Color.RED);
			txtPED.setTextColor(Color.BLACK);
        }
	}
	
	@Override
	public void onBarCodeReceived(String barCodeValue)
	{
		TextView txtCCSTPrinter = (TextView)findViewById(R.id.txtCCSTPrinter);	
		txtCCSTPrinter.setText(barCodeValue);

		Log.d(TAG, "Begin DoResetCCSTTask" );

//	 Toast.makeText(getBaseContext(), "Barcode " + barCodeValue, Toast.LENGTH_SHORT).show();
		
		//TODO validate and format barcode and pass to connect

		new DoResetCCSTTask(barCodeValue).execute();
		
		Log.d(TAG, "End DoResetCCSTTask" );

	}
	
	private boolean openBarcode(byte[] result) {
		boolean ret = false;
		if( mPclService != null ) {
			try {
				ret = mPclService.openBarcode(result);
			} catch( RemoteException ex ) {
				ex.printStackTrace();
			}
		}
		else {
			Log.d(TAG, "openBarcode: mPclService is null");
		}
		return ret;
	}

	private boolean closeBarcode(byte[] result) {
		boolean ret = false;
		if( mPclService != null ) {
			try {
				ret = mPclService.closeBarcode(result);
			} catch( RemoteException ex ) {
				ex.printStackTrace();
			}
		}
		return ret;
	}
	
	
	
    public void CheckBluetooth() {


        if (bluetoothAdapter == null) {
            // Device does not support Bluetooth
            Toast.makeText(getApplicationContext(), "Oop! Your device does not support Bluetooth",
                    Toast.LENGTH_SHORT).show();
           
        } else {

            if (!bluetoothAdapter.isEnabled()) {
                // A dialog will appear requesting user permission to enable Bluetooth
                Intent enableBluetoothIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                startActivityForResult(enableBluetoothIntent, ENABLE_BT_REQUEST_CODE);
            }
        }
    }

	// CCST - Code
	private final BroadcastReceiver receiverCCST = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				int resultCode = bundle.getInt(CCSTPrinterService.RESULT);
				String string = bundle.getString(CCSTPrinterService.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(CCSTPrinterService.MESSAGE_ORIGIN);
				if(origin == null) {
					origin = "no origin";
				}
				
				Log.e("DS","BC1 received " + origin);
				    
				TextView tv = (TextView) findViewById(R.id.txtCCSTStatus);
				if(origin.equals(CCSTPrinterService.CLASS_NAME)) {
					if (resultCode == RESULT_OK) {
						tv.setText("CCST ok" + string);
						tv.setBackgroundColor(Color.GREEN);
						tv.setTextColor(Color.BLACK);		
	
					} else {
						tv.setText("CCST failed " + resultCode + "\n" +  string);
						tv.setBackgroundColor(Color.RED);
						tv.setTextColor(Color.BLACK);		
					}
				}
			}
		}
	};
    public void connectCCSTDevice(String macAddress) {

	    Intent intent = new Intent(DeviceSupport.this, CCSTPrinterService.class);
	    // TODO send MAC address
	    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_CONNECT);
	    intent.putExtra(CCSTPrinterService.MAC_ADDRESS, macAddress);
	    startService(intent);
    }

    public void closeCCSTDevice() {

	    Intent intent = new Intent(DeviceSupport.this, CCSTPrinterService.class);
	    // TODO send MAC address
	    intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_CLOSE);
	    intent.putExtra(CCSTPrinterService.MAC_ADDRESS, "");
	    
	    startService(intent);
    }
    
	// Roll - Code
	private final BroadcastReceiver receiverRoll = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				int resultCode = bundle.getInt(RollPrinterService.RESULT);
				String string = bundle.getString(RollPrinterService.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(RollPrinterService.MESSAGE_ORIGIN);
				if(origin == null) {
					origin = "no origin";
				}
				
				Log.e("DS","BC1 received " + origin);
				    
				TextView tv = (TextView) findViewById(R.id.txtCCSTStatus);
				if(origin.equals(RollPrinterService.CLASS_NAME)) {
					if (resultCode == RESULT_OK) {
						tv.setText(string);
						tv.setBackgroundColor(Color.GREEN);
						tv.setTextColor(Color.BLACK);		
	
					} else {
						tv.setText("Roll failed " + resultCode + "\n" +  string);
						tv.setBackgroundColor(Color.RED);
						tv.setTextColor(Color.BLACK);		
					}
				}
			}
		}
	};

    public void connectRollDevice(String macAddress) {

	    Intent intent = new Intent(DeviceSupport.this, RollPrinterService.class);
	    // TODO send MAC address
	    intent.putExtra(RollPrinterService.MESSAGE_REQUEST, RollPrinterService.REQUEST_CONNECT);
	    intent.putExtra(RollPrinterService.MAC_ADDRESS, ""); //macAddress);
	    startService(intent);
    }

    public void closeRollDevice() {

	    Intent intent = new Intent(DeviceSupport.this, RollPrinterService.class);
	    // TODO send MAC address
	    intent.putExtra(RollPrinterService.MESSAGE_REQUEST, RollPrinterService.REQUEST_CLOSE);
	    intent.putExtra(RollPrinterService.MAC_ADDRESS, "");
	    
	    startService(intent);
    }
    
    class DoResetRollTask extends AsyncTask<Void, Void, Boolean> {
  		private String newMacAddress;
     	public DoResetRollTask(String newMacAddress) {
     		Log.d(TAG, String.format("DoResetCCSTTask CONSTRUCT"));
     		this.newMacAddress = newMacAddress;
     	}
     	
         protected Boolean doInBackground(Void... tmp) {
         	boolean bRet = false;
         	
     		Log.d(TAG, "Close request" );

//     		 Toast.makeText(getBaseContext(), "Barcode " + barCodeValue, Toast.LENGTH_SHORT).show();
//     	    TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	
//     	    txtCCSTStatus.setText("Request close of CCST printer");	
    			
     		closeRollDevice();

     		try {
     		      Thread.sleep(1000);         
     		} catch (InterruptedException e) {
     		      e.printStackTrace();
     		}
     			
     		Log.d(TAG, "Connect request" );
     			
//     		txtCCSTStatus.setText("Connecting to CCST printer");	

     			//TODO validate and format barcode and pass to connect
     		connectRollDevice("");
     			
     		return bRet;
         }

         protected void onPostExecute(Boolean result) {
         	Log.d(TAG, String.format("DoResetCCSTTask onPostExecute"));
         	if(result){
//         		Toast.makeText(getBaseContext(),"CCST connection reset", Toast.LENGTH_LONG).show();	
 	        } else {
// 	        	Toast.makeText(getBaseContext(),getString(R.string.str_failed), Toast.LENGTH_LONG).show();	
 	        }

         }
     }
    
    public void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == ENABLE_BT_REQUEST_CODE) {

            // Bluetooth successfully enabled!
            if (resultCode != Activity.RESULT_OK) {
            	// RESULT_CANCELED as user refused or failed to enable Bluetooth
                Toast.makeText(getApplicationContext(), "Bluetooth is not enabled.",
                        Toast.LENGTH_SHORT).show();
            }
        }
    }



    @Override
    protected void onResume() {
        super.onResume();
        // Register the BroadcastReceiver for ACTION_FOUND
        this.registerReceiver(receiverCCST, new IntentFilter(CCSTPrinterService.NOTIFICATION));
//        this.registerReceiver(receiverCCSTSupport, new IntentFilter(CCSTSupportService.NOTIFICATION));
 //       this.registerReceiver(receiverRoll, new IntentFilter(RollPrinterService.NOTIFICATION));
        this.registerReceiver(refreshScreen, new IntentFilter(AppContext.NOTIFICATION));

    }

    @Override
    protected void onPause() {
        super.onPause();
        this.unregisterReceiver(receiverCCST);
//        this.unregisterReceiver(receiverCCSTSupport);
//        this.unregisterReceiver(receiverRoll);
        this.unregisterReceiver(refreshScreen);
    }

    class DoResetCCSTTask extends AsyncTask<Void, Void, Boolean> {
 		private String newMacAddress;
    	public DoResetCCSTTask(String newMacAddress) {
    		Log.d(TAG, String.format("DoResetCCSTTask CONSTRUCT"));
    		this.newMacAddress = newMacAddress;
    	}
    	
        protected Boolean doInBackground(Void... tmp) {
        	boolean bRet = false;
        	
    		Log.d(TAG, "Close request" );

//    		 Toast.makeText(getBaseContext(), "Barcode " + barCodeValue, Toast.LENGTH_SHORT).show();
//    	    TextView txtCCSTStatus = (TextView)findViewById(R.id.txtCCSTStatus);	
//    	    txtCCSTStatus.setText("Request close of CCST printer");	
   			
    		closeCCSTDevice();

    		try {
    		      Thread.sleep(1000);         
    		} catch (InterruptedException e) {
    		      e.printStackTrace();
    		}
    			
    		Log.d(TAG, "Connect request" );
    			
//    		txtCCSTStatus.setText("Connecting to CCST printer");	

    			//TODO validate and format barcode and pass to connect
    		connectCCSTDevice("");
    			
    		return bRet;
        }

        protected void onPostExecute(Boolean result) {
        	Log.d(TAG, String.format("DoResetCCSTTask onPostExecute"));
        	if(result){
//        		Toast.makeText(getBaseContext(),"CCST connection reset", Toast.LENGTH_LONG).show();	
	        } else {
//	        	Toast.makeText(getBaseContext(),getString(R.string.str_failed), Toast.LENGTH_LONG).show();	
	        }

        }
    }
    
	// CCSTSupport - Code
    
/*	private final BroadcastReceiver receiverCCSTSupport = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			
			
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				String string = bundle.getString(CCSTSupportService.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(CCSTSupportService.MESSAGE_ORIGIN);
				if(origin == null) {
					origin = "no origin";
				}
				int request = bundle.getInt(CCSTSupportService.MESSAGE_REQUEST);
				int resultCode = bundle.getInt(CCSTSupportService.RESULT);
				    
				Log.e("DS","BC2 received" + origin + " " + request);
			
				TextView tv = (TextView) findViewById(R.id.txtCCSTStatus);
				
				if(origin.equals(CCSTSupportService.TAG)){
					if (resultCode == RESULT_OK) {
						tv.setText("CCSTSupport ok" + string);
						tv.setBackgroundColor(Color.GREEN);
						tv.setTextColor(Color.BLACK);		
	
					} else {
						tv.setText("CCSTSupport failed " + resultCode + "\n" +  string);
						tv.setBackgroundColor(Color.RED);
						tv.setTextColor(Color.BLACK);		
					}
					
					//if(request == CCSTSupportService.REQUEST_READY ){
					//	doFormatPrint();
					//}
					if(request == CCSTSupportService.REQUEST_TESTPRINT ){
						doPhysicalPrint(string);
					}	
				}
				
			}
		}
	};
	
	public void doFormatPrint(){
		TextView txtCCSTStatus = (TextView) findViewById(R.id.txtCCSTStatus);
		txtCCSTStatus.setText("TestPrint  requested");			    
	    Intent intent = new Intent(DeviceSupport.this, CCSTSupportService.class);
	    intent.putExtra(CCSTSupportService.MESSAGE_REQUEST, CCSTSupportService.REQUEST_TESTPRINT);
	    startService(intent);

	};
	public void doPhysicalPrint(String msgText){	
		TextView txtCCSTStatus = (TextView) findViewById(R.id.txtCCSTStatus);
		txtCCSTStatus.setText("Print requested");			    
		//String msgText = "Pn000503NEWBURY DATA ND4025 Mk.2 TICKET PRINTER\r\n";
		
		Intent intent = new Intent(DeviceSupport.this, CCSTPrinterService.class);
		intent.putExtra(CCSTPrinterService.MESSAGE_REQUEST, CCSTPrinterService.REQUEST_PRINT);
		intent.putExtra(CCSTPrinterService.MESSAGE_CONTENT, msgText);
		startService(intent);
	};
	
	*/

	// Refresh code
	private final BroadcastReceiver refreshScreen = new BroadcastReceiver() {
	
		@Override
		public void onReceive(Context context, Intent intent) {
			Bundle bundle = intent.getExtras();
			if (bundle != null) {
				int resultCode = bundle.getInt(AppContext.RESULT);
				String string = bundle.getString(AppContext.MESSAGE_RESPONSE);
				if(string == null) {
					string = "";
				}
				String origin = bundle.getString(AppContext.MESSAGE_ORIGIN);
				if(origin == null) {
					origin = "no origin";
				}
				
				Log.e("DS","Screen refresh received " + origin);
				    
				TextView tv = (TextView) findViewById(R.id.txtCCSTStatus);
				if(origin.equals(RollPrinterService.CLASS_NAME)) {
					if (resultCode == RESULT_OK) {
						tv.setText(string);
						tv.setBackgroundColor(Color.GREEN);
						tv.setTextColor(Color.BLACK);		
	
					} else {
						tv.setText("Roll failed " + resultCode + "\n" +  string);
						tv.setBackgroundColor(Color.RED);
						tv.setTextColor(Color.BLACK);		
					}
				}
			}
		}
	};



}