package com.example.twolibs.DutyBL;

import java.util.ArrayList;
import java.util.Date;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DataTransferBL.DataTransferManager.FileType;
import com.example.twolibs.DutyBL.DutyTask.TaskState;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class Duty {
	
	//
	// A duty is a list of activities that an operator is expecting to perform during a shift.
	// Examples of duties could be:
	//			Selling tickets in the foyer (Queuebusting)
	//			Helping a disable person board a train (Advanced passenger assistance request)
	//
	// The purpose of the Duty class is to hold the data need to specify a duty.
	// 
	// 
	private static String CLASS_NAME = "Duty";  	// Used for tracing
	

	public String dutyName = "";  			// Human readable description of duty
	public String dutyId = "";    			// Unique short code for duty

	// List of all the duties that have been imported
	public static ArrayList<Duty> allDutys = new ArrayList<Duty>();

	// List of all the tasks that are to be performed for this duty
	public  ArrayList<DutyTask> dutyActivities = new ArrayList<DutyTask>();
	public static int firstIndex = -1;          // The index of the first due or active task
	
	
	public DutyTask updateTaskStates (Date pTime){
		final String FUNC_NAME = "updateTaskStates"; 
		
		// This method checks all the tasks against the current time.
		// It will flag when a task is due and when it has expired
		// It sets the active task to the first task with special processing that is active else nulls it
		// Sets the index to the first Due or Active task
		//
		// It returns the first due task or null if none.
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, DataConvert.displayyyyyMMddHHmm(pTime), 0);

		DutyTask task = null;
		long calNow = DataConvert.getTimeInMillis(DataConvert.DATENULL);
		
		DutyTask dueTask = null;
		
		DutyManager.activeTask = null;
		firstIndex = -1;
		
		int i;						 
		for (i=0 ; i<dutyActivities.size(); i++ )
		{
			task = dutyActivities.get(i);
			
			DutyTaskType taskType;
			try{
				taskType = DutyTaskType.getTaskType(task.taskType);
			} catch (Exception e){
				// If not found then do a null type of task...
				taskType = new DutyTaskType();
				taskType.taskTypeCode = task.taskType;
				taskType.taskTypeTitle = "Not found " + task.taskType;
				
			}
			
			// The taskType has the notification time in minutes
			// This sets the task state as DUE
			// eg "if the task is due in the next x mins..."
			long calTaskStart = DataConvert.getTimeInMillis(task.taskStart);

			long timeDiff = calNow - calTaskStart;

			if(timeDiff > - (taskType.taskTypeNofify * 60 * 1000)){
				// This task is due
				if(task.taskState.ordinal() <  TaskState.ACTIVE.ordinal()){
					task.taskState = TaskState.DUE;
				}
			} 
			
			long calTaskEnd = DataConvert.getTimeInMillis(task.taskEnd);
			
			timeDiff = calNow - calTaskEnd;		
			
			if(timeDiff > (taskType.taskTypeNofify * 60 * 1000)){
				// TODO Expiry of task could have its own field
				// This task is expired
				if(task.taskState.ordinal() <  TaskState.COMPLETE.ordinal()){
					task.taskState = TaskState.EXPIRED;
				}
			}
			
			// Set the current active task that has special processing that effects the context
			if((task.taskState == TaskState.ACTIVE) && (taskType.taskSpecialAction != TaskSpecialAction.NONE)){
				if (DutyManager.activeTask  == null){
					DutyManager.activeTask = task;
				}
				if(firstIndex < 0){
					firstIndex = i;
				}
			}
			
			if(task.taskState == TaskState.DUE){
				if (dueTask  == null){
					dueTask = task;
				}
				if(firstIndex < 0){
					firstIndex = i;
				}
			}
		}

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "", 0);
		
		return dueTask;
	}
	


	public void updateTasktimes (){
		final String FUNC_NAME = "updateTasktimes"; 
		
		// This method sets the end time of tasks that change the context to the start of the next such task
		// I.e. If QueueBust is followed by boarding a train then the end time of Queuebusting is
		// set to when the train is boarded
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
		
		int i;
		DutyTask task = null;
		DutyTask lastTask = null;
		DutyTaskType dutyTaskType = null;
		DutyTaskType lastDutyTaskType = null;
		
		for (i=0 ; i<dutyActivities.size(); i++ )
		{
			task = dutyActivities.get(i);
			
			dutyTaskType = DutyTaskType.getTaskType(task.taskType);
			
			
			if(dutyTaskType.taskSpecialAction == TaskSpecialAction.NONE){
				continue;
			}
			
			if(lastTask != null){
				lastTask.taskEnd = task.taskStart;
			}
			
			lastTask = task;
			lastDutyTaskType = dutyTaskType;
		}
		
		if(lastTask != null){
			// Set the end of the last task to the end of shift
			if  (lastDutyTaskType.taskSpecialAction != TaskSpecialAction.BOARD_TRAIN){

				// TODO When is the end of shift - replace the midnight time?
        	    lastTask.taskEnd =DataConvert.setTime(lastTask.taskStart, 24, 0, 0);
        		
			}
		}

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.EXIT, "", 0);
		
		return ;
	}
	
    
    
    public static ArrayList<Duty> doLoadXML(){
    	
       	// 
    	// Load a list of task types needed to interpret supplied roster data
    	// 
		// 
		final String FUNC_NAME = "doLoadXML"; 

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		allDutys = new ArrayList<Duty>();

		DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(FileType.DUTIES);

	    if(resp.result == DutyManager.Response.OK){    
        
	    	try {
		
	    		NodeList nodeList = resp.doc.getElementsByTagName("duty");
	    		for (int i = 0; i < nodeList.getLength(); i++) {
	
	    			Node node = nodeList.item(i);
	     			Duty duty = Duty.fromXML(node);
	     			if(duty != null){
	     				// Fix up end times
		    	    	duty.updateTasktimes();
		    	    	allDutys.add(duty);
	     			}
	    		}
	
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "Loaded " + allDutys.size(), 0);
	
			} catch (Exception e) {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "XML Pasing Exception = " + e, 0);
			}
	    	
		} else {
			
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "Document not loaded", 0);			
		}
   	
    	return allDutys;

    }
 

	
	public static Duty fromXML(Node pNode){
		final String FUNC_NAME = "fromXML"; 
		//
		// Loads an instance from an XML stream
		//
		// If we get any errors return Null duty and it will be ignored
		//
		
		Duty duty = new Duty();
		
		try {
			duty.dutyId = pNode.getAttributes().getNamedItem("dutyId").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML dutyId Exception = " + e, 0);
			return null;
		}
	
		try {
			duty.dutyName = pNode.getAttributes().getNamedItem("dutyName").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML dutyName Exception = " + e, 0);
			return null;
		}
		
		// Now read all the tasks that make up the duty
		int i = 0;
		try {
			Element element = (Element) pNode;
			NodeList nodeList = element.getElementsByTagName("task");
			for (i = 0; i < nodeList.getLength(); i++) {
	
				Node subNode = nodeList.item(i);
	 			DutyTask task = DutyTask.fromXML(subNode);
	 			if(task != null){
	 				duty.dutyActivities.add(task);
	 			}
			}
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "XML task " + i +" Parsing Exception = " + e, 0);
			return null;
		}
		
		return duty;
		
	}

}
