package com.example.twolibs.DutyBL;

import java.util.ArrayList;
import java.util.Date;

import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.DutyTask.TaskState;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.GenericManager;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;
import com.example.twolibs.TimeTableBL.SearchResponse;
import com.example.twolibs.TimeTableBL.TTJourney;
import com.example.twolibs.TimeTableBL.TTLeg;
import com.example.twolibs.TimeTableBL.TTSearch;
import com.example.twolibs.TimeTableBL.TTSearchCriteria;
import com.example.twolibs.TimeTableBL.TTStop;

public class DutyManager extends GenericManager {

	private static String CLASS_NAME = "DutyTaskType"; // Used for tracing
	//
	// This class supports the Duty related functions of the application
	// All the GUI actions are implements by this class
	//
	// It handles list of duties and searching for duties
	// It handles selection of a duty and making it active
	// It handles life cycle of a task (Todo, Due, Active, Complete, Expired)
	// It handles the task related data - for example trains and locations
	//

	// Refresh flag - if set will force a refresh when required.
	private static boolean refreshRequired = true;
	private static String DataDomain = "DutyData";

	// Context information
	public static Duty activeDuty = null;
	public static DutyTask activeTask = null;

	public static void dataChanged(String pDataDomain) {
		//
		// Method is called whenever the dataDownLoad service updates a data
		// domain
		//
		if (pDataDomain.equals(DataDomain)) {
			refreshRequired = true;
		}
	}

	public static void refreshdata() {
		final String FUNC_NAME = "refreshdata";
		//
		// Resets all the data associated with the Duty subsystem
		//
		// Returns the load list of duties
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		if (refreshRequired) {

			// Load the task definitions
			DutyTaskType.doLoadXML();

			// Load the imported duties
			Duty.doLoadXML();

			// Clear any selections
			activeDuty = null; // Currently selected duty
			activeTask = null; // Currently selected duty

			refreshRequired = false;

		}

		return;
	}

	public static DomainStatusResponse checkStatus() {
		final String FUNC_NAME = "checkStatus";
		//
		// Find out whether there is a due duty
		// If so we need to flag action is required and setup a title
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		DomainStatusResponse resp = new DomainStatusResponse();

		DutyTask dueTask = null;

		// If a duty has been selected then update task states as time might
		// have past
		if (activeDuty != null) {
			dueTask = activeDuty.updateTaskStates(DataConvert.getNow());
		}

		if (dueTask == null) {
			resp.status = MenuState.NORMAL;
			resp.shortDescrition = "Duty";
		} else {
			resp.status = MenuState.NOTIFY;
			resp.shortDescrition = "Duty\n(" + dueTask.taskType + ")";
		}

		return resp;
	}

	public static void setDuty(AppContext pAC, Duty pDuty) {
		final String FUNC_NAME = "checkStatus";
		//
		// This makes a selected duty current.
		// The tasks are checked and any that involve train journeys will get
		// the journey
		// The tasks will be updated to reflect the current time
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		activeDuty = pDuty;

		// Need to fix up end times
		pDuty.updateTasktimes();

		for (DutyTask t : activeDuty.dutyActivities) {

			DutyTaskType dutyTaskType = DutyTaskType.getTaskType(t.taskType);

			if (dutyTaskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN) {
				if (t.trainRetailId.length() == 0) {
					// Lets lookup the train....

					TTSearchCriteria TTCrit = pAC.ttSearch.setupDefaults(
							t.taskLocationFrom, t.taskLocationTo, t.taskStart,
							0, 0);
					TTCrit.setSc_earlierjourneys(0);
					TTCrit.setSc_laterjourneys(1);
					TTCrit.setSc_numovertaken(0);
					SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
					if (resp.objTTsearchResults.getSr_numjourneys() > 0) {
						TTJourney jny = resp.objTTsearchResults
								.getSr_journeys().get(0);
						setupJourneyDetails(jny, t);
					}

				}
			}

			activeDuty.updateTaskStates(DataConvert.getNow());
		}

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.EXIT, "", 0);
		return;
	}

	public static void setTaskState(AppContext pAC, DutyTask pTask,
			TaskState pNewTaskState) {
		final String FUNC_NAME = "setTaskState";
		//
		// If a task is made active then the context needs to be changed
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, pTask.taskId + " " + pNewTaskState.name(), 0);

		// If no change exit
		if (pTask.taskState == pNewTaskState) {
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
					Category.EXIT, "No change", 0);
			return;
		}

		// If the selected task has special processing and we are making it
		// active
		// then we can Complete any other active tasks with special processing
		DutyTaskType dutyTaskType = DutyTaskType.getTaskType(pTask.taskType);

		if ((pNewTaskState == TaskState.ACTIVE)
				&& (dutyTaskType.taskSpecialAction != TaskSpecialAction.NONE)) {
			deactivateTasks();
			DutyTaskType taskType = DutyTaskType.getTaskType(pTask.taskType);

			if (taskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN) {
				// We need the stopping list associated with the task
				TTSearchCriteria TTCrit = pAC.ttSearch.setupDefaults(
						pTask.taskLocationFrom, pTask.taskLocationTo,
						pTask.taskStart, 0, 0);
				TTCrit.setSc_earlierjourneys(0);
				TTCrit.setSc_laterjourneys(1);
				TTCrit.setSc_numovertaken(0);
				SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
				if (resp.objTTsearchResults.getSr_numjourneys() > 0) {
					TTJourney jny = resp.objTTsearchResults.getSr_journeys()
							.get(0);
					setupJourneyDetails(jny, pTask);
				}
			}

		}
		pTask.taskState = pNewTaskState;

		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.EXIT, "", 0);
		return;
	}

	public static void deactivateTasks() {
		final String FUNC_NAME = "deactivateTasks";
		//
		// Auto complete active duties when a new duty is made active
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		if (activeDuty != null) {
			for (DutyTask task : activeDuty.dutyActivities) {
				DutyTaskType dutyTaskType = DutyTaskType
						.getTaskType(task.taskType);
				if (dutyTaskType.taskSpecialAction != TaskSpecialAction.NONE) {
					// Auto complete active duties
					if (task.taskState == TaskState.ACTIVE) {
						task.taskState = TaskState.COMPLETE;
					}
				}
			}

		}
		return;
	}

	public static void setupAdHocDuty(AppContext pAC, String pTaskType,
			Date pStartTime, Location pOrigin, Location pDestination,
			TTJourney pJny) {
		//
		// Used to cater for a duty that has not been setup or delays etc. have
		// changed the existing duty
		//
		final String FUNC_NAME = "setupAdHocDuty";
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, pTaskType, 0);

		Duty adHoc = new Duty();
		adHoc.dutyId = "ADHOC";
		adHoc.dutyName = "Ad hoc duty";

		DutyTask task = new DutyTask();
		task.taskId = "1";
		task.taskType = pTaskType;

		DutyTaskType dutyTaskType = DutyTaskType.getTaskType(pTaskType);
		task.taskComment = dutyTaskType.taskTypeTitle;

		task.taskStart = pStartTime;
		task.taskState = TaskState.ACTIVE;

		task.taskLocationFrom = pOrigin;
		task.taskLocationTo = pDestination;

		adHoc.dutyActivities.add(task);
		adHoc.updateTasktimes();

		setDuty(pAC, adHoc);
		setTaskState(pAC, task, TaskState.ACTIVE);

	}

	public static void setupJourneyDetails(TTJourney pJny, DutyTask pTask) {
		//
		// Copy train details into the task
		//
		final String FUNC_NAME = "setupJourneyDetails";
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		// Use the details for the first, hopefully only leg
		TTLeg leg = pJny.getJy_legs().get(0);
		pTask.trainRetailId = leg.getLeg_retailTOC();
		// TODO retrieve the headcode
		pTask.trainHeadCode = "";
		pTask.trainDepart = leg.getLeg_departs();
		pTask.taskEnd = leg.getLeg_arrives();

		// TODO magic numbers - should be an enum or at least a constant
		if (leg.getLeg_reservable() == 4) {
			pTask.reservations = false;
		} else {
			pTask.reservations = true;
		}

		// When boarding a train the context is required for fares enquiries
		// The context short list is the NLC codes of the stopping pattern

		pTask.trainStopsNLC = pJny.getStopsNLC(pJny);

		return;
	}

	public static void doGetRelatedEvents(AppContext pAC, Date pTime) {
		//
		// The operator can request a down load of journey and location related
		// data.
		// TODO This is a dummy routine
		//
		final String FUNC_NAME = "doGetRelatedEvents";
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, "", 0);

		if (activeDuty == null) {
			// Nothing to do
			return;
		}

		// TODO do this for real...
		ArrayList<DutyTask> listAssistPass = new ArrayList<DutyTask>();

		DutyTask taskAssist;
		for (DutyTask t : activeDuty.dutyActivities) {
			if (!t.taskType.equals("AP")) {
				listAssistPass.add(t);
			}
			if (t.taskState.ordinal() < TaskState.COMPLETE.ordinal()) {

				if (t.assistedPassengers) {
					t.assistPassChecked = DataConvert.getNow();
				}
			}
			DutyTaskType dutyTaskType = DutyTaskType.getTaskType(t.taskType);

			if ((t.taskState.ordinal() < TaskState.COMPLETE.ordinal())
					&& (dutyTaskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN)) {
				TTSearchCriteria TTCrit = pAC.ttSearch
						.setupDefaults(t.taskLocationFrom, t.taskLocationTo,
								t.taskStart, 0, 0);
				TTCrit.setSc_earlierjourneys(0);
				TTCrit.setSc_laterjourneys(1);
				TTCrit.setSc_numovertaken(0);
				SearchResponse resp = pAC.ttSearch.doSearch(TTCrit);
				if (resp.objTTsearchResults.getSr_numjourneys() > 0) {
					TTJourney jny = resp.objTTsearchResults.getSr_journeys()
							.get(0);
					TTLeg leg = jny.getJy_legs().get(0);
					if (leg.getPassstops().size() > 1) {
						TTStop stop = leg.getPassstops().get(0);

						taskAssist = new DutyTask();
						taskAssist.taskId = t.taskId + "-1";
						taskAssist.taskType = "AP";
						taskAssist.taskState = TaskState.TODO;

						taskAssist.taskStart = DataConvert.setTime(null,
								DataConvert.stringToInt(stop.getPse_arrives()
										.substring(0, 2)), DataConvert
										.stringToInt(stop.getPse_arrives()
												.substring(2, 4)), 0);
						taskAssist.taskEnd = taskAssist.taskStart;

						// "NLC|CRS|SIZE|DESCRIPTION"
						taskAssist.taskLocationFrom = Location
								.getLocationByCRS(stop.getPse_station());
						taskAssist.taskComment = "Passenger boarding";
						listAssistPass.add(taskAssist);

						stop = leg.getPassstops().get(1);

						taskAssist = new DutyTask();
						taskAssist.taskId = t.taskId + "-2";
						taskAssist.taskType = "AP";
						taskAssist.taskState = TaskState.TODO;

						taskAssist.taskStart = DataConvert.setTime(null,
								DataConvert.stringToInt(stop.getPse_arrives()
										.substring(0, 2)), DataConvert
										.stringToInt(stop.getPse_arrives()
												.substring(2, 4)), 0);
						taskAssist.taskEnd = taskAssist.taskStart;

						// "NLC|CRS|SIZE|DESCRIPTION"
						taskAssist.taskLocationFrom = Location
								.getLocationByCRS(stop.getPse_station());
						taskAssist.taskComment = "Passenger alighting";
						listAssistPass.add(taskAssist);

					}

				}

			}
		}
		activeDuty.dutyActivities = listAssistPass;

		activeDuty.updateTaskStates(pTime);

	}

	public static ArrayList<Duty> doSearchDuty(String pSearch) {
		//
		// Returns a filtered list of matching duties.
		// Match is either
		// ID starts with the string
		// or
		// Duty name contains the string
		//
		final String FUNC_NAME = "doSearchDuty";
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, pSearch, 0);

		ArrayList<Duty> myList = new ArrayList<Duty>();

		for (Duty duty : Duty.allDutys) {

			if (DataConvert.toUpperCase(duty.dutyId).startsWith(pSearch)) {
				myList.add(duty);
			} else if (DataConvert.toUpperCase(duty.dutyName).contains(pSearch)) {
				myList.add(duty);
			}

		}

		return myList;

	}

	public static ArrayList<DutyTaskType> doSearchTask(String pSearch) {
		//
		// Returns a filtered list of matching tasktypes.
		// Match is either
		// Code starts with the string
		// or
		// Title contains the string
		//
		final String FUNC_NAME = "doSearchTask";
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME,
				Category.ENTRY, pSearch, 0);

		ArrayList<DutyTaskType> myList = new ArrayList<DutyTaskType>();

		for (DutyTaskType dutyTaskType : DutyTaskType.dutyTaskTypes.values()) {

			if (DataConvert.toUpperCase(dutyTaskType.taskTypeCode).startsWith(
					pSearch)) {
				myList.add(dutyTaskType);
			} else if (DataConvert.toUpperCase(dutyTaskType.taskTypeTitle)
					.contains(pSearch)) {
				myList.add(dutyTaskType);
			}

		}

		return myList;

	}
}
