package com.example.twolibs.DutyBL;

import java.util.ArrayList;
import java.util.Date;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class DutyTask {
	//
	// This class contains an individual task that can make up a duty
	// 
	// For example 
	//	  Queuebusting at a barrier or working on a train?
	//    
	
	private static String CLASS_NAME = "DutyTask";  // Used for tracing
	
	public String taskId = "";				//Id for the specific task to support future logging of actions
	public String taskType = "";			//Lookup to the DutyTaskType for details
	public Date taskStart = DataConvert.DATENULL;			//Task start time
	public Date taskEnd = DataConvert.DATENULL;				//Task end time
	
	public TaskState taskState = TaskState.NOTE; //Current status of the task
	public boolean taskSelected = false;	//This task is the current selection
	
	public Location taskLocationFrom = null; //The location that the task starts to be used when from context required
	public Location taskLocationTo = null;	 //The location that the task end to be used when to context required
	public String taskComment = "";			// Descriptive or additional information for the operator
	
	// The following apply if there is an associated train
	public Date trainDepart = DataConvert.DATENULL;			// Train start time (which could be later than taskStart if delayed)
	public String trainRetailId = "";		// Train retail id
	public String trainHeadCode = "";		// TODO Train Headcode
	public ArrayList<String> trainStopsNLC = new ArrayList<String>(); 		// List of stopping points if on train 
	
	public boolean reservations = false;    
	public boolean assistedPassengers = true;
	public Date assistPassChecked = null;
	
	// TaskState represents the life cycle of a task
	// Note: The sequence of tasks is important as comparisons are made 
	public enum TaskState {
		TODO,		// Task is on the list of this to do today
		DUE, 		// The task is near to its start time and the operator needs to be warned
		ACTIVE, 	// The operator has acknowledge the task and is currently performing it
		COMPLETE, 	// The operator has marked the task as complete
		EXPIRED, 	// The task has gone past its end time without the operator acknowledging it
		NOTE;		// The task is for information only
		
		// This method is used to populated selection lists of the life cycle 
	    public static final String[] names=new String[values().length];
	    static {
	    	TaskState[] values=values();
	        for(int i=0;i<values.length;i++)
	            names[i]=values[i].name();
	    }

	}
	
	public String taskStateDesc (){
		
		return taskState.name();

	}
	
	// TODO sample XML?
	public static DutyTask fromXML(Node pNode){
		final String FUNC_NAME = "fromXML"; 
		//
		// Loads an instance from an XML stream
		//
		
		DutyTask task = new DutyTask();
		
		try {
			task.taskId = pNode.getAttributes().getNamedItem("taskId").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskId Parsing Exception = " + e.getMessage(), 0);
			// Error
			return null;
		}
	
		try {
			task.taskType = pNode.getAttributes().getNamedItem("taskType").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskType Parsing Exception = " + e.getMessage(), 0);
			// Error
			return null;
		}

		String taskTime;
		try {
			taskTime = pNode.getAttributes().getNamedItem("taskStart").getTextContent();
			task.taskStart = DataConvert.parseHHmmss(taskTime);
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskStart Parsing Exception = " + e.getMessage(), 0);
			// Error
			return null;
		}

		String location;
		try {
			location = pNode.getAttributes().getNamedItem("locationFrom").getTextContent();
			task.taskLocationFrom = Location.getLocationByNLC(location);
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML locationFrom Parsing Exception = " + e.getMessage(), 0);
			// Optional;
		}
		try {
			location = pNode.getAttributes().getNamedItem("locationTo").getTextContent();
			task.taskLocationTo = Location.getLocationByNLC(location);
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML locationTo Parsing Exception = " + e.getMessage(), 0);
			// Optional;
		}
		
		try {
			Element element = (Element) pNode;
			NodeList nodeList = element.getElementsByTagName("comment");
			task.taskComment = nodeList.item(0).getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML comment Parsing Exception = " + e.getMessage(), 0);
			// Optional;
		}
		
		//TODO do we want to load the initial state as well?
		task.taskState = TaskState.TODO;
		
		return task;
	}
}
