package com.example.twolibs.DutyBL;

import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.example.twolibs.DataTransferBL.DataTransferManager;
import com.example.twolibs.DataTransferBL.DataTransferManager.FileType;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.HashMapX;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

public class DutyTaskType {
	//
	// This class defines the type of tasks that can make up a duty
	// It also associates the behaviour of the different types of task
	//
	// For example 
	//	  Do we need to select a location or train associated with the task?
	//    
	
	private static String CLASS_NAME = "DutyTaskType";  // Used for tracing
	
	public enum TaskSpecialAction {
		BOARD_TRAIN, 
		QUEUE_BUST, 
		EXCESS_FARE, 
		NONE
	}
	
	// Map of all the task types that as supported, keyed on taskTypeCode
	public static HashMapX<String, DutyTaskType> dutyTaskTypes = new HashMapX<String, DutyTaskType>();
	public static DutyTaskType getTaskType(String pTaskTypeCode){
		// Method uses GetValue to aid Xamarin conversion
		DutyTaskType dutyTaskType = dutyTaskTypes.getValue(pTaskTypeCode);
		return dutyTaskType;
	}
	
	public String taskTypeCode = "";   // The short code, matches the import from the roster system
	public String taskTypeTitle = "";  // Human readable description
	public TaskSpecialAction taskSpecialAction = TaskSpecialAction.NONE;  // Behaviour associated with task 
	public int taskTypeNofify = 0;     // The number of minutes before the task that we need to notify the operator
	

	public static ArrayList<DutyTaskType> getTaskTypes(){
		final String FUNC_NAME = "getTaskTypes"; 
	   	
    	// 
    	// Return an arraylist containing the tasktypes 
    	// 
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
		ArrayList<DutyTaskType> taskTypeList = new ArrayList<DutyTaskType>();
		
		for(DutyTaskType taskType : dutyTaskTypes.values() ){
			taskTypeList.add(taskType);
		}
		
		return taskTypeList;
		
	}
	
    public static HashMapX<String, DutyTaskType> doLoadXML(){
		final String FUNC_NAME = "doLoadXML"; 
   	
    	// 
    	// Load a list of task types need to interpret supplied roster data
    	// 
		// 
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	    	
    	dutyTaskTypes = new HashMapX<String, DutyTaskType>();

 		DataTransferManager.STDDocumentResponse resp = DataTransferManager.getDocument(FileType.DUTYTASKTYPES);

	    if(resp.result == DutyManager.Response.OK){    
	    	try {
		
	    		NodeList nodeList = resp.doc.getElementsByTagName("dutytasktype");
	    		for (int i = 0; i < nodeList.getLength(); i++) {
	
	    			Node node = nodeList.item(i);
	     			DutyTaskType taskType = DutyTaskType.fromXML(node);
	     			if(taskType != null){
	     				dutyTaskTypes.put(taskType.taskTypeCode,taskType);
	     			}
	    		}
	    		
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "Loaded " + dutyTaskTypes.size(), 0);
	
			} catch (Exception e) {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.EXIT, "XML Pasing Exception = " + e, 0);
			}
	    	
		} else {
			
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.EXIT, "Document not loaded", 0);			
		}
	    	
    	return dutyTaskTypes;

    }
    
    
	public static DutyTaskType fromXML(Node pNode){
		final String FUNC_NAME = "fromXML"; 
		//
		// Loads an instance from an XML stream
		//
		
		DutyTaskType taskType = new DutyTaskType();
		
		try {
			taskType.taskTypeCode = pNode.getAttributes().getNamedItem("taskTypeCode").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskTypeCode Parsing Exception = " + e.getMessage(), 0);
			// Fail to parse this entry
			return null;
		}
		try {
			taskType.taskTypeTitle = pNode.getAttributes().getNamedItem("taskTypeTitle").getTextContent();
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskTypeTitle Parsing Excpetion = " + e.getMessage(), 0);
			// Default title to code
			taskType.taskTypeTitle = taskType.taskTypeCode;
		}
		// Decode the action from the XML 
		try {
			String notify = DataConvert.toUpperCase(pNode.getAttributes().getNamedItem("taskTypeAction").getTextContent());
			if(notify.equals(TaskSpecialAction.BOARD_TRAIN.name())){
				taskType.taskSpecialAction = TaskSpecialAction.BOARD_TRAIN;
			} else if(notify.equals(TaskSpecialAction.EXCESS_FARE.name())){
				taskType.taskSpecialAction = TaskSpecialAction.EXCESS_FARE;
			} else if(notify.equals(TaskSpecialAction.QUEUE_BUST.name())){
				taskType.taskSpecialAction = TaskSpecialAction.QUEUE_BUST;
			} else if(notify.equals(TaskSpecialAction.NONE.name())){
				taskType.taskSpecialAction = TaskSpecialAction.NONE;
			} else {
				TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
						Category.ENTRY, "XML taskTypeAction unknown = " + notify, 0);
			} 
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskTypeAction Parsing Excpetion = " + e.getMessage(), 0);
			// Default to 0
			taskType.taskTypeNofify = 0;
		}

		
		try {
			String notify = pNode.getAttributes().getNamedItem("taskTypeNofify").getTextContent();
			taskType.taskTypeNofify = DataConvert.stringToInt(notify);
		} catch (Exception e) {
			TraceHandler.Trace(TraceLevel.ERROR, CLASS_NAME, FUNC_NAME, 
					Category.ENTRY, "XML taskTypeNofify Parsing Excpetion = " + e.getMessage(), 0);
			// Default to 0
			taskType.taskTypeNofify = 0;
		}
	
		return taskType;
	}

}
