
package com.example.twolibs.DutyGUI;

import java.util.ArrayList;
import java.util.Locale;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.LocationGUI.LocationLookup.CallingContext;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;
import com.example.twolibs.TimeTableGUI.TimeTableCriteria;

import android.app.ActionBar;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;


public class DutyAdHoc extends ListActivity 
	{
	//
	// DutyAdHoc class is a GUI class to support the picking of adhoc duties
	// It displays the list of types of tasks and allows the operator to pick a task
	//	
	private static String CLASS_NAME = "DutyAdHoc";    // Used for tracing
	
	ArrayList<DutyTaskType> list = new ArrayList<DutyTaskType>(); // The list of tasks for a duty that are being displayed
	int iCurrentSelection = -1;							  		// The current selected task, -1 is none.
	DutyTaskType selTaskType = null;
	
	DutyTaskTypeListAdaptor adapter;						  	// Adapter to handle the list
	ListView listview;									  	// The view for the list

	// The CallContext is part of the data when calling other intents 
	// It enables the context to be determined when the call returns in onActivityResult
	// It should list all the called intents
	public enum CallContext {
		SELECT_TRAIN,	
		SELECT_ORIGIN,
		SELECT_DESTINATION;		
	}
			
		
		
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(savedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_duty_adhod);

        
        // Layout contains own action bar as we are using the area as a search input, so hide the default one
        ActionBar actionBar = getActionBar(); 
        actionBar.hide();
        
        // The BlackBoard is the base class, used to reference other managers
    	final AppContext bb  = (AppContext)getApplicationContext();
               
		// Setup the adapter        
        listview = (ListView) findViewById(android.R.id.list);
        adapter = new DutyTaskTypeListAdaptor(this,list);
        setListAdapter(adapter);

 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

	        @Override
	        public void onItemClick(AdapterView<?> parent, final View view,
	            int position, long id) {
				final String FUNC_NAME = "onItemClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "listview " + position, 0);
	 
	    	       	selTaskType =  list.get(position);
	    	       	
	    	       	// Special actions require additional data, so start the appropriate event
		       	if(selTaskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN){	
		        	Intent nextScreen = new Intent(getApplicationContext(), TimeTableCriteria.class);                   
		        	nextScreen.putExtra("nextAction", "");
		        	startActivityForResult(nextScreen, CallContext.SELECT_TRAIN.ordinal());
		        	
		       	} else if(selTaskType.taskSpecialAction == TaskSpecialAction.QUEUE_BUST){	
					Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);
					nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.FROM_SEARCH);
					nextScreen.putExtra(AppContext.CALL_CALLER, CLASS_NAME);
			        startActivityForResult(nextScreen,  CallContext.SELECT_ORIGIN.ordinal());
		       		
		       	} else if(selTaskType.taskSpecialAction == TaskSpecialAction.EXCESS_FARE){	
					Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);
					nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.TO_SEARCH);
					nextScreen.putExtra(AppContext.CALL_CALLER, CLASS_NAME);
			        startActivityForResult(nextScreen, CallContext.SELECT_DESTINATION.ordinal());
		       		
		       	} else {
		       	
		       		// No special action so just setup the selected task and return
		         	DutyManager.setupAdHocDuty(bb, selTaskType.taskTypeCode, bb.getSearchDate(), bb.getOrigin(), bb.getDestination(), bb.selJourney);
	    	       	Intent returnIntent = new Intent();
	               	//returnIntent.putExtra("result",list.get(position));
	               	setResult(RESULT_OK,returnIntent);
	               	finish();           	
		       	}
	        }
	
	    });
	        
	    // Search for the matching task types
	    doSearch();
	
	    LinearLayout frmTitle = (LinearLayout)findViewById(R.id.frmTitle);
	    frmTitle.setOnClickListener(new OnClickListener() {  
			
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "frmTitle", 0);
				
				// This code forces a key back event
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN,	KeyEvent.KEYCODE_BACK));
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
			}  
			
		
		}); 
	   
	    EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
	    txtSearch.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
				final String FUNC_NAME = "afterTextChanged"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "txtSearch " + s, 0);
	        	
				doSearch();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
	    
	    // Force the keyboard to be displayed for selection
	    txtSearch.requestFocus();               
    }
    
    public void doSearch(){
		final String FUNC_NAME = "doSearch"; 	   			
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	//
		//	Routine to call the search to filer the task types based on the input string
    	//
		
		// Get the search string
     	EditText et = (EditText) findViewById(R.id.txtSearch);
        String search = DataConvert.toUpperCase(et.getText().toString());
 	    
        // Call the manager to do the search
        ArrayList<DutyTaskType> myList = DutyManager.doSearchTask(search);
        
    	// Reset the display list now that the contents may have changed 
        adapter.clear();
        adapter.addAll(myList);
        adapter.notifyDataSetChanged();
    	
    }

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
     	AppContext bb  = (AppContext)getApplicationContext();
		final String FUNC_NAME = "onActivityResult"; 	
		
		//
		// This routine handles the return from called intents
		// If a selection has been made then create the ad hoc duty with a task
		// The details come from the selectedTaskType and the returned data
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "Request " + requestCode + " Result " + resultCode, 0);
		
	    if (requestCode == CallContext.SELECT_ORIGIN.ordinal()) {
	        if(resultCode == RESULT_OK){
	        	Location origin = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);
	         	DutyManager.setupAdHocDuty(bb, selTaskType.taskTypeCode, bb.getSearchDate(), origin, new Location(), bb.selJourney);
	            
	        }
	        if (resultCode == RESULT_CANCELED) {
	            //No change required
	        }
	        
	    }
	    if (requestCode == CallContext.SELECT_DESTINATION.ordinal()) {
	        if(resultCode == RESULT_OK){
	        	Location destination = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);
	         	DutyManager.setupAdHocDuty(bb, selTaskType.taskTypeCode, bb.getSearchDate(), destination, new Location(), bb.selJourney);
	            
	        }
	        if (resultCode == RESULT_CANCELED) {
	            //No change required
		        }
	    }
	    
	    if (requestCode == CallContext.SELECT_TRAIN.ordinal()){
	        if(resultCode == RESULT_OK){
	         	DutyManager.setupAdHocDuty(bb, selTaskType.taskTypeCode, bb.getSearchDate(), bb.getOrigin(), bb.getDestination(), bb.selJourney);
	        }
	        
	        if (resultCode == RESULT_CANCELED) {
	            //No change required
	        }
	    }
	    
	    
	    // Now return and it should all have been setup and ready to display
       	Intent returnIntent = new Intent();
       	setResult(RESULT_OK,returnIntent);
       	finish();           	

	}

    @Override
    public Intent getParentActivityIntent() {
		final String FUNC_NAME = "getParentActivityIntent"; 			
		//
		// This routine handles a back request
		// 
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, FUNC_NAME, 0);

    	Intent newIntent = null;
    	newIntent = new Intent(getApplicationContext(), DutyMain.class); 
          
        return newIntent;
          
    }
    
	    


}