package com.example.twolibs.DutyGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.DutyBL.Duty;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class DutyListAdaptor extends ArrayAdapter<Duty> {
	//
	// DutyListAdaptor class is a GUI class to support the display of an array of Duties)
	//	
	private static String CLASS_NAME = "DutyListAdaptor";    // Used for tracing
	
	private final Activity context;
	private final ArrayList<Duty> dutyList;
	
	// The view holder holds the GUI handles to the occurancies of the objects that are in view
	// The rest of the list will not have associated GUI objects.
	// This is done to improve the performance by minimising the use of findViewById
	
	static class ViewHolder {
		public TextView txtDescription;
	}
	
		
	public DutyListAdaptor(Activity pContext,ArrayList<Duty> pDutyList) {
		//
		// Connect the list to the adaptor an d store the context
		// (Often needed for detailed manipulation - In this case it is not yet used
		//
		super(pContext, R.layout.duty_summary, pDutyList);
		this.context = pContext;
		this.dutyList = pDutyList;
	}
		
	@Override
	public View getView(int pPosition, View pRowView, ViewGroup pParent) {
		//
		// getView is called to update an entry in the list when it is displayed/re-displayed
		//
		View rowView = pRowView;
		
		// reuse views
		if (rowView == null) {
			// First time through
			LayoutInflater inflater = context.getLayoutInflater();
			rowView = inflater.inflate(R.layout.duty_summary, null);
			
			// configure view holder
			ViewHolder viewHolder = new ViewHolder();
			viewHolder.txtDescription = (TextView) rowView.findViewById(R.id.txtDescription);
			rowView.setTag(viewHolder);
		}
		
		// Get the GUI handles for the row
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	    // Get the row in the data array that corresponds to the row being displayed
		Duty d = dutyList.get(pPosition);
		
		// Set the individual GUI objects from the row data
		holder.txtDescription.setText(d.dutyId + " " + d.dutyName);		
		
		return rowView;
	}
  
}
