
package com.example.twolibs.DutyGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyBL.Duty;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.MenuGUI.MenuTop;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.view.View;
import android.view.View.OnClickListener;


public class DutyMain extends ListActivity {
	//
	// DutyMain class is a GUI class to support the picking and changing of duties
	// It displays the current duty and the tasks that make up the duty
	//	
	private static String CLASS_NAME = "DutyMain";    // Used for tracing
	
	ArrayList<DutyTask> list = new ArrayList<DutyTask>(); // The list of tasks for a duty that are being displayed
	int iCurrentSelection = -1;							  // The current selected task, -1 is none.
	
	DutyTaskListAdaptor adapter;						  // Adapter to handle the list
	ListView listview;									  // The view for the list

	// The CallContext is part of the data when calling other intents 
	// It enables the context to be determined when the call returns in onActivityResult
	// It should list all the called intents
	public enum CallContext {
		SELECT_DUTY,	
		ADHOC;		
	}

    @Override
    public void onCreate(Bundle pSavedInstanceState)
    {
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(pSavedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_duty_main);
        
        // Set the title of this screen
		setTitle(" Duty");

        // The BlackBoard is the base class, used to reference other managers
    	final AppContext ac  = (AppContext)getApplicationContext();
    	
        // Ensure that the associated manager is initialised
		DutyManager.refreshdata();
        
		// Setup the adapter
        listview = (ListView) findViewById(android.R.id.list);
        adapter = new DutyTaskListAdaptor(this,list,ac);
        setListAdapter(adapter);

        // Duty - selects from an existing list
		LinearLayout cmdDuty = (LinearLayout) findViewById(R.id.frmDuty); 
		cmdDuty.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "frmDuty", 0);
				
				Intent nextScreen = new Intent(getApplicationContext(), DutySelect.class);			
			    startActivityForResult(nextScreen, CallContext.SELECT_DUTY.ordinal());
			}  
			
		
		});

        // Duty - selects from an existing list
		Button cmdSelectExisting = (Button) findViewById(R.id.cmdSelectExisting); 
		cmdSelectExisting.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdSelectExisting", 0);
				
				Intent nextScreen = new Intent(getApplicationContext(), DutySelect.class);
			    startActivityForResult(nextScreen, CallContext.SELECT_DUTY.ordinal());
			}  
			
		
		});

        // AdHoc - creates an AdHoc duty with one task
		Button cmdAdHoc = (Button) findViewById(R.id.cmdAdHoc); 
		cmdAdHoc.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdAdHoc", 0);
		
				Intent nextScreen = new Intent(getApplicationContext(), DutyAdHoc.class);
			    startActivityForResult(nextScreen, CallContext.ADHOC.ordinal());
			}  
			
		
		});
		
		// 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
				final String FUNC_NAME = "onItemClick"; 	
				
				//
				// This routine handles the emphasis of the selected item
				// and initiates any business activity
				//
				
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "listview " + position, 0);
           	
                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	View rowView = (View) parent.getChildAt(j);
                	rowView.setBackgroundColor(Color.TRANSPARENT);
                 }

                // Toggle the selection
                if (position == iCurrentSelection){
                    // De-select item
                    iCurrentSelection = -1;
                    list.get(position).taskSelected = false;    
                    
            	} else {
            		// Select item
                     iCurrentSelection = position;
                    list.get(position).taskSelected = true;
           		
                }
 
            }

          });

        // GetData - gets data that is related to the selected duty
		Button cmdGetData = (Button) findViewById(R.id.cmdGetData); 
		cmdGetData.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdGetData", 0);
				
		    	if(DutyManager.activeDuty != null){
		    		// Find the related events
			    	DutyManager.doGetRelatedEvents(ac, DataConvert.getNow()); 	
			    	
			    	// Reset the display list now that the contents may have changed 
			        adapter.clear();
			        adapter.addAll(DutyManager.activeDuty.dutyActivities);
			        adapter.notifyDataSetChanged();
		    	}	
			}  
			
		
		});
		

	    // Done - return to menu
		Button cmdDone = (Button) findViewById(R.id.cmdDone); 
		cmdDone.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "cmdDone", 0);
		
              	Intent returnIntent = new Intent();
                setResult(RESULT_OK,returnIntent);
               	finish();           	
			}  
			
		
		});
		
		// Final checks on the screen 
        doCheckComplete();

    }
 
	@Override
	protected void onActivityResult(int pRequestCode, int pResultCode, Intent pData) {
		final String FUNC_NAME = "onActivityResult"; 	
		
		//
		// This routine handles the return from called intents
		//

	    if (pRequestCode == CallContext.SELECT_DUTY.ordinal()) {
	    	// Duty lookup
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.GUI, "Result " + pResultCode, 0);

	    } else if (pRequestCode == CallContext.ADHOC.ordinal()) {
	    	// AdHoc lookup    
			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
					Category.GUI, "Result " + pResultCode, 0);
	    }

		// Final checks on the screen 	    
	    doCheckComplete();		    

	}

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}
	
	
    void doCheckComplete(){
		final String FUNC_NAME = "doCheckComplete"; 			
		//
		// This routine handles the return from called intents
		//
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);
		
 	    TextView txtDuty = (TextView) findViewById(R.id.txtDuty);
  	    String strDuty = (String) txtDuty.getText();
  	    
  	    // Set up the list of tasks
        if(DutyManager.activeDuty == null){
        	strDuty = "None";
	  	    list = new ArrayList<DutyTask>();
        } else {
        	strDuty = DutyManager.activeDuty.dutyName;
        	list = DutyManager.activeDuty.dutyActivities;
        	
        	// Update the status to reflect current time
        	DutyManager.activeDuty.updateTaskStates(DataConvert.getNow());
            if(Duty.firstIndex >= 0){
            	getListView().setSelection(Duty.firstIndex);
            }

        }
  	    txtDuty.setText(strDuty);
    
  	    // GetData button is only enabled when a duty has been selected
        Button cmdGetData = (Button) findViewById(R.id.cmdGetData);        	
    	if(strDuty.equals("None")){
    		cmdGetData.setEnabled(false);
    		cmdGetData.setBackgroundColor(JMgetColor(R.color.button_background_disabled, getTheme()));
    	} else {
    		cmdGetData.setEnabled(true);
    		cmdGetData.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
    	}
    	
    	// Reset the display list now that the contents may have changed 
        adapter.clear();
        adapter.addAll(list);
        adapter.notifyDataSetChanged();
        
    }

    @Override
    public Intent getParentActivityIntent() {
		final String FUNC_NAME = "getParentActivityIntent"; 			
		//
		// This routine handles a back request
		// cmdOptionF1.setBackgroundColor(
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);

    	Intent newIntent = null;
    	newIntent = new Intent(getApplicationContext(), MenuTop.class); 
          
        return newIntent;
          
     }
    


}