
package com.example.twolibs.DutyGUI;

import java.util.ArrayList;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyBL.Duty;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import android.app.ActionBar;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;


public class DutySelect extends ListActivity 
	{
	//
	// DutySelect class is a GUI class to support the picking of adhoc duties
	// It displays the list of types of tasks and allows the operator to pick a task
	//	
	private static String CLASS_NAME = "DutySelect";    // Used for tracing
	
	ArrayList<Duty> list = new ArrayList<Duty>(); 		// The list of tasks for a duty that are being displayed
	int iCurrentSelection = -1;							// The current selected task, -1 is none.
	DutyTaskType selTaskType = null;
	
	DutyListAdaptor adapter;						  	// Adapter to handle the list
	ListView listview;									// The view for the list

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
    	// 
    	// Creation routine called when the view is first created
    	//
        super.onCreate(savedInstanceState);
        
        // Associate the layout
        setContentView(R.layout.activity_duty_select);

        
        // Layout contains own action bar as we are using the area as a search input, so hide the default one
        ActionBar actionBar = getActionBar(); 
        actionBar.hide();
        
        // The BlackBoard is the base class, used to reference other managers
    	final AppContext bb  = (AppContext)getApplicationContext();
               
		// Setup the adapter        
        listview = (ListView) findViewById(android.R.id.list);
        adapter = new DutyListAdaptor(this,list);
        setListAdapter(adapter);
	
	 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
    			final String FUNC_NAME = "onItemClick"; 	   			
    			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
    					Category.GUI, "listview " + position, 0);

    			// Operator has selected a duty
    			// Make it current and return
    			
    			DutyManager.setDuty(bb, list.get(position));
    	        
              	Intent returnIntent = new Intent();
               	setResult(RESULT_OK,returnIntent);
               	finish();           	
 
            }

        });
	        
	    // Search for the matching task types
	    doSearch();
	
	    LinearLayout frmTitle = (LinearLayout)findViewById(R.id.frmTitle);
	    frmTitle.setOnClickListener(new OnClickListener() {  
			
			public void onClick(View view) {  
				final String FUNC_NAME = "onClick"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "frmTitle", 0);
				
				// This code forces a key back event
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN,	KeyEvent.KEYCODE_BACK));
				dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
			}  
			
		
		}); 
	   
	    EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
	    txtSearch.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
				final String FUNC_NAME = "afterTextChanged"; 	   			
				TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
						Category.GUI, "txtSearch " + s, 0);
	        	
				doSearch();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
	    
	    // Force the keyboard to be displayed for selection
	    txtSearch.requestFocus();  	            

    }
	    
    public void doSearch(){
		final String FUNC_NAME = "doSearch"; 	   			
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.ENTRY, "", 0);
    	//
		//	Routine to call the search to filer the task types based on the input string
    	//
		
		// Get the search string
     	EditText et = (EditText) findViewById(R.id.txtSearch);
        String search = DataConvert.toUpperCase(et.getText().toString());
 	         
        // Call the manager to do the search
        ArrayList<Duty> myList= DutyManager.doSearchDuty(search);
        
    	// Reset the display list now that the contents may have changed 
	    adapter.clear();
	    adapter.addAll(myList);
	    adapter.notifyDataSetChanged();
		
	}
	
	
	@Override
	public Intent getParentActivityIntent() {
		final String FUNC_NAME = "getParentActivityIntent"; 			
		//
		// This routine handles a back request
		// 
		
		TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
				Category.GUI, "", 0);
	
		Intent newIntent = null;
		newIntent = new Intent(getApplicationContext(), DutyMain.class); 
	      
	    return newIntent;
	      
	}



}