package com.example.twolibs.DutyGUI;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.example.twolibs.AppContext;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTask;
import com.example.twolibs.DutyBL.DutyTask.TaskState;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.R;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.TraceHandler;
import com.example.twolibs.SupportBL.TraceHandler.Category;
import com.example.twolibs.SupportBL.TraceHandler.TraceLevel;

import java.util.ArrayList;

public class DutyTaskListAdaptor extends ArrayAdapter<DutyTask> {
	//
	// DutyTaskListAdaptor class is a GUI class to support the display of an array of DutyTasks
	//	
	private static String CLASS_NAME = "DutyTaskListAdaptor";    // Used for tracing
	
	private final Activity context;
	private final AppContext bb;
	private final ArrayList<DutyTask> dutyTaskList;
	
	
	// The view holder holds the GUI handles to the occurancies of the objects that are in view
	// The rest of the list will not have associated GUI objects.
	// This is done to improve the performance by minimising the use of findViewById
	static class ViewHolder {
		public LinearLayout lay_entry;
	}
		
	public DutyTaskListAdaptor(Activity pContext,ArrayList<DutyTask> pDutyTaskList,AppContext pBB) {
		//
		// Connect the list to the adaptor an d store the context
		// (Often needed for detailed manipulation - In this case it is not yet used)
		//
		super(pContext, R.layout.dutytask_entry, pDutyTaskList);
		this.context = pContext;
		this.bb = pBB;
		this.dutyTaskList = pDutyTaskList;
	}
		
	@Override
	public View getView(int pPosition, View pRowView, ViewGroup pParent) {
		//
		// getView is called to update an entry in the list when it is displayed/re-displayed
		//
		View rowView = pRowView;
	    LayoutInflater inflater = context.getLayoutInflater();

	    // reuse views
		if (rowView == null) {
			// First time through
			
		      rowView = inflater.inflate(R.layout.dutytask_entry, null);
		      // configure view holder
		      ViewHolder viewHolder = new ViewHolder();
		      viewHolder.lay_entry = (LinearLayout) rowView.findViewById(R.id.lay_entry);
		      rowView.setTag(viewHolder);
		}
		
		
		// Get the GUI handles for the row
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);


	    // Get the row in the data array that corresponds to the row being displayed
	    DutyTask d = dutyTaskList.get(pPosition);
	    DutyTaskType dtt = DutyTaskType.getTaskType(d.taskType);
	    
	    // Part of the layout varies between the type of object to display
	    // so we need to remove the existing and recreate it according to the type
	    holder.lay_entry.removeAllViews();
	    
	    // Setup the correct layout data and content
	    if(dtt.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN){
	    	displayTrain(holder,inflater,rowView,d);
	    } else {
	    	displayStatic(holder,inflater,rowView,d);
	    }

	    // The rows have additional functionality when clicked
	    // so we need to setup a listener
    	holder.lay_entry.setOnClickListener(mOnTaskStateClickListener);
    	
    	// Set the background of the row to show if it is selected
    	TextView txtDutyState = (TextView) rowView.findViewById(R.id.txtDutyState);
	    if(d.taskSelected){
	    	txtDutyState.setEnabled(true);
	    	txtDutyState.setTextColor(JMgetColor(R.color.button_text, context.getTheme()));
	    	txtDutyState.setBackgroundColor(JMgetColor(R.color.button_background, context.getTheme()));
	    } else {
	    	txtDutyState.setEnabled(false);
	    	txtDutyState.setTextColor(JMgetColor(R.color.edit_text, context.getTheme()));
	    	txtDutyState.setBackgroundColor(Color.TRANSPARENT);
	    }
    
		return rowView;
	}

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (context.getResources().getColor(Color, TH));
		}else{
			return (context.getResources().getColor(Color));
		}
	}

	private void displayStatic(ViewHolder pHolder, LayoutInflater pInflater, View pRowView, DutyTask pTask){
		// Setup the layout for a row that has no associated journey data
			  
		pHolder.lay_entry.addView(pInflater.inflate(R.layout.duty_static_entry, null));
		
		// Get the GUI object handles
		TextView txtStartTime = (TextView) pRowView.findViewById(R.id.txtStartTime);
		TextView txtComment = (TextView) pRowView.findViewById(R.id.txtComment);
		TextView txtCRS = (TextView) pRowView.findViewById(R.id.txtCRS);
		TextView txtLocation = (TextView) pRowView.findViewById(R.id.txtLocation);
		TextView txtDutyState = (TextView) pRowView.findViewById(R.id.txtDutyState);

		// Setup the data
		txtStartTime.setText(DataConvert.displayTextTime(pTask.taskStart));
		txtComment.setText(pTask.taskComment);
		txtCRS.setText(pTask.taskLocationFrom.getCRS());
		txtLocation.setText(pTask.taskLocationFrom.getDescription());
		txtDutyState.setText(pTask.taskStateDesc());
		
		// Colour the background according to the status of the task
		if(pTask.taskState == TaskState.DUE){
			pHolder.lay_entry.setBackgroundColor(JMgetColor(R.color.icon_background_active, context.getTheme()));
		} else if(pTask.taskState == TaskState.ACTIVE){
			pHolder.lay_entry.setBackgroundColor(JMgetColor(R.color.icon_background_good, context.getTheme()));
		} else {
			pHolder.lay_entry.setBackgroundColor(Color.TRANSPARENT);		
		}
	}



	private void displayTrain(ViewHolder pHolder, LayoutInflater pInflater, View pRowView, DutyTask pTask){
		// Setup the layout for a row that has an associated journey data
		  
		pHolder.lay_entry.addView(pInflater.inflate(R.layout.duty_train_entry, null));
			
		// Get the GUI object handles
		TextView txtStartTime = (TextView) pRowView.findViewById(R.id.txtStartTime);
		TextView txtComment = (TextView) pRowView.findViewById(R.id.txtComment);
		TextView txtFromCRS = (TextView) pRowView.findViewById(R.id.txtFromCRS);
		TextView txtFromLocation = (TextView) pRowView.findViewById(R.id.txtFromLocation);
		TextView txtToCRS = (TextView) pRowView.findViewById(R.id.txtToCRS);
		TextView txtToLocation = (TextView) pRowView.findViewById(R.id.txtToLocation);
		TextView txtTrainID = (TextView) pRowView.findViewById(R.id.txtTrainID);
		TextView txtDeptTime = (TextView) pRowView.findViewById(R.id.txtDeptTime);
		TextView txtReservations = (TextView) pRowView.findViewById(R.id.txtReservations);
		TextView txtReservationsChecked = (TextView) pRowView.findViewById(R.id.txtReservationsChecked);
		TextView txtAssistPass = (TextView) pRowView.findViewById(R.id.txtAssistPass);
		TextView txtAssistPassChecked = (TextView) pRowView.findViewById(R.id.txtAssistPassChecked);
		TextView txtDutyState = (TextView) pRowView.findViewById(R.id.txtDutyState);

		// Setup the data
		txtStartTime.setText(DataConvert.displayTextTime(pTask.taskStart));
		txtComment.setText(pTask.taskComment);
		txtDeptTime.setText("(" + DataConvert.displayTextTime(pTask.trainDepart) + " " + pTask.trainHeadCode +  ")");
		txtFromCRS.setText(pTask.taskLocationFrom.getCRS());
		txtFromLocation.setText(pTask.taskLocationFrom.getDescription());
		txtToCRS.setText(pTask.taskLocationTo.getCRS());
		txtToLocation.setText(pTask.taskLocationTo.getDescription());
		txtTrainID.setText(pTask.trainRetailId + " to ");
		if(pTask.reservations){
			txtReservations.setText("Reservations");
		} else {
			txtReservations.setText("Not reservable");
		}
		if(pTask.assistedPassengers){
			txtAssistPass.setText("Check Assisted Passengers");
		} else {
			txtAssistPass.setText("");
		}
		if(pTask.assistPassChecked != null){
			txtAssistPass.setText("Assist Pass checked");
			txtAssistPassChecked.setText(DataConvert.displayTextTime(pTask.assistPassChecked));
		} else {
			txtAssistPassChecked.setText("");
		}
		txtDutyState.setText(pTask.taskStateDesc());
		
		// Colour the background according to the status of the task
		if(pTask.taskState == TaskState.DUE){
			pHolder.lay_entry.setBackgroundColor(JMgetColor(R.color.icon_background_active, context.getTheme()));
		} else if(pTask.taskState == TaskState.ACTIVE){
			pHolder.lay_entry.setBackgroundColor(JMgetColor(R.color.icon_background_good, context.getTheme()));
		} else {
			pHolder.lay_entry.setBackgroundColor(Color.TRANSPARENT);		
		}
		
	}
	private OnClickListener mOnTaskStateClickListener = new OnClickListener() {
        @Override
        public void onClick(View pView) {
        	// When clicked allow operator to change the task state
          	RelativeLayout row_container = (RelativeLayout) pView.getParent();
           	
            ListView parent = (ListView) row_container.getParent();
            int position = parent.getPositionForView(pView);
	        final DutyTask task = dutyTaskList.get(position);

	        // Check that a row with data has been clicked 
  	        if (position != ListView.INVALID_POSITION) {
	        	
			    // Alert box with choices   
			    AlertDialog.Builder listBuilder = new AlertDialog.Builder(context);
			    
			    // Choices is the list of states
			    // TODO Should we allow all the transitions...
			    listBuilder.setTitle("Task state");
			    
			    // 
			    listBuilder.setItems(TaskState.names, new DialogInterface.OnClickListener() {
			    	
				       public void onClick(DialogInterface dialog, int item) {
			    			final String FUNC_NAME = "onClick"; 
			    			// Trace what was selected
			    			TraceHandler.Trace(TraceLevel.DEBUG, CLASS_NAME, FUNC_NAME, 
			    					Category.GUI, "list " + TaskState.values()[item].name(), 0);
			    			
				    	   // Respond to a selection of a choice
				    	   DutyManager.setTaskState(bb, task,TaskState.values()[item]);
				    	   
				    	   // Force update of display to show the new state
					       notifyDataSetChanged();
					    	
				       }
				});
		    
		    	// Show the choice
			    AlertDialog alertList = listBuilder.create();
			    alertList.show();    	               
	
			}  
        
        }
         	
    };
	
}
