package com.example.twolibs.DutyGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.DutyBL.DutyTaskType;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class DutyTaskTypeListAdaptor extends ArrayAdapter<DutyTaskType> {
	private final Activity context;
	private final ArrayList<DutyTaskType> dutyList;
	
	
	static class ViewHolder {
		public TextView txtDescription;
	}
		
	public DutyTaskTypeListAdaptor(Activity context,ArrayList<DutyTaskType> dutyList) {
		//Own summary layout for dutyTaskType
		super(context, R.layout.duty_summary, dutyList);
		this.context = context;
		this.dutyList = dutyList;
	}
		
		  @Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View rowView = convertView;
		// reuse views
		if (rowView == null) {
			LayoutInflater inflater = context.getLayoutInflater();
			rowView = inflater.inflate(R.layout.duty_summary, null);
			// configure view holder
			ViewHolder viewHolder = new ViewHolder();
			viewHolder.txtDescription = (TextView) rowView.findViewById(R.id.txtDescription);
			rowView.setTag(viewHolder);
		}
		
		// fill data
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	    DutyTaskType d = dutyList.get(position);
		holder.txtDescription.setText(d.taskTypeCode + " " + d.taskTypeTitle);
		
		
		return rowView;
	}
  
}
