package com.example.twolibs.FaresBL;

import java.util.ArrayList;
import java.util.Date;

import android.os.Environment;
import android.util.Log;





//import com.example.twolibs.AppContext;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportBL.HashMapX;


public class FareManager {
	
	public static HashMapX<String, TicketDetails> ticketCodes = new HashMapX<String, TicketDetails>();
	private static TicketDetails ticketDetails = new TicketDetails();
	
	public ArrayList<TNFare> historicFares = new ArrayList<TNFare>();
	

	public class STDResponse  {
		public int result = 0;
		public String extra = "";
		public String trace = "";
	}
	
	public static void init() {
		//System.loadLibrary("twolib-second");
	}
	
	
	public class SearchResponse extends STDResponse {
		public ArrayList<TNFare> fares = new ArrayList<TNFare>();
	}


    public FareManager.STDResponse doLoad(String fibFile){
    	
		STDResponse resp = new STDResponse();
		resp.result = -1;
		resp.trace = "Begin";
        
        byte[] bTrace;
        int iTraceSize=10000;
        bTrace = StringToCBuff(iTraceSize,"");
        
        resp.result = loadFib(fibFile,bTrace);
 
        resp.extra = fibFile + " " + resp.result + " ";
        resp.trace = CBuffToString(iTraceSize,bTrace);  
        
        return resp;        
    	
    }
    
    public FareManager.STDResponse doLoad2(String fibFile, String traceFile){
    	
		STDResponse resp = new STDResponse();
		resp.result = -1;
		resp.trace = "Begin";
        
        byte[] bTrace;
        int iTraceSize=10000;
        bTrace = StringToCBuff(iTraceSize,"");
        
        resp.result = loadFib2(fibFile,bTrace,traceFile);
 
        resp.extra = fibFile + " " + resp.result + " ";
        resp.trace = CBuffToString(iTraceSize,bTrace);  
        
        return resp;        
    	
    }   
    public void addHistoricFare(TNFare fare){
    	
    	int i = historicFares.size();
    	ArrayList<TNFare> revisedFares = new ArrayList<TNFare>();
   	
    	revisedFares.add(fare);
    	for (i=0; i<historicFares.size(); i++){
    		TNFare histFare = historicFares.get(i);
    		if(histFare.getFa_FareDestinationLocation().equals(fare.getFa_FareDestinationLocation()) &&
    				histFare.getFa_FareOriginLocation().equals(fare.getFa_FareOriginLocation()) &&
    				histFare.getFa_TicketTypeCode().equals(fare.getFa_TicketTypeCode()) &&
    				histFare.getFa_RouteCode().equals(fare.getFa_RouteCode()) &&
       				(histFare.getFa_NumAdults() == fare.getFa_NumAdults()) &&
       				(histFare.getFa_NumChildren() == fare.getFa_NumChildren()) &&
       				(histFare.getFa_NumAAA() == fare.getFa_NumAAA()) &&
    				histFare.getFa_FareDate().equals(fare.getFa_FareDate())
    				){
    				// matched
    		} else {
    			revisedFares.add(histFare);
    		}
    	}
    	historicFares = revisedFares;
    }
   
	private static String CBuffToString(int iSize, byte[] bInput ){
		StringBuilder sNew = new StringBuilder(iSize);
		
        char ch;
        for(int i = 0; i < iSize; i=i+1){
        	if( bInput[i] == 0 ){
        		break;
        	}
        	ch = (char)bInput[i];
        	sNew.append( ch);
        }
		
		return sNew.toString();
	}

    private static byte[] StringToCBuff(int iSize, String sInput ){
    	byte[] bNewBuffer;
    	
    	bNewBuffer = new byte[iSize];
    	int l = sInput.length();
    	if (l > iSize){
    		l = iSize;
    	}
    	
    	if (l>0){
    		// Copy the string into the buffer
    		int i;
	    	for(i=0; i<l; i++){
	    		bNewBuffer[i] = (byte) sInput.charAt(i);
	    		
	    	}
	    	// Add a null to terminate for C
	    	if (i>=l){
	    		bNewBuffer[l-1]=0;
	    	} else {
	    		bNewBuffer[i]=0;
	    	} 	
	    	
    	}
    	
    	return bNewBuffer;
    }
    
    
    public SearchResponse doSearch(TNSearchCriteria TNCrit, int faresClass, boolean showAll) {
    	
    	SearchResponse resp = new SearchResponse();
		resp.result = -1;
		resp.trace = "Begin";
        
        ArrayList<TNFare> resList = new ArrayList<TNFare>();
    	        
     	TNSearchResults objTNSearchResults = new TNSearchResults();
   	
        String outDate;
        outDate = DataConvert.displayyyyyMMddHHmm(TNCrit.OutDateTime);
        String retDate;
        if (TNCrit.ReturnDateTime == null){
        	retDate = "000000000000";
        } else {
            retDate = DataConvert.displayyyyyMMddHHmm(TNCrit.ReturnDateTime);              			
        }

        //TNCrit.RailcardCode = "YNG";
			
     
     	objTNSearchResults = faresSearch(TNCrit.OriginUIC, TNCrit.DestinationUIC,
     	
				outDate, 
				retDate, 
				DataConvert.displayyyyyMMddHHmm(TNCrit.CurrentDateTime),
	    		TNCrit.NumAdults, TNCrit.NumChildren,	TNCrit.NumAAA,
	    		TNCrit.RailcardCode, 
	    		TNCrit.VariableDiscount,TNCrit.UseFutureFares,
	    		TNCrit.TicketCode,TNCrit.RouteCode);
	    /*		
        int SeasonMonths =0;
        int SeasonDays = 7;
     	objTNSearchResults = seasonFaresSearch(TNCrit.OriginUIC, TNCrit.DestinationUIC,
				outDate, 
				DataConvert.displayyyyyMMddHHmm(TNCrit.CurrentDateTime),
	    		TNCrit.NumAdults, TNCrit.NumChildren,	
	    		TNCrit.RailcardCode, 
	    		TNCrit.VariableDiscount, SeasonMonths,  SeasonDays,
	    		TNCrit.TicketCode,TNCrit.RouteCode);
     	*/
     	
     	resp.result = objTNSearchResults.getTn_ErrorCode();
     	if((objTNSearchResults.getTn_ErrorCode() != 0) && (objTNSearchResults.getTn_ErrorCode() != 1)){
     		resp.trace =    "Error " + objTNSearchResults.getTn_ErrorCode() + " ";
     		return resp;
     	} else {
     		resp.trace = "Returned " +  objTNSearchResults.getTn_NumIJQFares();
     	}
     	
       int result = 0;
       FIBQueryResults FIBqr; 
       TNJFLRestrictionResult outRR;
       TNJFLRestrictionResult retRR;
       TNFareValidityResult fvr;
       
        for(int i=0; i< objTNSearchResults.getTn_NumIJQFares(); i++){
        	TNFare tnf = objTNSearchResults.getTn_IJQFares().get(i);
        	if(i< objTNSearchResults.getTn_NumJFL())
        	{
	        	TNJourneyFareLink jfl = objTNSearchResults.getTn_JourneyFareLinks().get(i); //TODO proper matching of link to fare
	
	        	 outRR = jfl.getJfl_OutRestrictionResult();
	        	 retRR = jfl.getJfl_RetRestrictionResult();
	           	 fvr = jfl.getJfl_FareValidityResult();
        	}
        	else
        	{
	        	 outRR = null;
	        	 retRR = null;
	           	 fvr = null;
     		
        	}
        	
           	// Lookup ticket data

           	TicketDetails tkt;
           	
           	Log.e("fares", "Ticket!"+ tnf.getFa_TicketTypeCode() + "!" + tnf.getFa_FareDate());
           	
           	String txtTicketCode = tnf.getFa_TicketTypeCode();
           	tkt = loadTicket(txtTicketCode,tnf.getFa_FareDateDt());
          	// Setup whether to display this fare
           	
           	tnf.setFa_NoSaleReason(tkt.NoSaleReason("00009")); // CCST = "00009"
           	if((tnf.getFa_NoSaleReason().length()==0) && (outRR != null)){
//           		if(fvr.getFvr_ValCheckRes() > 0){    //TODO check the results
//           			tnf.setFa_NoSaleReason(fvr.getFvr_Reason());
//           		}
           		if(outRR.getRr_RejectionNumber() > 0){
           			tnf.setFa_NoSaleReason(outRR.getRr_RejectionRestrictionDesc());
           		}
           	}
          	if(tnf.getFa_NoSaleReason().length()==0){
          		if (!tkt.getTd_ReservationRequired().equals("N")){
          			tnf.setFa_NoSaleReason("Ticket requires reservation");
          		}
          	}
           	
      		
     		tnf.setFa_FulfillmentMethod("CCST");
     		
           	//TODO get RCS flow data
           	
     		
     		boolean blnInclude = true;
     		
     		if((faresClass == 0) && (tnf.getFa_FareClass() != 1)){
     			blnInclude = false;
     		}
     		if((faresClass == 1) && (tnf.getFa_FareClass() != 2)){
     			blnInclude = false;
     		}
     		// Initial filtering
           	if(blnInclude &&  ((showAll) || (tnf.getFa_NoSaleReason().length() == 0))) {
           		resList.add(tnf);
           	}
        }
        resp.fares = resList;
        resp.trace = resp.trace + "Found " + resList.size();        
        return resp;           
      	
    }

	public static TicketDetails loadTicket(String pTicketCode, Date pDate){
		//
		// Manages the cache of tickets
		//
		TicketDetails tkt = null;
		if (ticketCodes.containsKey(pTicketCode)){
			// TODO check date matches
			// if not replace cache item with new loaded on.
			tkt = ticketCodes.getValue(pTicketCode);
		} else {
			tkt = ticketDetails.LoadTicketDetails(pTicketCode,pDate,"00001","00005"); // TODO Move constants to BB  00001 = TOC,  00005 = Mobile

			ticketCodes.put(pTicketCode,tkt);
		}
		return tkt;
	}
	

	
    public native static int loadFib(String s, byte[] buff);
    
    public native static int loadFib2(String s, byte[] buff, String trace);
    
   public native static TNSearchResults faresSearch(String p_OriginUIC, String p_DestinationUIC,
    		String p_OutDateTime, String p_ReturnDateTime, String p_CurrentDateTime,
    		int p_NumAdults, int p_NumChildren,	int p_NumAAA,
    		String p_RailcardCode, int p_VariableDiscount,boolean p_UseFutureFares,
		    String p_TicketCode, String p_Route);


    public native static TNSearchResults seasonFaresSearch(String p_OriginUIC, String p_DestinationUIC,
    		String p_Traveldate, String p_CurrentDate,
    		int p_NumAdults, int p_NumChildren,	
    		String p_RailcardCode, int p_VariableDiscount, int SeasonMonths,  int SeasonDays, 
		    String p_TicketCode, String p_Route);



    
    
}
