package com.example.twolibs.FaresBL;

import java.io.File;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import android.os.Environment;

import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareManager.SearchResponse;
import com.example.twolibs.SupportBL.DataConvert;

public class FareSetManager {
	
	public FareSet favouriteFareSet = null;
	public FareSet instantFareSet = null;
	
	public ArrayList<FareSet> favouriteFares = new ArrayList<FareSet>();
	public ArrayList<FareSet> instantFares = new ArrayList<FareSet>();

	public class STDResponse  {
		public int result = 0;
		public String extra = "";
		public String trace = "";
	}
	
	public STDResponse doLoad(AppContext bb){
	    	
		STDResponse resp = new STDResponse();
		resp.result = -1;
		resp.trace = "Begin";
	
	    favouriteFares = doLoadFavouritesXML();
	    instantFares = doLoadInstantXML();
	    
	    resp.trace = "Loaded";  
	    
	    return resp;        
		
	}
	   
	// Fare set related processing
	public static ArrayList<FareSet> doLoadFavouritesXML(){
	    	
	
        String locfile;
        // TODO from configuration
        locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/favourite_fareset.xml";
        
        return doLoadFareSetXML(locfile);

    }
	
	public static ArrayList<FareSet> doLoadInstantXML(){
    	
		
        String locfile;
        // TODO from configuration
        locfile = Environment.getExternalStorageDirectory() + "/com.example.twolibs/instant_fareset.xml";
        
        return doLoadFareSetXML(locfile);

    }	
	
	private static ArrayList<FareSet> doLoadFareSetXML(String locfile){
    	    	
    	ArrayList<FareSet> allFareSets = new ArrayList<FareSet>();
	
        File file = new File(locfile);
    	try {

     		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    		DocumentBuilder db = dbf.newDocumentBuilder();

    		Document doc = db.parse(file);
    		doc.getDocumentElement().normalize();

    		NodeList nodeList = doc.getElementsByTagName("fareSet");
    		for (int i = 0; i < nodeList.getLength(); i++) {

    			Node node = nodeList.item(i);
    			FareSet fareSet = FareSet.fromXML(node);
    			
    			// get the actual fares
    	    	allFareSets.add(fareSet);
    		}
 


		} catch (Exception e) {
			System.out.println("XML Pasing Excpetion = " + e);
		}
    	
    	return allFareSets;

    }    
	public static  ArrayList<FareSet> doSearchFareSet(String sSearch, ArrayList<FareSet> allFareSets){
    	
        ArrayList<FareSet> myList = new ArrayList<FareSet>();
        

        for(FareSet fareSet : allFareSets){
        	if(fareSet.faresetId.toUpperCase().startsWith(sSearch)){
        		myList.add(fareSet);
        	} else if(fareSet.faresetName.toUpperCase().contains(sSearch)){
        		myList.add(fareSet);
        	}    	
        	
        }
        
        return myList;
    	
    }
	
	public void setFavouriteFareSet(AppContext bb, String fareSetID){
    	
        favouriteFareSet = lookupFareSet(fareSetID, favouriteFares);      
        
        if (favouriteFareSet == null){
        	return;
        }
        setupPresetFares(bb, favouriteFareSet);
        
        return ;
    	
    }
	public void setInstantFareSet(AppContext bb, String fareSetID){
    	
        instantFareSet = lookupFareSet(fareSetID, instantFares);      
        
        if (instantFareSet == null){
        	return;
        }
        setupPresetFares(bb, instantFareSet);
        
        return ;
    	
    }
	
	public static FareSet lookupFareSet(String fareSetID, ArrayList<FareSet> allFareSets){
    	
        for(FareSet fareSet : allFareSets){
        	if(fareSet.faresetId.equals(fareSetID)){
        		return fareSet;
         	}    	
        	
        }
        
        return null;	
    }
	
	public void setupPresetFares(AppContext bb, FareSet fareSet){
    	
        for(TNSearchCriteria fareCriteria : fareSet.fareSearches){
        	
        	// Override dates
        	fareCriteria.CurrentDateTime = DataConvert.getNow();
        	fareCriteria.OutDateTime = DataConvert.getNow();
        	
        	SearchResponse resp = bb.fareManager.doSearch( fareCriteria,3 ,true);
        	if(resp.fares.size() > 0){
        		fareCriteria.PresetFare = resp.fares.get(0);
        	}
        }
        
        return ;
    	
    }	

	public ArrayList<TNFare> getPresetFares(AppContext bb, FareSet fareSet){
    	
        ArrayList<TNFare> fares = new ArrayList<TNFare>();

        if(fareSet != null){       	
	        for(TNSearchCriteria fareCriteria : fareSet.fareSearches){	        	
	        	if(fareCriteria.PresetFare != null){
	        		fares.add(fareCriteria.PresetFare);
	        	}
	        }
        }
        
        return fares;
    	
    }	
	
	public void addFareToSet(FareSet fareSet, TNFare fare){
    	
		TNSearchCriteria fareCriteria = new TNSearchCriteria();
		
		fareCriteria.OriginUIC = fare.getFa_FareOriginLocation();
		fareCriteria.DestinationUIC = fare.getFa_FareOriginLocation();
		fareCriteria.OutDateTime = null;
		fareCriteria.ReturnDateTime = null;
		fareCriteria.CurrentDateTime = null;
		fareCriteria.NumAdults = fare.getFa_NumAdults();
		fareCriteria.NumChildren = fare.getFa_NumChildren();
		fareCriteria.NumAAA = fare.getFa_NumAAA();
		fareCriteria.RailcardCode = fare.getFa_RailcardCode();
		fareCriteria.TicketCode = fare.getFa_TicketTypeCode();
		fareCriteria.RouteCode = fare.getFa_RouteCode();
		fareCriteria.Sequence = 0;
		fareCriteria.PresetFare = fare;
 
		fareSet.fareSearches.add(fareCriteria);
		int i = 0;
		for(TNSearchCriteria fc : fareSet.fareSearches){
			fc.PresetFare.itemSelected = 0;
			fc.Sequence = i++;
		}
        return;
    	
    }

}
