
package com.example.twolibs.FaresGUI;

import android.app.ListActivity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.Toast;

import com.example.twolibs.AppContext;
import com.example.twolibs.FaresBL.FareSet;
import com.example.twolibs.FaresBL.TNFare;
import com.example.twolibs.FaresBL.TNSearchCriteria;
import com.example.twolibs.R;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;


public class FareSetEdit extends ListActivity {
	// Support for menu switching
	int iCurrentMenu = -1;
	int iCurrentSelection = -1;
	
	ArrayList<TNFare> list = new ArrayList<TNFare>();
	TicketListAdaptor adapter;
	
	ListView listview;
    FareSet thisFareSet = new FareSet();
		  
    /** Called when the activity is first created. */

	int JMgetColor(int Color, android.content.res.Resources.Theme TH)
	{
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			return (getResources().getColor(Color, TH));
		}else{
			return (getResources().getColor(Color));
		}
	}
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fares_editset);
        
    	final AppContext bb  = (AppContext)getApplicationContext();
    		    
    	String faresetType = getIntent().getStringExtra("fareset");
    	if (faresetType.equals("instant")){
    		setTitle("Edit Instant");
    		thisFareSet = bb.fareSetManager.instantFareSet;
    	} else {
    		setTitle("Edit Favourite");
    		thisFareSet = bb.fareSetManager.favouriteFareSet;

    	} 
    	bb.fareSetManager.setupPresetFares(bb, thisFareSet);
    	list = bb.fareSetManager.getPresetFares(bb, thisFareSet);
   	

	    EditText txtFareSetId = (EditText)findViewById(R.id.txtFareSetId);
	    txtFareSetId.setText(thisFareSet.faresetId);
	    txtFareSetId.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
	        	thisFareSet.faresetId = s.toString();
	            doCheckComplete();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
	    
	    EditText txtFareSetName = (EditText)findViewById(R.id.txtFareSetName);
	    txtFareSetName.setText(thisFareSet.faresetName);
	    txtFareSetName.addTextChangedListener(new TextWatcher(){
	        public void afterTextChanged(Editable s) {
	        	thisFareSet.faresetName = s.toString();
	            doCheckComplete();
	        }
	        public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	        public void onTextChanged(CharSequence s, int start, int before, int count){}
	    }); 
        	        	        
        listview = (ListView) findViewById(android.R.id.list);
  
        adapter = new TicketListAdaptor(this,list,bb);
        setListAdapter(adapter);
 
        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> parent, final View view,
                int position, long id) {
            	
                // Clear the visual list
                for (int j = 0; j < parent.getChildCount(); j++){	
                	View rowView = (View) parent.getChildAt(j);
                	rowView.setBackgroundColor(Color.TRANSPARENT);
                }

                
                if (position == iCurrentSelection){
                    setMenu(0);
                    
                    // Null the selected journey
                    iCurrentSelection = -1;
                    list.get(position).itemSelected = 0;

            	} else {
            		
                    setMenu(1);
 
                    // Record the selected journey
                    iCurrentSelection = position;

	                // change the background colour of the selected element
                    list.get(position).itemSelected = 1;
                    // Keep this code in sync with adaptor
	                view.setBackgroundColor(JMgetColor(R.color.selection_background, getTheme()));
                }
            }

          });
        
           

		
		Button cmdSave = (Button) findViewById(R.id.cmdSave); 
		cmdSave.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
		
              	 Intent returnIntent = new Intent();
               	 //returnIntent.putExtra("result",list.get(position));
               	 setResult(RESULT_OK,returnIntent);
               	 finish();           	
			}  
			
		
		});
		
		Button cmdAdd = (Button) findViewById(R.id.cmdAdd); 
		cmdAdd.setOnClickListener(new OnClickListener() {  
		
			public void onClick(View view) {  
		
            	Intent nextScreen = new Intent(getApplicationContext(), FaresCriteria.class);  
            	nextScreen.putExtra("nextAction", "addToFareSet");
            	startActivityForResult(nextScreen, 2);
            	}  
		});
		
        doCheckComplete();

    }
 
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
     	AppContext bb  = (AppContext)getApplicationContext();

	    if (requestCode == 1) {
	    	//TODO
	    }
	    if (requestCode == 2) {
	        if(resultCode == RESULT_OK){
	        	 if(bb.selFare != null){
	        		 bb.fareSetManager.addFareToSet(thisFareSet, bb.selFare);
	        	 }
	        }
	        if (resultCode == RESULT_CANCELED) {
	            //Write your code if there's no result
	        }

	    }
	    doCheckComplete();		    

	}
	
	
	
	
    @SuppressWarnings("unchecked")
	void doCheckComplete(){
       	AppContext bb  = (AppContext)getApplicationContext();
    	
        Collections.sort(thisFareSet.fareSearches, new Comparator(){
        	
            public int compare(Object o1, Object o2) {
                TNSearchCriteria p1 = (TNSearchCriteria) o1;
                TNSearchCriteria p2 = (TNSearchCriteria) o2;
                return (p1.Sequence - p2.Sequence);
            }

        }); 

       	ArrayList<TNFare> newList = bb.fareSetManager.getPresetFares(bb, thisFareSet);

        adapter.clear();
        adapter.addAll(newList);
        adapter.notifyDataSetChanged();
        
    }

    private void setMenu(int iMenu){
    	if (iMenu == iCurrentMenu){
    		// No change required
    	} else {
    		// Delete the current
            LinearLayout layFormMenu = (LinearLayout)findViewById(R.id.layFormMenu);  
            layFormMenu.removeAllViews();               
             // Create new LayoutInflater - this has to be done this way, as you can't directly inflate an XML without creating an inflater object first             

             LayoutInflater inflater = getLayoutInflater();   
             if (iMenu == 0) {
                 layFormMenu.addView(inflater.inflate(R.layout.fareset_menu0, null));
 
                 // setup callbacks
         		Button cmdSave = (Button) findViewById(R.id.cmdSave); 
        		cmdSave.setOnClickListener(new OnClickListener() {  
        		
        			public void onClick(View view) {  
        		
                      	 Intent returnIntent = new Intent();
                       	 //returnIntent.putExtra("result",list.get(position));
                       	 setResult(RESULT_OK,returnIntent);
                       	 finish();           	
        			}  
        			
        		
        		});
        		Button cmdAdd = (Button) findViewById(R.id.cmdAdd); 
        		cmdAdd.setOnClickListener(new OnClickListener() {  
        		
        			public void onClick(View view) {  
        		
                    	Intent nextScreen = new Intent(getApplicationContext(), FaresCriteria.class);  
                    	nextScreen.putExtra("nextAction", "addToFareSet");
                    	startActivityForResult(nextScreen, 2);
                    	}  
        		});
                 
        		Button cmdDelete = (Button) findViewById(R.id.cmdDelete); 
        		cmdDelete.setOnClickListener(new OnClickListener() {  
        		
        			public void onClick(View view) {  
        		
        				//TODO
        	    		Toast.makeText(FareSetEdit.this, "Delete not implemented", Toast.LENGTH_SHORT).show();;

                    	}  
        		});

                 
             } else {
                 layFormMenu.addView(inflater.inflate(R.layout.fareset_menu1, null));

                 // TODO menu1
                 // setup callbacks
         		Button cmdUp = (Button) findViewById(R.id.cmdUp); 
         		cmdUp.setOnClickListener(new OnClickListener() {  
        		
        			public void onClick(View view) {  
    					int iSel = iCurrentSelection;
     		
        				if((iSel > 0)  && (iSel < thisFareSet.fareSearches.size())){
        					int sequence1 = thisFareSet.fareSearches.get(iSel).Sequence;
        					int sequence2 = thisFareSet.fareSearches.get(iSel-1).Sequence;
        					thisFareSet.fareSearches.get(iSel).Sequence = sequence2;
        					thisFareSet.fareSearches.get(iSel-1).Sequence = sequence1;
        					list.get(iSel).itemSelected = 1;
        					list.get(iSel - 1).itemSelected = 0;
        					iCurrentSelection -= 1;
        					
        				}
        			    doCheckComplete();

        			}  
       			
        		
        		});
    			Button cmdDown = (Button) findViewById(R.id.cmdDown); 
    			cmdDown.setOnClickListener(new OnClickListener() {  
    			
    				public void onClick(View view) {  
    					int iSel = iCurrentSelection;
    					
        				if((iSel >= 0)  && (iSel < (thisFareSet.fareSearches.size() -1))){
        					int sequence1 = thisFareSet.fareSearches.get(iSel).Sequence;
        					int sequence2 = thisFareSet.fareSearches.get(iSel+1).Sequence;
        					thisFareSet.fareSearches.get(iSel).Sequence = sequence2;
        					thisFareSet.fareSearches.get(iSel+1).Sequence = sequence1;
        					list.get(iSel).itemSelected = 1;
        					list.get(iSel + 1).itemSelected = 0;
        					iCurrentSelection += 1;
        					
        				}
        			    doCheckComplete();
    	            }  
    			});
    			Button cmdDelete = (Button) findViewById(R.id.cmdDelete); 
    			cmdDelete.setOnClickListener(new OnClickListener() {  
    			
    				public void onClick(View view) {  
    			
    					int iSel = iCurrentSelection;
    					
        				if((iSel >= 0)  && (iSel < (thisFareSet.fareSearches.size()))){
        					thisFareSet.fareSearches.remove(iCurrentSelection);
        					iCurrentSelection = -1;
        				}
        				doCheckComplete();
    	            }  
    			});

                 
           }  		
    		
    		// Setup the new
    		iCurrentMenu = iMenu;
    	}
    	
    }

    @Override
    public Intent getParentActivityIntent() {

    	Intent newIntent = null;
    	// ToDo 
    	newIntent = new Intent(getApplicationContext(), FareSetChoice.class); 
          
        return newIntent;
          
     }
    


}