package com.example.twolibs.FaresGUI;

import java.util.ArrayList;

import com.example.twolibs.R;
import com.example.twolibs.FaresBL.FareSet;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;

import android.app.Activity;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class FareSetListAdaptor extends ArrayAdapter<FareSet> {
	private final Activity context;
	private final ArrayList<FareSet> fareSetList;
	
	
	static class ViewHolder {
		public TextView txtDescription;
	}
		
	public FareSetListAdaptor(Activity context,ArrayList<FareSet> fareSetList) {
		super(context, R.layout.duty_summary, fareSetList);
		this.context = context;
		this.fareSetList = fareSetList;
	}
		
		  @Override
	public View getView(int position, View convertView, ViewGroup parent) {
		View rowView = convertView;
		// reuse views
		if (rowView == null) {
			LayoutInflater inflater = context.getLayoutInflater();
			rowView = inflater.inflate(R.layout.duty_summary, null);
			// configure view holder
			ViewHolder viewHolder = new ViewHolder();
			viewHolder.txtDescription = (TextView) rowView.findViewById(R.id.txtDescription);
			rowView.setTag(viewHolder);
		}
		
		// fill data
		ViewHolder holder = (ViewHolder) rowView.getTag();

		// Do this to negate any selected row
	    rowView.setBackgroundColor(Color.TRANSPARENT);

	    FareSet fs = fareSetList.get(position);
		holder.txtDescription.setText(fs.faresetId + " " + fs.faresetName);
		
		
		return rowView;
	}
  
}
