
package com.example.twolibs.FaresGUI;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyGUI.DutyMain;
import com.example.twolibs.FaresBL.FareSet;
import com.example.twolibs.R.id;
import com.example.twolibs.R.layout;

import android.app.ActionBar;
import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;


public class FareSetLookup extends ListActivity 
	{
		ArrayList<FareSet> list = new ArrayList<FareSet>();
		FareSetListAdaptor adapter;
		
		ListView listview;
		
			  
	    /** Called when the activity is first created. */
		
	    @Override
	    public void onCreate(Bundle savedInstanceState)
	    {
	        super.onCreate(savedInstanceState);
	        setContentView(R.layout.activity_fares_selset);

	        AppContext bb  = (AppContext)getApplicationContext();
	        
	        
	        ActionBar actionBar = getActionBar(); 
	        actionBar.hide();
	        
	        // Load the right fares set list
		    //allDutys = bb.fareManager.doLoadFavouritesXML();
	        
		    final ArrayList<FareSet> allFareSets;
	    	final String faresetType = getIntent().getStringExtra("fareset");
	    	TextView capTitle = (TextView) findViewById(R.id.capTitle);
	    	if (faresetType.equals("instant")){
	    		setTitle("Instant");
	    		capTitle.setText("Instant");
	    		allFareSets = bb.fareSetManager.instantFares;
	    	} else {
	    		setTitle("Favourite");
	    		capTitle.setText("Favourite");
	    		allFareSets = bb.fareSetManager.favouriteFares;

	    	} 

	       listview = (ListView) findViewById(android.R.id.list);
	  
	        adapter = new FareSetListAdaptor(this,list);
	        setListAdapter(adapter);

	 
	        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {

	            @Override
	            public void onItemClick(AdapterView<?> parent, final View view,
	                int position, long id) {

	            	
	    	       	AppContext bb  = (AppContext)getApplicationContext();
	    	       	
	    	    	if (faresetType.equals("instant")){
	    	    		bb.fareSetManager.setInstantFareSet( bb, list.get(position).faresetId);
	    	    	} else {
	    	    		bb.fareSetManager.setFavouriteFareSet( bb, list.get(position).faresetId);

	    	    	}	    	        
	              	Intent returnIntent = new Intent();
	               	//returnIntent.putExtra("result",list.get(position));
	               	setResult(RESULT_OK,returnIntent);
	               	finish();           	
	 
	            }

	          });
	        
	        

	        doSearch(allFareSets);

	        LinearLayout frmTitle = (LinearLayout)findViewById(R.id.frmTitle);
	        frmTitle.setOnClickListener(new OnClickListener() {  
				
				public void onClick(View view) {  
			
					dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN,	KeyEvent.KEYCODE_BACK));
					dispatchKeyEvent(new KeyEvent(KeyEvent.ACTION_UP, KeyEvent.KEYCODE_BACK));
				}  
				
			
			}); 
	       
	        EditText txtSearch = (EditText)findViewById(R.id.txtSearch);
	        txtSearch.addTextChangedListener(new TextWatcher(){
	            public void afterTextChanged(Editable s) {
	            	doSearch(allFareSets);
	            }
	            public void beforeTextChanged(CharSequence s, int start, int count, int after){}
	            public void onTextChanged(CharSequence s, int start, int before, int count){}
	        }); 
	        
	        txtSearch.requestFocus();               

	    }
	    
	    public void doSearch(ArrayList<FareSet> baseList){
	    	
	        String sProgress;

	        ArrayList<FareSet> myList;
	   	
	    	EditText et = (EditText) findViewById(R.id.txtSearch);
	        String sSearch = et.getText().toString().toUpperCase();
	        AppContext bb  = (AppContext)getApplicationContext();
	 	         
	        myList= bb.fareSetManager.doSearchFareSet(sSearch,baseList);
	        
	        sProgress = sSearch + "Res " + myList.size() + " ";
	        
//	        tv.setText(sProgress);
	            
	        adapter.clear();
	        adapter.addAll(myList);
	        adapter.notifyDataSetChanged();
	    	
	    }


	    @Override
	    public Intent getParentActivityIntent() {

	    	Intent newIntent = null;
	    	// ToDo 
	    	newIntent = new Intent(getApplicationContext(), DutyMain.class); 
	          
	        return newIntent;
	          
	     }
	    


}