package com.example.twolibs.FaresGUI;


import java.util.Date;

import com.example.twolibs.AppContext;
import com.example.twolibs.R;
import com.example.twolibs.DutyBL.DutyManager;
import com.example.twolibs.DutyBL.DutyTaskType;
import com.example.twolibs.DutyBL.DutyTaskType.TaskSpecialAction;
import com.example.twolibs.LocationBL.Location;
import com.example.twolibs.LocationGUI.LocationLookup;
import com.example.twolibs.SupportBL.DataConvert;
import com.example.twolibs.SupportGUI.PassengerPicker;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;


public class FaresCriteria  extends Activity {
	
	Activity activity;
	String nextAction = "";
	
	 public void onCreate(Bundle savedInstanceState)
	   {
	      super.onCreate(savedInstanceState);
	      
	      setContentView(R.layout.activity_farescriteria);
       	  final AppContext bb  = (AppContext)getApplicationContext();
	      activity = this.getParent();
  
	        Intent intent = getIntent();
	        if(intent != null){
	        	// (if it was null then somebody hit cancel to get here so we don't need to look further)
		        nextAction = intent.getStringExtra("nextAction");
		        if(nextAction != null){
			        if(nextAction.equals("addToFareSet")) {
			        	// Do the requested search
			    		setTitle(" Add fare");

			        } else {
			    		setTitle(" Fares");
			        	
			        }
		        } else {
		        	nextAction = "";
		        }
	        }

	        // Setup the context for the search
	        setContext(bb);

	        TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
		  txtOrigin.setText(bb.getOrigin().getDescription());
		  
		  LinearLayout cmdOrigin = (LinearLayout) findViewById(R.id.frmOrigin); 
		  
			cmdOrigin.setOnClickListener(new OnClickListener() {  
			
				public void onClick(View view) {  
			
				Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);
				
				//Sending data to another Activity                 
				nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.FROM_SEARCH);
				nextScreen.putExtra("search", "fares");
			
				//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
			    startActivityForResult(nextScreen, 1);
				}  
				
			
			}); 
			
		      TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
			  txtDestination.setText(bb.getDestination().getDescription());
			  
			  LinearLayout cmdDestination = (LinearLayout) findViewById(R.id.frmDestination); 
			  
				cmdDestination.setOnClickListener(new OnClickListener() {  
				
					public void onClick(View view) {  
				
					Intent nextScreen = new Intent(getApplicationContext(), LocationLookup.class);
			        
					//Sending data to another Activity                 
			        nextScreen.putExtra(AppContext.CALL_CONTEXT, LocationLookup.CallingContext.TO_SEARCH);
					nextScreen.putExtra("search", "fares");

					//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
			        startActivityForResult(nextScreen, 2);
					}  
					

				}); 
				
				  LinearLayout frmPassengers = (LinearLayout) findViewById(R.id.frmPassengers); 
				  
				  frmPassengers.setOnClickListener(new OnClickListener() {  
					
						public void onClick(View view) {  
					
						Intent nextScreen = new Intent(getApplicationContext(), PassengerPicker.class);
				        
						//TODO Sending data to another Activity                 
				        nextScreen.putExtra("direction", "to");
						nextScreen.putExtra("search", "fares");

						//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
				        startActivityForResult(nextScreen, 4);
						}  
						

					}); 
				
				
				
				
		      TextView txtDate = (TextView) findViewById(R.id.txtDate);
			  txtDate.setText(DataConvert.displayTextDate(bb.getSearchDate()));

			  LinearLayout cmdDate = (LinearLayout) findViewById(R.id.frmDate); 
							
				cmdDate.setOnClickListener(new OnClickListener() {  
				
					public void onClick(View view) {  
				
		        		Date searchDate = bb.getSearchDate();
		        		
		        	    int year = DataConvert.getYear(searchDate);
						int month = DataConvert.getMonth(searchDate);
						int day = DataConvert.getDayOfMonth(searchDate);
												
						DatePickerDialog dialog = new DatePickerDialog(FaresCriteria.this, datePickerListener, year,month,day);
						dialog.show();

					} 
					
					private DatePickerDialog.OnDateSetListener datePickerListener 
						= new DatePickerDialog.OnDateSetListener() {

				        // when dialog box is closed, below method will be called.
					        public void onDateSet(DatePicker view, int selectedYear,
							            int selectedMonth, int selectedDay) {
					        		
					        		Date searchDate = bb.getSearchDate();

					        		bb.setSearchDate(DataConvert.setDate(searchDate, 
					        				selectedYear, selectedMonth, selectedDay));
					        		
					        		TextView txtDate = (TextView) findViewById(R.id.txtDate);
					    			txtDate.setText(DataConvert.displayTextDate(bb.getSearchDate()));
					        		
							        }
							};
					}); 

			      TextView txtAdults = (TextView) findViewById(R.id.txtAdults);
			      txtAdults.setText(String.valueOf(bb.getNumAdults()));

			      TextView txtChildren = (TextView) findViewById(R.id.txtChildren);
				  txtChildren.setText(String.valueOf(bb.getNumChildren()));

				  
			      TextView txtRailcard = (TextView) findViewById(R.id.txtRailcard);
			      txtRailcard.setText("None");
			 

				
			      CheckBox checkShowAllFares = (CheckBox) findViewById(R.id.checkShowAllFares); 
			      checkShowAllFares.setChecked(bb.getShowAllFares());
			      checkShowAllFares.setOnClickListener(new OnClickListener() {  

			        	public void onClick(View view) {  

						CheckBox checkShowAllFares = (CheckBox) findViewById(R.id.checkShowAllFares); 
		                bb.setShowAllFares(checkShowAllFares.isChecked());
			        	
		                Toast.makeText(FaresCriteria.this, "checkShowAllFares " + bb.getShowAllFares(), Toast.LENGTH_SHORT).show();  
						} 
			        	
			        	
			        });
			         
		        Button cmdSearch = (Button) findViewById(R.id.cmdSearch);
		        cmdSearch.setOnClickListener(new OnClickListener() {  

		        	public void onClick(View view) {  

		        		// read the sort defaults
		        		int sortID;
		        		
					    RadioGroup radioClass = (RadioGroup) findViewById(R.id.radioClass);
					    sortID =  radioClass.getCheckedRadioButtonId();
					    if (sortID == R.id.radioFirst){
					    	bb.faresClass = 0;
					    } else if (sortID == R.id.radioStandard){
					    	bb.faresClass = 1;
					    } else {
					    	bb.faresClass = 2; //Both		    
					    }

					    
					    RadioGroup radioSortTypeGroup = (RadioGroup) findViewById(R.id.radioSortType);
					    sortID =  radioSortTypeGroup.getCheckedRadioButtonId();
					    if (sortID == R.id.radioPrice){
					    	bb.faresSortType = 0;
					    } else {
					    	bb.faresSortType = 1;				    
					    }
						
					    RadioGroup radioSortOrderGroup = (RadioGroup) findViewById(R.id.radioSortOrder);
					    sortID =  radioSortOrderGroup.getCheckedRadioButtonId();
					    if (sortID == R.id.radioAscending){
					    	bb.faresSortOrder = 0;
					    } else {
					    	bb.faresSortOrder = 1;				    
					    }
															      
			        	//Toast.makeText(FaresCriteria.this, "F1 Search Clicked", Toast.LENGTH_SHORT).show();  
			        	//Starting a new Intent                 
		                
						Intent nextScreen = new Intent(getApplicationContext(), FaresLookup.class);                   
						//Sending data to another Activity
						if (nextAction.equals("")){
							nextScreen.putExtra("nextAction", "search");
					        startActivityForResult(nextScreen, 3);
						} else {
							nextScreen.putExtra("nextAction", nextAction);
					        startActivityForResult(nextScreen, 5);
						}
						//Log.e("n", inputName.getText()+"."+ inputEmail.getText());
						//startActivity(nextScreen); 
					} 
		        	
		        	
		        }); 		
		        
			      doCheckComplete();
			
	   }
	 
	    public void setContext(AppContext bb){
	     	//
	     	// The origin and destination is dependent on the context
	     	// Add settings control
	     	//
	    	
	     	if(DutyManager.activeTask == null){
	     		// No context established
	     		// Use last search
	     	} else {
	     		// Check the context
	     		DutyTaskType dutyTaskType = DutyTaskType.getTaskType(DutyManager.activeTask.taskType);
	     		
	     		if(dutyTaskType.taskSpecialAction == TaskSpecialAction.QUEUE_BUST){
	     			// Default origin to current location
	     			bb.setOrigin(DutyManager.activeTask.taskLocationFrom);
	     		} else if(dutyTaskType.taskSpecialAction == TaskSpecialAction.EXCESS_FARE){
	     			// Default origin to current location
	     			bb.setDestination(DutyManager.activeTask.taskLocationFrom);
	     		} else if(dutyTaskType.taskSpecialAction == TaskSpecialAction.BOARD_TRAIN){
	     			// Default origin and destination
	     			bb.setOrigin(DutyManager.activeTask.taskLocationFrom);
	     			bb.setDestination(DutyManager.activeTask.taskLocationTo);
	     		}
	     	}
	    	
	    }
		@Override
		protected void onActivityResult(int requestCode, int resultCode, Intent data) {

		    if (requestCode == 1) {
		        if(resultCode == RESULT_OK){
		        	Location origin = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);
		            
		         	AppContext bb  = (AppContext)getApplicationContext();
		         	bb.setOrigin(origin);

					TextView txtOrigin = (TextView) findViewById(R.id.txtOrigin);
					txtOrigin.setText(origin.getDescription());
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 2) {
		        if(resultCode == RESULT_OK){
		        	Location destination = (Location) data.getSerializableExtra(AppContext.CALL_RESULT_DATA);

		         	AppContext bb  = (AppContext)getApplicationContext();
		         	bb.setDestination(destination);
		            
		         	TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
		         	txtDestination.setText(destination.getDescription() );
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 3) {
		        if(resultCode == RESULT_OK){
		        	// retrieve pass any next action upwards 
       			 	String nextAction = data.getStringExtra("nextAction");
       			 	if(nextAction.length() != 0){
	                  	Intent returnIntent = new Intent();
	                  	
	                    returnIntent.putExtra("nextAction",nextAction);	
	                 	setResult(RESULT_OK, returnIntent);
	         			  
	                 	finish();
       			 	}
		        	
		        	// Journey selected?
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }
		    }
		    if (requestCode == 4) {
		        if(resultCode == RESULT_OK){
		        	
		          AppContext bb  = (AppContext)getApplicationContext();
		    
			      TextView txtAdults = (TextView) findViewById(R.id.txtAdults);
			      txtAdults.setText(String.valueOf(bb.getNumAdults()));
	
			      TextView txtChildren = (TextView) findViewById(R.id.txtChildren);
				  txtChildren.setText(String.valueOf(bb.getNumChildren()));
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }

		    }

		    if (requestCode == 4) {
		        if(resultCode == RESULT_OK){
		        	
		          AppContext bb  = (AppContext)getApplicationContext();
		    
			      TextView txtAdults = (TextView) findViewById(R.id.txtAdults);
			      txtAdults.setText(String.valueOf(bb.getNumAdults()));
	
			      TextView txtChildren = (TextView) findViewById(R.id.txtChildren);
				  txtChildren.setText(String.valueOf(bb.getNumChildren()));
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }

		    }
		    if (requestCode == 5) {
		        if(resultCode == RESULT_OK){
		         	 Intent returnIntent = new Intent();
		           	 //returnIntent.putExtra("result",list.get(position));
		           	 setResult(RESULT_OK,returnIntent);
		           	 finish();           	
		        }
		        if (resultCode == RESULT_CANCELED) {
		            //Write your code if there's no result
		        }

		    }

		    doCheckComplete();

		}

	    @Override
	    public boolean onCreateOptionsMenu(Menu menu) {
	    	// Inflate the menu items for use in the action bar
	    	MenuInflater inflater = getMenuInflater();
	    	inflater.inflate(R.menu.menu_logon, menu);
	    	return super.onCreateOptionsMenu(menu);
	    	}

	    public boolean onOptionsItemSelected(MenuItem item) {
	    	// Handle item selection     
	    	if (item.getItemId() == R.id.cmdSync) {
				Toast.makeText(FaresCriteria.this, "sync data", Toast.LENGTH_SHORT).show();
				return true;
			}
			if (item.getItemId() == R.id.cmdHelp) {
				Toast.makeText(FaresCriteria.this, "help dialogue", Toast.LENGTH_SHORT).show();
				return true;
			}
            return super.onOptionsItemSelected(item);
		}

		int JMgetColor(int Color, android.content.res.Resources.Theme TH)
		{
			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
				return (getResources().getColor(Color, TH));
			}
			return (getResources().getColor(Color));
		}

	    void doCheckComplete(){
	        Button cmdSearch = (Button) findViewById(R.id.cmdSearch);
			TextView txtOrigin =  findViewById(R.id.txtOrigin);
			String strOrigin = txtOrigin.getText().toString();
			TextView txtDestination = (TextView) findViewById(R.id.txtDestination);
			String strDestination = txtDestination.getText().toString();

	    	if((strOrigin.length() > 0) && (strDestination.length() > 0)){
	    		cmdSearch.setEnabled(true);
	    		cmdSearch.setBackgroundColor(JMgetColor(R.color.button_background, getTheme()));
	    	} else {
	    		cmdSearch.setEnabled(false);
	    		cmdSearch.setBackgroundColor(JMgetColor(R.color.button_background_disabled, getTheme()));
	  		
	    	}
	    	
	    }
} 
